/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal;

import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;

public class JsonUtils {
    public static String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(src.length() + 20);
        block8: for (int ii = 0; ii < src.length(); ++ii) {
            char c = src.charAt(ii);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    buf.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        buf.append(c);
                        continue block8;
                    }
                    buf.append(JsonUtils.escapeUnicode(c));
                }
            }
        }
        return buf.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(src.length());
        int ii = 0;
        while (ii < src.length()) {
            char c;
            if ((c = src.charAt(ii++)) == '\\') {
                if (ii == src.length()) {
                    throw new IllegalArgumentException("escape extends past end of string");
                }
                c = src.charAt(ii++);
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        c = JsonUtils.unescapeUnicode(src, ii);
                        ii += 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid escape character: " + c);
                    }
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static char unescapeUnicode(String src, int idx) {
        if (idx + 4 > src.length()) {
            throw new IllegalArgumentException("unicode escape extends past end of string");
        }
        int value = 0;
        for (int ii = 0; ii < 4; ++ii) {
            int digit = StringUtil.parseDigit(src.charAt(idx + ii), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("invalid unicode escape: " + src.substring(idx, idx + 4));
            }
            value = value * 16 + digit;
        }
        return (char)value;
    }

    private static String escapeUnicode(char c) {
        char[] buf = new char[]{'\\', 'u', '0', '0', '0', '0'};
        int value = c & 0xFFFF;
        for (int ii = 5; ii > 1; --ii) {
            int digit = value % 16;
            value /= 16;
            buf[ii] = Character.forDigit(digit, 16);
        }
        return new String(buf);
    }
}

