/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util;

public class ByteQueue {
    byte[] data;
    int head;
    int tail;
    int length;
    int capacity;
    int initialCapacity;
    boolean dynamicSize;

    public ByteQueue(int capacity) {
        this.capacity = this.initialCapacity = capacity;
        this.dynamicSize = false;
        this.data = new byte[capacity];
        this.clear();
    }

    public void clear() {
        this.head = -1;
        this.tail = 0;
        this.length = 0;
    }

    public void push(byte b) {
        if (this.dynamicSize && this.length >= this.capacity && this.capacity * 2 >= this.initialCapacity) {
            this.setCapacity(this.capacity * 2);
        }
        this.head = (this.head + 1) % this.capacity;
        this.data[this.head] = b;
        ++this.length;
    }

    public void push4(byte b1, byte b2, byte b3, byte b4) {
        this.push(b1);
        this.push(b2);
        this.push(b3);
        this.push(b4);
    }

    public byte pop() {
        if (this.length < 1) {
            System.err.println("ByteQueue array is empty! couldn't pop");
            return -128;
        }
        byte b = this.data[this.tail];
        this.tail = (this.tail + 1) % this.capacity;
        --this.length;
        if (this.dynamicSize && this.length <= this.capacity / 2 && this.capacity / 2 >= this.initialCapacity) {
            this.setCapacity(this.capacity / 2);
        }
        return b;
    }

    public boolean pop4(byte[] b) {
        if (this.length < 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            b[i] = this.pop();
        }
        return true;
    }

    private void setCapacity(int newCapacity) {
        byte[] newData = new byte[newCapacity];
        int i = this.tail;
        for (int c = 0; c < this.length; ++c) {
            newData[c] = this.data[i];
            i = (i + 1) % this.capacity;
        }
        this.capacity = newCapacity;
        this.data = newData;
        this.tail = 0;
        this.head = this.length - 1;
    }

    public int length() {
        return this.length;
    }
}

