/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util;

import eu.ha3.matmos.Matmos;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.Sys;

public class MAtUtil {
    private static final Random random = new Random();

    public static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static int getPlayerX() {
        return (int)Math.floor(MAtUtil.getPlayer().field_70165_t);
    }

    public static int getPlayerY() {
        return (int)Math.floor(MAtUtil.getPlayer().field_70163_u + (double)MAtUtil.getPlayer().func_70047_e());
    }

    public static int getPlayerZ() {
        return (int)Math.floor(MAtUtil.getPlayer().field_70161_v);
    }

    public static BlockPos getPlayerPos() {
        return new BlockPos(MAtUtil.getPlayerX(), MAtUtil.getPlayerY(), MAtUtil.getPlayerZ());
    }

    public static boolean isUnderwaterAnyGamemode() {
        return MAtUtil.getPlayer().func_70055_a(Material.field_151586_h);
    }

    public static boolean isWithinBounds(BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < MAtUtil.getWorld().func_72800_K();
    }

    public static int clampToBounds(int y) {
        return Math.min(Math.max(0, y), MAtUtil.getWorld().func_72800_K() - 1);
    }

    public static Block getBlockAt(BlockPos pos) {
        return MAtUtil.getWorld().func_180495_p(pos).func_177230_c();
    }

    public static String getNameAt(BlockPos pos, String defaultIfFail) {
        if (!MAtUtil.isWithinBounds(pos)) {
            return defaultIfFail;
        }
        return MAtUtil.nameOf(MAtUtil.getBlockAt(pos));
    }

    public static String nameOf(Block block) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
    }

    public static String nameOf(ItemStack itemStack) {
        return MAtUtil.nameOf(itemStack.func_77973_b());
    }

    public static String nameOf(Item item) {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
    }

    public static boolean isSoundMasterEnabled() {
        return Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f;
    }

    public static boolean isSoundAmbientEnabled() {
        return Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.AMBIENT) > 0.0f;
    }

    public static void playSound(String name, float nx, float ny, float nz, float volume, float pitch, int attenuation, float rollf) {
        MAtUtil.playSound(nx, ny, nz, name, volume, pitch);
    }

    public static void playSound(String name, float nx, float ny, float nz, float volume, float pitch) {
        MAtUtil.playSound(nx, ny, nz, name, volume, pitch);
    }

    public static void playSound(String name, float volume, float pitch) {
        EntityPlayerSP ply = Minecraft.func_71410_x().field_71439_g;
        float sx = ply != null ? (float)ply.field_70165_t : 0.0f;
        float sy = ply != null ? (float)ply.field_70163_u : 0.0f;
        float sz = ply != null ? (float)ply.field_70161_v : 0.0f;
        MAtUtil.playSound(name, sx, sy, sz, volume, pitch);
    }

    private static void playSound(float x, float y, float z, String soundName, float volume, float pitch) {
        PositionedSoundRecord positionedsoundrecord = new PositionedSoundRecord(new ResourceLocation(soundName), SoundCategory.AMBIENT, volume, pitch, false, 0, ISound.AttenuationType.LINEAR, x, y, z);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)positionedsoundrecord);
    }

    public static String getPowerMetaAt(BlockPos pos, String defaultIfFail) {
        if (!MAtUtil.isWithinBounds(pos)) {
            return defaultIfFail;
        }
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
        return MAtUtil.asPowerMeta(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static String asPowerMeta(ItemStack item) {
        return MAtUtil.asPowerMeta(MAtUtil.nameOf(item.func_77973_b()), item.func_77960_j());
    }

    public static String asPowerMeta(Block block, int meta) {
        return MAtUtil.asPowerMeta(MAtUtil.nameOf(block), meta);
    }

    private static String asPowerMeta(String block, int meta) {
        return block + "^" + Integer.toString(meta);
    }

    public static int getMetaAt(BlockPos pos, int defaultIdFail) {
        IBlockState state = MAtUtil.getWorld().func_180495_p(pos);
        return state.func_177230_c().func_176201_c(state);
    }

    public static String getMetaAsStringAt(BlockPos pos, String defaultIfFail) {
        if (!MAtUtil.isWithinBounds(pos)) {
            return defaultIfFail;
        }
        return Integer.toString(MAtUtil.getMetaAt(pos, 0));
    }

    public static int legacyOf(ItemStack itemStack) {
        return Item.field_150901_e.func_148757_b((Object)itemStack.func_77973_b());
    }

    public static int legacyOf(Block block) {
        return Block.field_149771_c.func_148757_b((Object)block);
    }

    public static String sanitizeUniqueName(String name) {
        return name.replaceAll("[^a-zA-Z0-9.-_]", "");
    }

    public static boolean canSeeSky(BlockPos pos) {
        return MAtUtil.getWorld().func_175710_j(pos);
    }

    public static float randomFloatRange(float min, float max) {
        return min + (max - min) * random.nextFloat();
    }

    public static void openFolder(File folder) {
        String s = folder.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.OSX) {
            try {
                Matmos.LOGGER.info(s);
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                return;
            }
            catch (IOException ioexception1) {
                Matmos.LOGGER.error("Couldn't open file", (Throwable)ioexception1);
            }
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
            try {
                Runtime.getRuntime().exec(s1);
                return;
            }
            catch (IOException ioexception) {
                Matmos.LOGGER.error("Couldn't open file", (Throwable)ioexception);
            }
        }
        boolean flag = false;
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, folder.toURI());
        }
        catch (Throwable throwable) {
            Matmos.LOGGER.error("Couldn't open link", throwable);
            flag = true;
        }
        if (flag) {
            Matmos.LOGGER.info("Opening via system class!");
            Sys.openURL((String)("file://" + s));
        }
    }

    public static Path getParentSafe(Path p) {
        if (p == null || p.getParent() == null) {
            return Paths.get("", new String[0]);
        }
        return p.getParent();
    }

    public static ServerData getCurrentServerData() {
        return Minecraft.func_71410_x().func_147104_D();
    }

    public static int metaOf(ItemStack item) {
        return item.func_77960_j();
    }

    public static String getItemName(Item item) {
        ResourceLocation rl = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        return rl == null ? null : rl.toString();
    }

    public static void setSoundLevel(SoundCategory cat, float level) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        settings.func_186712_a(cat, level);
    }

    public static Profiler getProfiler() {
        return Minecraft.func_71410_x().field_71424_I;
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static Item itemRegistryGet(String name) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
    }

    public static boolean blockRegistryContains(String name) {
        return Block.field_149771_c.func_148741_d((Object)new ResourceLocation(name));
    }

    public static Block blockRegistryGet(String name) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
    }

    public static int getPotionEffectID(PotionEffect effect) {
        return Potion.func_188409_a((Potion)effect.func_188419_a());
    }
}

