/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.betterwithmods.base.blockrecipes;

import betterwithmods.common.registry.block.managers.CraftingManagerBlock;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.BlockRecipe;
import com.blamejared.ModTweaker;
import com.blamejared.compat.betterwithmods.base.RemoveAll;
import com.blamejared.compat.betterwithmods.base.blockrecipes.BlockRecipeAdd;
import com.blamejared.compat.betterwithmods.base.blockrecipes.BlockRecipeRemove;
import com.blamejared.compat.betterwithmods.base.blockrecipes.BlockRecipeRemoveInput;
import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenMethod;

public abstract class BlockRecipeBuilder<T extends BlockRecipe> {
    protected BlockIngredient input;
    protected List<ItemStack> outputs;
    private Supplier<CraftingManagerBlock<T>> registry;
    protected String name;

    public BlockRecipeBuilder(Supplier<CraftingManagerBlock<T>> registry, String name) {
        this.registry = registry;
        this.name = name;
    }

    protected void addRecipe(T recipe) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new BlockRecipeAdd<T>(this.name, this.registry.get(), recipe));
    }

    @ZenMethod
    public abstract void build();

    public void removeRecipe(IItemStack[] output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new BlockRecipeRemove<T>(this.name, this.registry.get(), output));
    }

    public void removeRecipe(IItemStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new BlockRecipeRemoveInput<T>(this.name, this.registry.get(), input));
    }

    public void _buildRecipe(IIngredient input, IItemStack[] outputs) {
        this.input = new BlockIngredient(CraftTweakerMC.getIngredient((IIngredient)input));
        this.outputs = InputHelper.toNonNullList((Object[])CraftTweakerMC.getItemStacks((IItemStack[])outputs));
    }

    @ZenMethod
    public BlockRecipeBuilder<? extends BlockRecipe> setInputBlockDrop(IItemStack input) {
        this.input = new BlockDropIngredient(new ItemStack[]{CraftTweakerMC.getItemStack((IItemStack)input)});
        return this;
    }

    @ZenMethod
    public BlockRecipeBuilder<? extends BlockRecipe> setInputBlockDrop(IItemStack[] inputs) {
        this.input = new BlockDropIngredient(CraftTweakerMC.getItemStacks((IItemStack[])inputs));
        return this;
    }

    @ZenMethod
    public void removeAll() {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveAll(this.name, this.registry.get().getRecipes()));
    }

    public String getName() {
        return this.name;
    }
}

