/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import pl.asie.debark.BlockDebarkedLog;
import pl.asie.debark.BlockDebarkedLogEntry;
import pl.asie.debark.DebarkBlockEntry;
import pl.asie.debark.DebarkProxyCommon;
import pl.asie.debark.DebarkShapelessRecipe;
import pl.asie.debark.util.BlockStateIterator;

@Mod(modid="debark", version="0.1.3", dependencies="after:forge@[14.23.5.2838,)", updateJSON="http://asie.pl/files/minecraft/update/debark.json", acceptedMinecraftVersions="[1.12.2]")
public final class DebarkMod {
    public static final String MODID = "debark";
    public static final String VERSION = "0.1.3";
    public static Logger logger;
    private static Configuration config;
    @SidedProxy(modId="debark", clientSide="pl.asie.debark.DebarkProxyClient", serverSide="pl.asie.debark.DebarkProxyCommon")
    private static DebarkProxyCommon proxy;
    private static final Map<String, DebarkBlockEntry> entries;
    static final Map<IBlockState, BlockDebarkedLogEntry> blocksMap;
    private static boolean debarkByRecipe;
    private static boolean debarkInWorld;
    private static boolean debarkInWorldRequiresShift;
    public static boolean enableDebugLogging;

    private void add(String key) {
        String[] keySplit = key.split(",");
        String[] keySplitArgs = new String[keySplit.length - 1];
        System.arraycopy(keySplit, 1, keySplitArgs, 0, keySplitArgs.length);
        entries.put(keySplit[0], new DebarkBlockEntry(keySplit[0], keySplitArgs));
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        int i;
        config = new Configuration(event.getSuggestedConfigurationFile());
        logger = event.getModLog();
        if (Loader.isModLoaded((String)"debarkedlogs")) {
            logger.info("Beeto's Debarked Logs detected - disabling vanilla debarked logs!");
        } else {
            this.add("minecraft:log,variant");
            this.add("minecraft:log2,variant");
        }
        for (i = 0; i <= 6; ++i) {
            this.add("forestry:logs." + i + ",variant");
            this.add("forestry:logs.fireproof." + i + ",variant");
        }
        for (i = 0; i <= 9; ++i) {
            this.add("extratrees:logs." + i + ",variant");
            this.add("extratrees:logs.fireproof." + i + ",variant");
        }
        for (i = 0; i <= 4; ++i) {
            this.add("biomesoplenty:log_" + i + ",variant");
        }
        this.add("aether_legacy:aether_log,aether_logs");
        this.add("atum:palm_log");
        this.add("bewitchment:juniper_wood");
        this.add("bewitchment:elder_wood");
        this.add("bewitchment:yew_wood");
        this.add("bewitchment:cypress_wood");
        this.add("climaticbiomesjbg:pine_log");
        this.add("natura:overworld_logs,type");
        this.add("natura:overworld_logs2,type");
        this.add("natura:nether_logs,type");
        this.add("pvj:log_aspen");
        this.add("pvj:log_baobab");
        this.add("pvj:log_cherry_blossom");
        this.add("pvj:log_cottonwood");
        this.add("pvj:log_fir");
        this.add("pvj:log_jacaranda");
        this.add("pvj:log_juniper");
        this.add("pvj:log_mangrove");
        this.add("pvj:log_maple");
        this.add("pvj:log_palm");
        this.add("pvj:log_pine");
        this.add("pvj:log_redwood");
        this.add("pvj:log_willow");
        this.add("rockhounding_surface:bog_logs,variant");
        this.add("rockhounding_surface:cold_logs,variant");
        this.add("rockhounding_surface:fossil_logs,variant");
        this.add("rockhounding_surface:petrified_logs,variant");
        this.add("rustic:log,variant");
        for (String s : new String[]{"acacia", "ash", "aspen", "birch", "blackwood", "chestnut", "douglas_fir", "hickory", "kapok", "maple", "oak", "palm", "pine", "rosewood", "sequoia", "spruce", "sycamore", "white_cedar", "willow"}) {
            this.add("tfc:wood/log/" + s);
        }
        this.add("traverse:fir_log");
        this.add("twilightforest:twilight_log,variant");
        String[] edl = config.get("modsupport", "extraDebarkedLogs", new String[0], "Format: blockId,property1,property2,etc").getStringList();
        Stream.of(edl).forEach(this::add);
        debarkByRecipe = config.getBoolean("debarkByRecipe", "interactions", true, "Allow debarking in crafting tables.");
        debarkInWorld = config.getBoolean("debarkInWorld", "interactions", true, "Allow debarking by right-clicking blocks with an axe.");
        debarkInWorldRequiresShift = config.getBoolean("debarkInWorldRequiresShift", "interactions", false, "Require shift-right-clicking for debarking in-world.");
        enableDebugLogging = config.getBoolean("debugLogsEnabled", "debug", false, "Enable debug logs.");
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void onInterModComms(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if ("register_log".equals(message.key) && message.isStringMessage()) {
                if (!blocksMap.isEmpty()) {
                    logger.warn("Warning: IMC message " + message.key + "(" + message.getStringValue() + ") from " + message.getSender() + " was sent too late!");
                }
                this.add(message.getStringValue());
                continue;
            }
            logger.warn("Unknown IMC message: " + message.key + " from " + message.getSender());
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        for (BlockDebarkedLogEntry block : blocksMap.values()) {
            ItemStack stack = block.getItemStack();
            OreDictionary.registerOre((String)"debarkedLogWood", (ItemStack)stack);
        }
    }

    public static IBlockState debarkedLogFor(IBlockState state) {
        IBlockState stateKey = BlockStateIterator.permuteByNames(state, (List<String>)ImmutableList.of((Object)"axis")).filter(blocksMap::containsKey).findFirst().orElse(null);
        if (stateKey != null) {
            BlockDebarkedLogEntry targetBlock = blocksMap.get(stateKey);
            String axisValue = null;
            for (IProperty property : state.func_177227_a()) {
                if (!"axis".equals(property.func_177701_a())) continue;
                axisValue = property.func_177702_a(state.func_177229_b(property));
                break;
            }
            if (axisValue != null) {
                try {
                    BlockLog.EnumAxis enumAxis = BlockLog.EnumAxis.valueOf((String)axisValue.toUpperCase(Locale.ROOT));
                    IBlockState resultState = targetBlock.getBlockState().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)enumAxis);
                    return resultState;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (debarkInWorld) {
            IBlockState state;
            IBlockState debarkedState;
            if (debarkInWorldRequiresShift && !event.getEntityPlayer().func_70093_af()) {
                return;
            }
            if (!stack.func_190926_b() && stack.func_77973_b().getToolClasses(stack).contains("axe") && (debarkedState = DebarkMod.debarkedLogFor(state = event.getWorld().func_180495_p(event.getPos()))) != null) {
                event.getWorld().func_180501_a(event.getPos(), debarkedState, 3);
                stack.func_179548_a(event.getWorld(), state, event.getPos(), event.getEntityPlayer());
                event.getEntityPlayer().func_184609_a(event.getHand());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        blocksMap.clear();
        for (DebarkBlockEntry entry : entries.values()) {
            int i;
            Block block;
            if (!event.getRegistry().containsKey(entry.getBlock()) || (block = (Block)event.getRegistry().getValue(entry.getBlock())) == null || block.getRegistryName() == null) continue;
            IBlockState defaultState = block.func_176223_P();
            List<IBlockState> states = BlockStateIterator.permuteByNames(defaultState, entry.getProperties()).collect(Collectors.toList());
            if (states.size() > 4) {
                logger.warn("Could not properly handle " + entry.getBlock() + " - too many states!");
                continue;
            }
            BlockDebarkedLog debarkedBlock = new BlockDebarkedLog(states.toArray(new IBlockState[0]));
            for (i = 0; i < states.size(); ++i) {
                blocksMap.put((IBlockState)states.get(i), new BlockDebarkedLogEntry(debarkedBlock, i));
            }
            if ("tfc".equals(block.getRegistryName().func_110624_b())) {
                for (i = 0; i < states.size(); ++i) {
                    blocksMap.put(((IBlockState)states.get(i)).func_177231_a(block.func_176194_O().func_185920_a("placed")), new BlockDebarkedLogEntry(debarkedBlock, i));
                }
            }
            debarkedBlock.setRegistryName("debark:debarked_log_" + block.getRegistryName().toString().replaceAll("[^A-Za-z0-9]", "_"));
            event.getRegistry().register((IForgeRegistryEntry)debarkedBlock);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        HashSet addedBlocks = new HashSet();
        blocksMap.values().forEach(blockEntry -> {
            if (!addedBlocks.add(blockEntry.getBlock())) {
                return;
            }
            ItemBlock itemBlock = new ItemBlock((Block)blockEntry.getBlock()){

                public int func_77647_b(int damage) {
                    return damage >= 0 && damage < ((BlockDebarkedLog)this.field_150939_a).getVariantCount() ? damage : 0;
                }

                public String func_77653_i(ItemStack stack) {
                    return ((BlockDebarkedLog)this.field_150939_a).getLocalizedName(stack.func_77960_j());
                }
            };
            itemBlock.func_77627_a(true);
            itemBlock.setRegistryName(blockEntry.getBlock().getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        });
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (debarkByRecipe) {
            blocksMap.values().forEach(blockEntry -> {
                BlockDebarkedLog block = blockEntry.getBlock();
                int i = blockEntry.getVariant();
                ItemStack log = block.getParentStack(i);
                ItemStack debarkedLog = new ItemStack((Block)block, 1, i);
                DebarkShapelessRecipe recipe = new DebarkShapelessRecipe(log, debarkedLog);
                recipe.setRegistryName(new ResourceLocation(MODID, "debark_log_" + block.getRegistryName().func_110623_a()));
                event.getRegistry().register((IForgeRegistryEntry)recipe);
            });
        }
    }

    static {
        entries = new LinkedHashMap<String, DebarkBlockEntry>();
        blocksMap = new LinkedHashMap<IBlockState, BlockDebarkedLogEntry>();
    }
}

