/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class BlockStateIterator {
    private static final Method WITH_PROPERTY = ObfuscationReflectionHelper.findMethod(IBlockState.class, (String)"func_177226_a", IBlockState.class, (Class[])new Class[]{IProperty.class, Comparable.class});

    private BlockStateIterator() {
    }

    public static Stream<IBlockState> permuteAll(IBlockState baseState) {
        return BlockStateIterator.permuteBy(baseState, (List<IProperty>)ImmutableList.copyOf((Collection)baseState.func_177227_a()));
    }

    public static Stream<IBlockState> permuteByNames(IBlockState baseState, List<String> propertyNames) {
        HashSet<String> propertyNameSet = new HashSet<String>(propertyNames);
        ArrayList<IProperty> properties = new ArrayList<IProperty>();
        for (IProperty property : baseState.func_177227_a()) {
            if (!propertyNameSet.contains(property.func_177701_a())) continue;
            properties.add(property);
        }
        return BlockStateIterator.permuteBy(baseState, properties);
    }

    public static Stream<IBlockState> permuteBy(IBlockState baseState, List<IProperty> properties) {
        LinkedHashMap<IProperty, ImmutableList> values = new LinkedHashMap<IProperty, ImmutableList>();
        int permutations = 1;
        for (IProperty property : properties) {
            ImmutableList propertyValues = ImmutableList.copyOf((Collection)property.func_177700_c());
            values.put(property, propertyValues);
            permutations *= propertyValues.size();
        }
        Stream.Builder<IBlockState> builder = Stream.builder();
        for (int i = 0; i < permutations; ++i) {
            IBlockState state = baseState;
            int j = i;
            for (Map.Entry valueEntry : values.entrySet()) {
                int size = ((List)valueEntry.getValue()).size();
                int k = j % size;
                try {
                    state = (IBlockState)WITH_PROPERTY.invoke((Object)state, valueEntry.getKey(), ((List)valueEntry.getValue()).get(k));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                j /= size;
            }
            builder.accept(state);
        }
        return builder.build();
    }
}

