/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core;

import com.google.common.collect.Lists;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import weissmoon.core.api.WeissCoreAPI;
import weissmoon.core.client.render.renderOverride.PublicRenderRegistry;
import weissmoon.core.command.TogglePVP;
import weissmoon.core.event.EntityDrop;
import weissmoon.core.event.EquiptArmourEvent;
import weissmoon.core.handler.ConfigurationHandler;
import weissmoon.core.item.CoreDummyItems;
import weissmoon.core.network.PacketHandler;
import weissmoon.core.proxy.CommonProxy;

@Mod(modid="weisscore", name="WeissCore", version="0.1.1", guiFactory="weissmoon.core.client.gui.GuiFactory", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class WeissCore {
    @Mod.Instance(value="weisscore")
    public static WeissCore instance;
    public static Logger logger;
    @SidedProxy(clientSide="weissmoon.core.proxy.ClientProxy", serverSide="weissmoon.core.proxy.ServerProxy")
    public static CommonProxy proxy;
    private boolean dummyInitialized = false;
    private boolean keyHandler = false;

    public void setDummyItem() {
        WeissCore.instance.dummyInitialized = true;
    }

    public void initKeyHandler() {
        WeissCore.instance.keyHandler = true;
    }

    @Mod.EventHandler
    public void constructing(FMLConstructionEvent event) {
        WeissCoreAPI.renderRegistry = new PublicRenderRegistry();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata md = event.getModMetadata();
        md.autogenerated = false;
        md.description = "Base Mod for my other mods.";
        md.authorList = Lists.newArrayList((Object[])new String[]{"Weissmoon"});
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "Weissmoon" + File.separator + "weisscore" + ".cfg"));
        MinecraftForge.EVENT_BUS.register((Object)instance);
        String c = "comparingLamp";
        if (WeissCore.instance.keyHandler) {
            PacketHandler.init();
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> evt) {
        if (WeissCore.instance.dummyInitialized) {
            IForgeRegistry registry = evt.getRegistry();
            registry.register((IForgeRegistryEntry)CoreDummyItems.dummyItem);
            CoreDummyItems.initDummyItems();
            CoreDummyItems.initRecipes();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityDrop());
        MinecraftForge.EVENT_BUS.register((Object)new EquiptArmourEvent());
        proxy.registerEventHandler();
        if (WeissCore.instance.keyHandler) {
            proxy.registerKeyHandler();
        }
        proxy.initRenderer();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new TogglePVP(evt.getServer()));
    }

    public static ItemStack newDummyItemStack(String name) {
        return CoreDummyItems.dummyItem.newDummyItemStack(name, 1);
    }

    public static ItemStack newDummyItemStack(String name, int size) {
        return CoreDummyItems.dummyItem.newDummyItemStack(name, size);
    }

    static {
        logger = LogManager.getLogger((String)"WeissCore");
    }
}

