/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.client.render;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class WeissRenderItem {
    private static final ItemColors itemColors = Minecraft.func_71410_x().getItemColors();

    public void renderModel(IBakedModel model, int color, @Nullable ItemStack stack) {
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
        }
        this.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
        tessellator.func_78381_a();
        if (stack == null || stack.func_77962_s()) {
            // empty if block
        }
        GlStateManager.func_179121_F();
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, @Nullable ItemStack stack) {
        boolean flag = color == -1 && stack != null;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
            LightUtil.renderQuadColorSlow((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }
}

