/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static boolean lore;
    public static boolean materialEvent;
    public static boolean michaelis;
    public static boolean wolfTip;
    public static boolean extraFancy;
    public static boolean stealthBinding;
    public static String CATEGORY_GENERAL;
    public static String CATEGORY_TOOLTIP;
    public static String CATEGORY_RENDER;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadCofiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("weisscore")) {
            ConfigurationHandler.loadCofiguration();
        }
    }

    private static void loadCofiguration() {
        lore = configuration.getBoolean("lore", CATEGORY_GENERAL, true, "Global Lore setting");
        michaelis = configuration.getBoolean("michaelis", CATEGORY_GENERAL, false, "Certain bullets appear in a shot player's inventory if PVP is disabled" + Configuration.NEW_LINE + "Otherwise bullets phase through");
        extraFancy = configuration.getBoolean("extraFancy", CATEGORY_RENDER, true, "Render some items with extra fancy render");
        materialEvent = configuration.getBoolean("blockMaterial", CATEGORY_TOOLTIP, true, "Show block material when holding \"Shift\"");
        wolfTip = configuration.getBoolean("wolfTip", CATEGORY_TOOLTIP, true, "Show wolves favorite foods");
        stealthBinding = configuration.getBoolean("stealthBinding", CATEGORY_TOOLTIP, true, "Do not show Curse of Binding in tooltip until Equipped");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        CATEGORY_GENERAL = "general";
        CATEGORY_TOOLTIP = "tooltip";
        CATEGORY_RENDER = "render";
    }
}

