/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.Validate;
import weissmoon.core.WeissCore;
import weissmoon.core.network.NetworkHelper;

public class BoundSoundPacket
implements IMessage,
IMessageHandler<BoundSoundPacket, IMessage> {
    private String player;
    private String soundName;
    private String category;
    private float loudness;
    private float pitch;

    public BoundSoundPacket(EntityPlayer entityPlayer, SoundCategory category, String soundName, float loudness, float pitch) {
        if (entityPlayer != null) {
            Validate.notNull((Object)soundName, (String)"boundSoundName", (Object[])new Object[0]);
            this.player = entityPlayer.func_70005_c_();
            this.soundName = soundName;
            this.category = category.func_187948_a();
            this.loudness = loudness;
            this.pitch = pitch;
        }
    }

    public void fromBytes(ByteBuf buf) {
        short length = buf.readShort();
        this.player = buf.readBytes((int)length).toString();
        length = buf.readShort();
        this.soundName = buf.readBytes((int)length).toString();
        length = buf.readShort();
        this.category = buf.readBytes((int)length).toString();
        this.loudness = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        String player1 = this.player;
        String sound = this.soundName;
        NetworkHelper.writeString(player1, buf);
        NetworkHelper.writeString(sound, buf);
        buf.writeFloat(this.loudness);
        buf.writeFloat(this.pitch);
    }

    public IMessage onMessage(BoundSoundPacket message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            EntityPlayer s = Minecraft.func_71410_x().field_71441_e.func_72924_a(this.player);
            WeissCore.proxy.playBoundSound(this.soundName, SoundCategory.func_187950_a((String)this.category), (Entity)s, this.loudness, this.pitch);
        }
        return null;
    }
}

