/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.util.Mth;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ModelConnection<T extends Connection>
extends ModelBase {
    public ModelConnection() {
        this.field_78089_u = 128;
        this.field_78090_t = 128;
    }

    public boolean hasTexturedRender() {
        return false;
    }

    @Nullable
    public ResourceLocation getAlternateTexture() {
        return null;
    }

    public void render(Fastener<?> fastener, T connection, World world, int skylight, int moonlight, float delta) {
        this.renderCord(connection, world, skylight, moonlight, delta);
    }

    public void renderTexturePass(Fastener<?> fastener, T connnection, World world, int skylight, int moonlight, float delta) {
    }

    public void renderCord(T connection, World world, int sunlight, int moonlight, float delta) {
        float sdelta;
        Catenary prevCatenary = ((Connection)connection).getPrevCatenary();
        Vec3d to = ((Connection)connection).getDestination().get(world).getConnectionPoint();
        int toBlockBrightness = world.func_175626_b(new BlockPos(to), 0);
        int toSunlight = toBlockBrightness % 65536;
        int toMoonlight = toBlockBrightness / 65536;
        Segment[] segments = ((Connection)connection).getCatenary().getSegments();
        Segment[] segmentsOld = prevCatenary.getSegments();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        if (segments.length >= segmentsOld.length) {
            Segment[] t = segments;
            segments = segmentsOld;
            segmentsOld = t;
            sdelta = 1.0f - delta;
        } else {
            sdelta = delta;
        }
        for (int i = 0; i < segments.length; ++i) {
            double length;
            Vec3d rotation;
            float v = (float)i / (float)segments.length;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)sunlight * (1.0f - v) + (float)toSunlight * v), (float)((float)moonlight * (1.0f - v) + (float)toMoonlight * v));
            Segment segment = segments[i];
            Segment old = segmentsOld[i];
            Vec3d vertex = Mth.lerp(old.getStart(), segment.getStart(), sdelta);
            if ((double)segmentsOld.length > segment.getLength() && i == segments.length - 1) {
                Segment s = new Segment(vertex);
                s.connectTo(Mth.lerp(segmentsOld[segmentsOld.length - 1].getEnd(), segment.getEnd(), sdelta));
                rotation = s.getRotation();
                length = s.getLength();
            } else {
                rotation = Mth.lerpAngles(old.getRotation(), segment.getRotation(), sdelta);
                length = old.getLength() * (double)(1.0f - sdelta) + segment.getLength() * (double)sdelta;
            }
            this.renderSegment(connection, i, rotation.field_72448_b, rotation.field_72450_a, length, vertex.field_72450_a, vertex.field_72448_b, vertex.field_72449_c, delta);
        }
        GlStateManager.func_179091_B();
    }

    protected abstract void renderSegment(T var1, int var2, double var3, double var5, double var7, double var9, double var11, double var13, float var15);

    public final ModelRenderer func_85181_a(Random rand) {
        throw new UnsupportedOperationException();
    }

    public final TextureOffset func_78084_a(String partName) {
        throw new UnsupportedOperationException();
    }

    public final void func_78088_a(Entity entity, float speed, float swing, float entityAge, float yaw, float pitch, float scale) {
        throw new UnsupportedOperationException();
    }

    public final void func_78086_a(EntityLivingBase entity, float yaw, float pitch, float delta) {
        throw new UnsupportedOperationException();
    }

    public final void func_178686_a(ModelBase model) {
        throw new UnsupportedOperationException();
    }

    public final void func_78087_a(float speed, float swing, float entityAge, float yaw, float pitch, float scale, Entity entity) {
        throw new UnsupportedOperationException();
    }

    protected final void func_78085_a(String partName, int x, int y) {
        throw new UnsupportedOperationException();
    }
}

