/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public abstract class PEToolBase
extends ItemMode {
    public static final float HAMMER_BASE_ATTACK = 13.0f;
    public static final float DARKSWORD_BASE_ATTACK = 12.0f;
    public static final float REDSWORD_BASE_ATTACK = 16.0f;
    public static final float STAR_BASE_ATTACK = 20.0f;
    public static final float KATAR_BASE_ATTACK = 23.0f;
    protected String peToolMaterial;
    protected final Set<Material> harvestMaterials = new HashSet<Material>();
    protected final Set<String> toolClasses = new HashSet<String>();

    public PEToolBase(String unlocalName, byte numCharge, String[] modeDescrp) {
        super(unlocalName, numCharge, modeDescrp);
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return this.harvestMaterials.contains(state.func_185904_a());
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.toolClasses.contains(toolClass)) {
            return 4;
        }
        return -1;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if ("dm_tools".equals(this.peToolMaterial)) {
            if (this.canHarvestBlock(state, stack)) {
                return 14.0f + 12.0f * (float)this.getCharge(stack);
            }
        } else if ("rm_tools".equals(this.peToolMaterial) && this.canHarvestBlock(state, stack)) {
            return 16.0f + 14.0f * (float)this.getCharge(stack);
        }
        return 1.0f;
    }

    protected void clearOdAOE(World world, ItemStack stack, EntityPlayer player, String odName, long emcCost, EnumHand hand) {
        int charge = this.getCharge(stack);
        if (charge == 0 || world.field_72995_K || ProjectEConfig.items.disableAllRadiusMining) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int scaled1 = 5 * charge;
        int scaled2 = 10 * charge;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos((Entity)player).func_177982_a(-scaled1, -scaled2, -scaled1), (BlockPos)new BlockPos((Entity)player).func_177982_a(scaled1, scaled2, scaled1))) {
            String oreName;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)world, pos) || Item.func_150898_a((Block)block) == null) continue;
            ItemStack s = new ItemStack(block);
            int[] oreIds = new int[]{};
            if (!s.func_190926_b()) {
                oreIds = OreDictionary.getOreIDs((ItemStack)s);
            }
            if (oreIds.length == 0) {
                if (block != Blocks.field_150420_aW && block != Blocks.field_150419_aX) continue;
                oreName = "logWood";
            } else {
                oreName = OreDictionary.getOreName((int)oreIds[0]);
            }
            if (!odName.equals(oreName)) continue;
            List<ItemStack> blockDrops = WorldHelper.getBlockDrops(world, player, state, stack, pos);
            if (!PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos) || !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            drops.addAll(blockDrops);
            world.func_175698_g(pos);
            if (world.field_73012_v.nextInt(5) != 0) continue;
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
        WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        PlayerHelper.swingItem(player, hand);
    }

    protected void tillAOE(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing sidehit, long emcCost) {
        int charge = this.getCharge(stack);
        boolean hasAction = false;
        boolean hasSoundPlayed = false;
        for (BlockPos newPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-charge, 0, -charge), (BlockPos)pos.func_177982_a(charge, 0, charge))) {
            IBlockState state = world.func_180495_p(newPos);
            IBlockState stateAbove = world.func_180495_p(newPos.func_177984_a());
            Block block = state.func_177230_c();
            Block blockAbove = stateAbove.func_177230_c();
            if (stateAbove.func_185914_p() || block != Blocks.field_150349_c && block != Blocks.field_150346_d) continue;
            if (!hasSoundPlayed) {
                world.func_184133_a(null, newPos, Blocks.field_150458_ak.func_185467_w().func_185844_d(), SoundCategory.BLOCKS, (Blocks.field_150458_ak.func_185467_w().func_185843_a() + 1.0f) / 2.0f, Blocks.field_150458_ak.func_185467_w().func_185847_b() * 0.8f);
                hasSoundPlayed = true;
            }
            if (world.field_72995_K) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(player, stack, world, newPos)) || (newPos.func_177958_n() != pos.func_177958_n() || newPos.func_177952_p() != pos.func_177952_p()) && !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, newPos, Blocks.field_150458_ak.func_176223_P());
            if ((stateAbove.func_185904_a() == Material.field_151585_k || stateAbove.func_185904_a() == Material.field_151582_l) && !blockAbove.hasTileEntity(stateAbove) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, newPos)) {
                world.func_175655_b(newPos.func_177984_a(), true);
            }
            if (hasAction) continue;
            hasAction = true;
        }
        if (hasAction) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.CHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void digBasedOnMode(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase living) {
        if (world.field_72995_K || !(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        byte mode = this.getMode(stack);
        if (mode == 0) {
            return;
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EnumFacing direction = mop.field_178784_b;
        BlockPos hitPos = mop.func_178782_a();
        AxisAlignedBB box = new AxisAlignedBB(hitPos, hitPos);
        if (!ProjectEConfig.items.disableAllRadiusMining) {
            switch (mode) {
                case 1: {
                    box = new AxisAlignedBB(hitPos.func_177967_a(EnumFacing.DOWN, 1), hitPos.func_177967_a(EnumFacing.UP, 1));
                    break;
                }
                case 2: {
                    switch (direction.func_176740_k()) {
                        case X: {
                            box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.SOUTH), hitPos.func_177972_a(EnumFacing.NORTH));
                            break;
                        }
                        case Y: {
                            switch (player.func_174811_aO().func_176740_k()) {
                                case X: {
                                    box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.SOUTH), hitPos.func_177972_a(EnumFacing.NORTH));
                                    break;
                                }
                                case Z: {
                                    box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.WEST), hitPos.func_177972_a(EnumFacing.EAST));
                                }
                            }
                            break;
                        }
                        case Z: {
                            box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.WEST), hitPos.func_177972_a(EnumFacing.EAST));
                        }
                    }
                    break;
                }
                case 3: {
                    box = new AxisAlignedBB(hitPos, hitPos.func_177967_a(direction.func_176734_d(), 2));
                }
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(digPos);
            Block b = state.func_177230_c();
            if (b == Blocks.field_150350_a || state.func_185887_b(world, digPos) == -1.0f || !this.canHarvestBlock(state, stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)world, (BlockPos)digPos, (ItemStack)stack) || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, digPos)) continue;
            if (!(b instanceof BlockShulkerBox)) {
                drops.addAll(WorldHelper.getBlockDrops(world, player, state, stack, digPos));
            }
            world.func_175698_g(digPos);
        }
        WorldHelper.createLootDrop(drops, world, pos);
    }

    protected void digAOE(ItemStack stack, World world, EntityPlayer player, boolean affectDepth, long emcCost, EnumHand hand) {
        if (world.field_72995_K || this.getCharge(stack) == 0 || ProjectEConfig.items.disableAllRadiusMining) {
            return;
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        AxisAlignedBB box = affectDepth ? WorldHelper.getBroadDeepBox(mop.func_178782_a(), mop.field_178784_b, this.getCharge(stack)) : WorldHelper.getFlatYBox(mop.func_178782_a(), this.getCharge(stack));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b == Blocks.field_150350_a || state.func_185887_b(world, pos) == -1.0f || !this.canHarvestBlock(state, stack) || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos) || !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            if (!(b instanceof BlockShulkerBox)) {
                drops.addAll(WorldHelper.getBlockDrops(world, player, state, stack, pos));
            }
            world.func_175698_g(pos);
        }
        WorldHelper.createLootDrop(drops, world, mop.func_178782_a());
        PlayerHelper.swingItem(player, hand);
        if (!drops.isEmpty()) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void attackWithCharge(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager, float baseDmg) {
        if (!(damager instanceof EntityPlayer) || damager.func_130014_f_().field_72995_K) {
            return;
        }
        DamageSource dmg = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)damager));
        int charge = this.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg.func_76348_h();
            totalDmg += (float)charge;
        }
        damaged.func_70097_a(dmg, totalDmg);
    }

    protected void attackAOE(ItemStack stack, EntityPlayer player, boolean slayAll, float damage, long emcCost, EnumHand hand) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        int charge = this.getCharge(stack);
        float factor = 2.5f * (float)charge;
        AxisAlignedBB aabb = player.func_174813_aQ().func_186662_g((double)factor);
        List toAttack = player.func_130014_f_().func_72839_b((Entity)player, aabb);
        DamageSource src = DamageSource.func_76365_a((EntityPlayer)player);
        src.func_76348_h();
        for (Entity entity : toAttack) {
            if (!PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            if (entity instanceof IMob) {
                entity.func_70097_a(src, damage);
                continue;
            }
            if (!(entity instanceof EntityLivingBase) || !slayAll) continue;
            entity.func_70097_a(src, damage);
        }
        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.CHARGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        PlayerHelper.swingItem(player, hand);
    }

    protected void shearBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        Block block = player.func_130014_f_().func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)player.func_130014_f_(), pos) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) {
            List drops = target.onSheared(stack, (IBlockAccess)player.func_130014_f_(), pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            WorldHelper.createLootDrop(drops, player.func_130014_f_(), pos);
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.func_188055_a((Block)block), 1);
        }
    }

    protected void shearEntityAOE(ItemStack stack, EntityPlayer player, long emcCost, EnumHand hand) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            int charge = this.getCharge(stack);
            int offset = (int)Math.pow(2.0, 2 + charge);
            AxisAlignedBB bBox = player.func_174813_aQ().func_72314_b((double)offset, (double)(offset / 2), (double)offset);
            List list = world.func_72872_a(Entity.class, bBox);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (Entity ent : list) {
                List entDrops;
                if (!(ent instanceof IShearable)) continue;
                IShearable target = (IShearable)ent;
                if (target.isShearable(stack, (IBlockAccess)ent.func_130014_f_(), new BlockPos(ent)) && PEToolBase.consumeFuel(player, stack, emcCost, true) && !(entDrops = target.onSheared(stack, (IBlockAccess)ent.func_130014_f_(), new BlockPos(ent), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack))).isEmpty()) {
                    for (ItemStack drop : entDrops) {
                        drop.func_190917_f(drop.func_190916_E());
                    }
                    drops.addAll(entDrops);
                }
                if (!(Math.random() < 0.01)) continue;
                Entity e = EntityList.func_188429_b((ResourceLocation)EntityList.func_191301_a((Entity)ent), (World)world);
                if (e instanceof EntityLiving) {
                    ((EntityLiving)e).func_180482_a(world.func_175649_E(new BlockPos(ent)), null);
                }
                if (e instanceof EntitySheep) {
                    ((EntitySheep)e).func_175512_b(EnumDyeColor.values()[MathUtils.randomIntInRange(0, 15)]);
                }
                if (e instanceof EntityAgeable) {
                    ((EntityAgeable)e).func_70873_a(-24000);
                }
                world.func_72838_d(e);
            }
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player, hand);
        }
    }

    private static boolean isSameOre(IBlockState target, IBlockState world) {
        if (target.func_177230_c() instanceof BlockRedstoneOre) {
            return world.func_177230_c() instanceof BlockRedstoneOre;
        }
        return target == world;
    }

    protected void tryVeinMine(ItemStack stack, EntityPlayer player, RayTraceResult mop) {
        if (player.func_130014_f_().field_72995_K || ProjectEConfig.items.disableAllRadiusMining) {
            return;
        }
        AxisAlignedBB aabb = WorldHelper.getBroadDeepBox(mop.func_178782_a(), mop.field_178784_b, this.getCharge(stack));
        IBlockState target = player.func_130014_f_().func_180495_p(mop.func_178782_a());
        if (target.func_185887_b(player.func_130014_f_(), mop.func_178782_a()) <= -1.0f || !this.canHarvestBlock(target, stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)player.func_130014_f_(), (BlockPos)mop.func_178782_a(), (ItemStack)stack)) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(aabb)) {
            IBlockState state = player.func_130014_f_().func_180495_p(pos);
            if (!PEToolBase.isSameOre(target, state)) continue;
            WorldHelper.harvestVein(player.func_130014_f_(), player, stack, pos, state, drops, 0);
        }
        WorldHelper.createLootDrop(drops, player.func_130014_f_(), mop.func_178782_a());
        if (!drops.isEmpty()) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void mineOreVeinsInAOE(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (player.func_130014_f_().field_72995_K || ProjectEConfig.items.disableAllRadiusMining) {
            return;
        }
        int offset = this.getCharge(stack) + 3;
        AxisAlignedBB box = player.func_174813_aQ().func_186662_g((double)offset);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        World world = player.func_130014_f_();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(pos);
            if (!ItemHelper.isOre(state) || state.func_185887_b(player.func_130014_f_(), pos) == -1.0f || !this.canHarvestBlock(state, stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) continue;
            WorldHelper.harvestVein(world, player, stack, pos, state, drops, 0);
        }
        if (!drops.isEmpty()) {
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player, hand);
        }
    }
}

