/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.DartType;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBlowgunDart
extends EntityProjectile {
    public static final String NAME = "dart";
    private static final DataParameter<Byte> DART_EFFECT_TYPE = EntityDataManager.func_187226_a(EntityBlowgunDart.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final float[][] DART_COLORS = new float[][]{{0.2f, 0.8f, 0.3f}, {0.9f, 0.7f, 1.0f}, {0.6f, 1.0f, 0.9f}, {0.8f, 0.5f, 0.2f}};

    public EntityBlowgunDart(World world) {
        super(world);
    }

    public EntityBlowgunDart(World world, double d, double d1, double d2) {
        this(world);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.func_70107_b(d, d1, d2);
    }

    public EntityBlowgunDart(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    public void func_184547_a(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DART_EFFECT_TYPE, (Object)0);
    }

    public void setDartEffectType(DartType type) {
        this.setDartEffectType(type.typeID);
    }

    public void setDartEffectType(byte i) {
        this.field_70180_af.func_187227_b(DART_EFFECT_TYPE, (Object)i);
    }

    public DartType getDartEffectType() {
        return DartType.dartTypes[this.getDartEffectId()];
    }

    public byte getDartEffectId() {
        byte effectId = (Byte)this.field_70180_af.func_187225_a(DART_EFFECT_TYPE);
        if (effectId < 0) {
            effectId = 0;
        }
        return effectId;
    }

    public float[] getDartColor() {
        byte effectId = this.getDartEffectId();
        return DART_COLORS[effectId >= DART_COLORS.length ? (byte)0 : effectId];
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        Entity entity = raytraceResult.field_72308_g;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (entity.func_70097_a(damagesource, 1.0f + this.extraDamage)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(this.getDartEffectType().potionEffect));
            }
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.func_70106_y();
        } else {
            this.bounceBack();
        }
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public void playHitSound() {
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.2f));
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    @Nonnull
    public ItemStack getPickupItem() {
        return this.func_184550_j();
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((Item)BalkonsWeaponMod.dart, 1, (int)this.getDartEffectId());
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("darttype", this.getDartEffectId());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setDartEffectType(nbttagcompound.func_74771_c("darttype"));
    }
}

