/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.blocks.tiles;

import keletu.forbiddenmagicre.ConfigFM;
import keletu.forbiddenmagicre.blocks.tiles.WrathSpawnerLogic;
import keletu.forbiddenmagicre.util.RegistryHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileEntityWrathCage
extends TileEntity
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    private final WrathSpawnerLogic spawnLogic = new WrathSpawnerLogic(this);
    public int wrath = 0;
    public int sloth = 0;
    public int special = 0;
    public byte mode = 0;
    Aspect aspect = Aspect.DESIRE;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.spawnLogic.readFromNBT(par1NBTTagCompound);
        this.wrath = par1NBTTagCompound.func_74765_d("Wrath");
        this.sloth = par1NBTTagCompound.func_74765_d("Sloth");
        this.special = par1NBTTagCompound.func_74765_d("Special");
        this.mode = par1NBTTagCompound.func_74771_c("Mode");
        this.aspect = this.spawnLogic.getAspect();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        this.spawnLogic.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("Wrath", (short)this.wrath);
        par1NBTTagCompound.func_74777_a("Sloth", (short)this.sloth);
        par1NBTTagCompound.func_74777_a("Special", (short)this.special);
        par1NBTTagCompound.func_74774_a("Mode", this.mode);
        return par1NBTTagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    public void func_73660_a() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.spawnLogic.updateSpawner();
        }
        if (ConfigFM.wrathCost > 0 && this.spawnLogic.isMobSet() && this.special < 64 && this.wrath < 64 && this.sloth < 64) {
            this.drawEssentia();
        }
    }

    void drawEssentia() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        for (int x = 0; x < EnumFacing.values().length; ++x) {
            EnumFacing current = EnumFacing.func_82600_a((int)x);
            TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)current);
            if (te == null) continue;
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (ic.canOutputTo(current.func_176734_d()) && this.special < 64 && ic.getEssentiaType(current.func_176734_d()) == this.aspect && ic.getEssentiaAmount(current.func_176734_d()) > 0 && ic.takeEssentia(this.aspect, 1, current.func_176734_d()) == 1) {
                ++this.special;
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
                return;
            }
            if (ic.canOutputTo(current.func_176734_d()) && this.wrath < 64 && this.special < ConfigFM.wrathCost && ic.getEssentiaType(current.func_176734_d()) == RegistryHandler.WRATH && ic.getEssentiaAmount(current.func_176734_d()) > 0 && ic.takeEssentia(RegistryHandler.WRATH, 1, current.func_176734_d()) == 1) {
                ++this.wrath;
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
                return;
            }
            if (!ic.canOutputTo(current.func_176734_d()) || this.sloth >= 64 || this.special >= ConfigFM.wrathCost || this.wrath >= ConfigFM.wrathCost || ic.getEssentiaType(current.func_176734_d()) != RegistryHandler.SLOTH || ic.getEssentiaAmount(current.func_176734_d()) <= 0 || ic.takeEssentia(RegistryHandler.SLOTH, 1, current.func_176734_d()) != 1) continue;
            ++this.sloth;
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            return;
        }
    }

    public void checkAspect() {
        if (this.aspect != this.spawnLogic.getAspect()) {
            this.special = 0;
        }
        this.aspect = this.spawnLogic.getAspect();
    }

    public boolean func_145842_c(int par1, int x) {
        return this.spawnLogic.setDelayToMin(par1) ? true : super.func_145842_c(par1, x);
    }

    public WrathSpawnerLogic getSpawnerLogic() {
        return this.spawnLogic;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (ConfigFM.wrathCost > 0 && this.spawnLogic.isMobSet()) {
            if (this.mode == 0) {
                list.add(this.aspect, this.special);
            } else if (this.mode == 1) {
                list.add(RegistryHandler.WRATH, this.wrath);
            } else {
                list.add(RegistryHandler.SLOTH, this.sloth);
            }
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        if (ConfigFM.wrathCost <= 0) {
            return false;
        }
        return tag == RegistryHandler.WRATH || tag == RegistryHandler.SLOTH || tag == this.aspect;
    }

    public int addToContainer(Aspect tag, int amount) {
        if (ConfigFM.wrathCost <= 0) {
            return amount;
        }
        if (tag == RegistryHandler.WRATH) {
            this.wrath += amount;
        } else if (tag == RegistryHandler.SLOTH) {
            this.sloth += amount;
        } else if (tag == this.aspect) {
            this.special += amount;
        } else {
            return amount;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        if (tag == RegistryHandler.WRATH) {
            return this.wrath >= amount;
        }
        if (tag == RegistryHandler.SLOTH) {
            return this.sloth >= amount;
        }
        if (tag == this.aspect) {
            return this.special >= amount;
        }
        return false;
    }

    public int containerContains(Aspect tag) {
        if (tag == RegistryHandler.WRATH) {
            return this.wrath;
        }
        if (tag == RegistryHandler.SLOTH) {
            return this.sloth;
        }
        if (tag == this.aspect) {
            return this.special;
        }
        return 0;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean isConnectable(EnumFacing face) {
        return ConfigFM.wrathCost > 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return true;
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(EnumFacing face) {
        if (ConfigFM.wrathCost <= 0) {
            return null;
        }
        if (this.mode == 0) {
            return this.aspect;
        }
        if (this.mode == 1) {
            return RegistryHandler.WRATH;
        }
        return RegistryHandler.SLOTH;
    }

    public int getSuctionAmount(EnumFacing face) {
        if (ConfigFM.wrathCost > 0) {
            return 256;
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, EnumFacing dir) {
        return 0;
    }

    public int addEssentia(Aspect inp, int amount, EnumFacing dir) {
        if (inp == this.aspect) {
            this.special += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        if (inp == RegistryHandler.WRATH) {
            this.wrath += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        if (inp == RegistryHandler.SLOTH) {
            this.sloth += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        return amount;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return this.getSuctionType(face);
    }

    public int getEssentiaAmount(EnumFacing face) {
        if (this.mode == 0) {
            return this.special;
        }
        if (this.mode == 1) {
            return this.wrath;
        }
        return this.sloth;
    }

    public int getMinimumSuction() {
        return 9000;
    }

    public boolean renderExtendedTube() {
        return false;
    }
}

