/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.compat.lostmagic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemIDFixer
implements IFixableData {
    private static final Map<ResourceLocation, ResourceLocation> ITEM_NAME_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>();

    public ItemIDFixer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        return compound;
    }

    @SubscribeEvent
    public void missingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Item newItem;
            ResourceLocation oldName = entry.key;
            ResourceLocation newName = ITEM_NAME_MAPPINGS.get(oldName);
            if (newName == null || (newItem = (Item)ForgeRegistries.ITEMS.getValue(newName)) == null) continue;
            entry.remap((IForgeRegistryEntry)newItem);
        }
    }

    static {
        ITEM_NAME_MAPPINGS.put(new ResourceLocation("lostmagic", "purifying_shovel"), new ResourceLocation("forbiddenmagicre", "purifying_shovel"));
        ITEM_NAME_MAPPINGS.put(new ResourceLocation("lostmagic", "ring_nutrition"), new ResourceLocation("forbiddenmagicre", "ring_nutrition"));
        ITEM_NAME_MAPPINGS.put(new ResourceLocation("lostmagic", "scribe_blood"), new ResourceLocation("forbiddenmagicre", "scribe_blood"));
    }
}

