/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.transporter;

import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.transport.transporter.BaseTransporter;
import ic2.core.util.misc.StackUtil;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class SidedTransporter
extends BaseTransporter {
    ISidedInventory inv;

    public SidedTransporter(boolean par1, ISidedInventory sided) {
        super(par1);
        this.inv = sided;
    }

    @Override
    public ItemStack removeItem(IFilter filter, EnumFacing dir, int amount, boolean doRemove) {
        if (dir == null) {
            return ItemStack.field_190927_a;
        }
        int[] slots = this.inv.func_180463_a(dir);
        if (slots == null || slots.length <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < slots.length; ++i) {
            int toRemove;
            int index = slots[i];
            ItemStack invItem = this.inv.func_70301_a(index);
            if (invItem.func_190926_b() || !this.inv.func_180461_b(index, invItem, dir) || !filter.matches(invItem) || stack != null && !this.canMerge(stack, invItem) || (toRemove = Math.min(invItem.func_190916_E(), amount - stack.func_190916_E())) <= 0) continue;
            if (doRemove) {
                if (stack.func_190926_b()) {
                    stack = this.inv.func_70298_a(index, toRemove);
                } else {
                    stack.func_190917_f(this.inv.func_70298_a(index, toRemove).func_190916_E());
                }
            } else if (stack.func_190926_b()) {
                stack = invItem.func_77946_l();
            } else {
                stack.func_190917_f(invItem.func_190916_E());
            }
            if (stack.func_190916_E() >= amount) break;
        }
        if (doRemove && stack != null) {
            if (this.auto) {
                this.inv.func_70296_d();
            } else {
                this.setDidAction();
            }
        }
        return stack;
    }

    @Override
    public int injectItem(ItemStack stack, EnumFacing dir, boolean doAdd) {
        if (dir == null) {
            return 0;
        }
        int[] slots = this.inv.func_180463_a(dir);
        if (slots == null || slots.length <= 0) {
            return 0;
        }
        int added = 0;
        int maxStack = this.inv.func_70297_j_();
        int maxItemSize = stack.func_77976_d();
        for (int i = 0; i < slots.length; ++i) {
            int room;
            int index = slots[i];
            if (!this.inv.func_180462_a(index, stack, dir)) continue;
            ItemStack invItem = this.inv.func_70301_a(index);
            if (invItem.func_190926_b()) {
                int toAdd = Math.min(stack.func_190916_E() - added, maxStack);
                if (doAdd) {
                    this.inv.func_70299_a(index, StackUtil.copyWithSize(stack, toAdd));
                }
                added += toAdd;
            } else if (this.canMerge(stack, invItem) && (room = Math.min(Math.min(maxItemSize - invItem.func_190916_E(), maxStack), stack.func_190916_E() - added)) > 0) {
                if (doAdd) {
                    invItem.func_190917_f(room);
                    this.inv.func_70299_a(index, invItem);
                }
                added += room;
            }
            if (added >= stack.func_190916_E()) break;
        }
        if (doAdd && added > 0) {
            if (this.auto) {
                this.inv.func_70296_d();
            } else {
                this.setDidAction();
            }
        }
        return added;
    }

    @Override
    public void markInventoryDirty() {
        this.inv.func_70296_d();
    }

    @Override
    public int getSizeInventory(EnumFacing side) {
        return this.inv.func_180463_a(side).length;
    }
}

