/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.item.IRotorBlade;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemRotorBlade
extends ItemIC2
implements IRotorBlade,
IBootable {
    private final int MAX_META = 3;
    private RotorBladeInfo[] blades = new RotorBladeInfo[3];

    public ItemRotorBlade() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.woodenRotor);
        this.func_77627_a(true);
        this.blades[0] = new RotorBladeInfo(20, 100.0f, 500, 100.0f);
        this.blades[1] = new RotorBladeInfo(50, 200.0f, 1000, 200.0f);
        this.blades[2] = new RotorBladeInfo(200, 300.0f, 4000, 300.0f);
    }

    @Override
    public void onLoad() {
        Ic2Items.woodenRotor = new ItemStack((Item)this, 1, 0);
        Ic2Items.woolRotor = new ItemStack((Item)this, 1, 1);
        Ic2Items.carbonRotor = new ItemStack((Item)this, 1, 2);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.woodenRotor;
            }
            case 1: {
                return Ic2ItemLang.woolRotor;
            }
            case 2: {
                return Ic2ItemLang.carbonRotor;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public List<Integer> getValidVariants() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 3; ++i) {
            list.add(i);
        }
        return list;
    }

    @Override
    public float getMaxSpeed(ItemStack stack) {
        if (this.validStack(stack)) {
            return this.blades[stack.func_77960_j()].maxSpeed;
        }
        return -1.0f;
    }

    @Override
    public int getWeight(ItemStack stack) {
        if (this.validStack(stack)) {
            return this.blades[stack.func_77960_j()].weight;
        }
        return -1;
    }

    @Override
    public float getEnergyEfficiency(ItemStack stack) {
        if (this.validStack(stack)) {
            return this.blades[stack.func_77960_j()].energyTransfer;
        }
        return -1.0f;
    }

    @Override
    public boolean reduceDurability(ItemStack stack, int durability) {
        if (this.validStack(stack)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            int dur = nbt.func_74762_e("durability");
            nbt.func_74768_a("durability", dur += Math.abs(durability));
            if (dur > this.blades[stack.func_77960_j()].durability) {
                return true;
            }
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    private boolean validStack(ItemStack stack) {
        return stack != ItemStack.field_190927_a && stack.func_77960_j() >= 0 && stack.func_77960_j() < 3;
    }

    private class RotorBladeInfo {
        final int weight;
        final float maxSpeed;
        final int durability;
        final float energyTransfer;

        private RotorBladeInfo(int weight, float maxSpeed, int durability, float energyTransfer) {
            this.weight = weight;
            this.maxSpeed = maxSpeed;
            this.durability = durability;
            this.energyTransfer = energyTransfer;
        }
    }
}

