/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import ic2.api.classic.crops.ClassicBaseSeed;
import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.classic.recipe.crafting.IRecipeObject;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.crafting.RecipeObject;
import ic2.api.classic.recipe.crafting.RecipeOreObject;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.crop.misc.RecipeInputCrop;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputElectricItem;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class AdvRecipe
extends AdvRecipeBase {
    private static int recipeCounter = 0;
    public static final IRecipeInput bucket = new IRecipeInput(){

        @Override
        public boolean matches(ItemStack subject) {
            if (subject.func_190926_b()) {
                return false;
            }
            Item item = subject.func_77973_b();
            if (item instanceof ItemBucket) {
                return item != Items.field_151133_ar;
            }
            return false;
        }

        @Override
        public int getAmount() {
            return 1;
        }

        @Override
        public List<ItemStack> getInputs() {
            return new ArrayList<ItemStack>();
        }

        public int hashCode() {
            return Items.field_151133_ar.getRegistryName().hashCode();
        }
    };
    public int height;
    public int length;
    protected int xOffset = -1;
    protected int yOffset = -1;
    protected IRecipeInput[] input;

    public static IAdvRecipe addAndGet(ItemStack out, Object[] in) {
        return AdvRecipeBase.registerRecipe(new AdvRecipe(out, in));
    }

    public static IAdvRecipe overrideAndGet(String recipeID, ItemStack out, Object[] in) {
        return AdvRecipeBase.overrideRecipe(new AdvRecipe(recipeID, true, out, in));
    }

    public AdvRecipe(ItemStack out, Object[] items) {
        this("shaped_" + out.func_77977_a(), false, out, items);
    }

    /*
     * WARNING - void declaration
     */
    private AdvRecipe(String recipeID, boolean override, ItemStack out, Object[] items) {
        void var10_19;
        if (override) {
            this.recipeID = recipeID;
            this.setRegistryNameFixed(recipeID);
        }
        this.output = out.func_77946_l();
        ArrayList<String> template = new ArrayList<String>();
        Character lastChar = null;
        HashMap<Character, IRecipeInput> charToItem = new HashMap<Character, IRecipeInput>();
        for (int i = 0; i < items.length; ++i) {
            Iterator obj = items[i];
            if (obj == null) continue;
            if (obj instanceof String) {
                if (lastChar == null) {
                    template.add((String)((Object)obj));
                    continue;
                }
                charToItem.put(lastChar, new RecipeInputOreDict((String)((Object)obj)));
                lastChar = null;
                continue;
            }
            if (obj instanceof Character) {
                lastChar = (Character)((Object)obj);
                continue;
            }
            if (obj instanceof ICraftingRecipeList.IRecipeModifier) {
                this.modifier = (ICraftingRecipeList.IRecipeModifier)((Object)obj);
                continue;
            }
            if (obj instanceof Boolean) {
                this.hidden = (Boolean)((Object)obj);
                continue;
            }
            if (obj instanceof ICraftingRecipeManager.AttributeContainer) {
                this.hidden = ((ICraftingRecipeManager.AttributeContainer)((Object)obj)).hidden;
                continue;
            }
            if (obj instanceof Item) {
                charToItem.put(lastChar, new RecipeInputItemStack(new ItemStack((Item)obj, 1, Short.MAX_VALUE)));
                lastChar = null;
                continue;
            }
            if (obj instanceof Block) {
                charToItem.put(lastChar, new RecipeInputItemStack(new ItemStack((Block)obj, 1, Short.MAX_VALUE)));
                lastChar = null;
                continue;
            }
            if (obj instanceof Fluid) {
                charToItem.put(lastChar, new RecipeInputFluid((Fluid)obj));
                lastChar = null;
                continue;
            }
            if (obj instanceof FluidStack) {
                charToItem.put(lastChar, new RecipeInputFluid((FluidStack)obj));
                lastChar = null;
                continue;
            }
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                if (itemStack.func_77973_b() instanceof IElectricItem) {
                    charToItem.put(lastChar, new RecipeInputElectricItem(itemStack.func_77946_l()));
                } else {
                    charToItem.put(lastChar, new RecipeInputItemStack(itemStack.func_77946_l()));
                }
                lastChar = null;
                continue;
            }
            if (obj instanceof CropCard) {
                charToItem.put(lastChar, new RecipeInputCrop((CropCard)((Object)obj)));
                lastChar = null;
                continue;
            }
            if (obj instanceof ClassicBaseSeed) {
                charToItem.put(lastChar, new RecipeInputCrop((ClassicBaseSeed)((Object)obj)));
                lastChar = null;
                continue;
            }
            if (obj instanceof BaseSeed) {
                charToItem.put(lastChar, new RecipeInputCrop((BaseSeed)((Object)obj)));
                lastChar = null;
                continue;
            }
            if (!(obj instanceof IRecipeInput)) continue;
            charToItem.put(lastChar, (IRecipeInput)((Object)obj));
            lastChar = null;
        }
        if (template.size() == 0 || template.size() > 3) {
            throw new RuntimeException("Template is not Matching");
        }
        String shape = "";
        this.length = -1;
        for (String string : template) {
            shape = shape + string;
            if (this.length != -1 && this.length != string.length()) {
                throw new RuntimeException("All Template keys need to have the same length");
            }
            this.length = string.length();
            ++this.height;
        }
        if (this.length * this.height != shape.length()) {
            throw new RuntimeException("Template is not Matching");
        }
        this.input = new IRecipeInput[this.length * this.height];
        int slot = 0;
        for (char chars : shape.toCharArray()) {
            IRecipeInput obj;
            this.input[slot] = obj = (IRecipeInput)charToItem.get(Character.valueOf(chars));
            IRecipeObject entry = this.addObject(slot, obj);
            ++slot;
            if (entry == null) continue;
            this.objects.add(entry);
        }
        if (!override) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(template);
            arrayList.addAll(Arrays.asList(this.input));
            this.recipeID = AdvRecipe.getRecipeID(arrayList, Arrays.asList(this.output), recipeID);
            this.setRegistryNameFixed(this.recipeID);
        }
        slot = 0;
        this.ingredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        boolean bl = false;
        while (var10_19 < this.height) {
            for (int x = 0; x < this.length; ++x) {
                char chars = shape.charAt(slot);
                IRecipeInput obj = (IRecipeInput)charToItem.get(Character.valueOf(chars));
                IRecipeObject entry = this.addObject(x + var10_19 * 3, obj);
                ++slot;
                if (entry == null) continue;
                this.ingredients.set(entry.getSlot(), (Object)Ingredient.func_193369_a((ItemStack[])entry.getItems().toArray(new ItemStack[0])));
            }
            ++var10_19;
        }
    }

    protected IRecipeObject addObject(int slot, Object item) {
        if (item instanceof ItemStack) {
            return new RecipeObject(slot, (ItemStack)item);
        }
        if (item instanceof RecipeInputOreDict) {
            RecipeInputOreDict input = (RecipeInputOreDict)item;
            return new RecipeOreObject(input.input, slot, input.getAmount());
        }
        if (item instanceof IRecipeInput) {
            IRecipeInput input = (IRecipeInput)item;
            return new RecipeObject(slot, input.getInputs(), input.getAmount());
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int x = 0; x <= 3 - this.length; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y)) continue;
                this.xOffset = x;
                this.yOffset = y;
                return true;
            }
        }
        this.xOffset = -1;
        this.yOffset = -1;
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
        if (this.modifier != null) {
            this.modifier.clear();
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                IRecipeInput input;
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                IRecipeInput target = null;
                if (subX >= 0 && subY >= 0 && subX < this.length && subY < this.height) {
                    target = this.input[subX + subY * this.length];
                }
                if ((slot = inv.func_70463_b(x, y)).func_190926_b() && target != null) {
                    return false;
                }
                if (target instanceof IRecipeInput ? !(input = target).matches(slot) || input.getAmount() > slot.func_190916_E() : target == null && !slot.func_190926_b()) {
                    return false;
                }
                if (this.modifier == null || this.modifier.isStackValid(slot)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        int totalCharge = 0;
        ItemStack out = this.output.func_77946_l();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.modifier != null && this.modifier.isOutput(stack)) {
                out = stack.func_77946_l();
                continue;
            }
            totalCharge = (int)((double)totalCharge + ElectricItem.manager.getCharge(stack));
        }
        if (totalCharge > 0) {
            ElectricItem.manager.charge(out, totalCharge, Integer.MAX_VALUE, true, false);
        }
        if (this.modifier != null) {
            out = this.modifier.getOutput(out, false);
        }
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.getRecipeLength() && height >= this.getRecipeHeight();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        if (this.xOffset == -1 && this.yOffset == -1 && !this.checkMatch(inv, this.length, this.height)) {
            return AdvRecipe.getDefaultItems(inv);
        }
        IRecipeObject[] toRemove = new IRecipeObject[inv.func_70302_i_()];
        int maxSlot = 0;
        for (IRecipeObject obj : this.objects) {
            int row = obj.getSlot() / this.length + this.yOffset;
            int col = obj.getSlot() % this.length + this.xOffset;
            int slot = row * inv.func_174922_i() + col;
            if (obj.getStackSize() > 1) {
                toRemove[slot] = obj;
                ++maxSlot;
                continue;
            }
            if (!AdvRecipe.isCellEmptying(obj) || bucket.matches(inv.func_70301_a(slot))) continue;
            toRemove[slot] = obj;
            ++maxSlot;
        }
        if (maxSlot <= 0) {
            return AdvRecipe.getDefaultItems(inv);
        }
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < toRemove.length; ++i) {
            IRecipeObject obj = toRemove[i];
            if (obj == null) {
                result.set(i, (Object)AdvRecipe.getContainerItem(inv.func_70301_a(i)));
                continue;
            }
            if (AdvRecipe.isCellEmptying(obj)) {
                result.set(i, (Object)FluidHelper.getEmptyContainer(inv.func_70301_a(i)));
                continue;
            }
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            inv.func_70299_a(i, ItemStack.field_190927_a);
            result.set(i, (Object)stack);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(obj.getStackSize());
        }
        return result;
    }

    @Override
    public IAdvRecipe.RecipeType getRecipeType() {
        return IAdvRecipe.RecipeType.Shaped;
    }

    @Override
    public int getRecipeHeight() {
        return this.height;
    }

    @Override
    public int getRecipeLength() {
        return this.length;
    }

    @Override
    public IRecipeInput getTrueInput(int index) {
        return this.input[index];
    }

    public static NonNullList<ItemStack> getDefaultItems(InventoryCrafting inv) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack.set(i, (Object)AdvRecipe.getContainerItem(itemstack));
        }
        return aitemstack;
    }

    public static ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77952_i() > stack.func_77958_k()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)ForgeHooks.getCraftingPlayer(), (ItemStack)stack, null);
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isCellEmptying(IRecipeObject obj) {
        if (obj.getStackSize() == 1) {
            List<ItemStack> list = obj.getItems();
            if (list.size() == 1) {
                return false;
            }
            for (ItemStack stack : list) {
                if (!StackUtil.isStackEqual(Ic2Items.waterCell, stack) && !StackUtil.isStackEqual(Ic2Items.lavaCell, stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NonNullList<Ingredient> buildList() {
        return NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
    }
}

