/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.network.ICustomNetworkItemEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.core.IC2;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.IHasComparator;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.inv.container.ContainerComparatorTool;
import ic2.core.item.inv.inventories.InventoryComparatorTool;
import ic2.core.item.inv.inventories.InventoryMachineTool;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMachineTool
extends ItemIC2
implements IHandHeldInventory,
ICustomNetworkItemEventListener,
ICustomItemCameraTransform {
    public ItemMachineTool() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.machineTool);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 58;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (StackUtil.getNbtData(stack).func_74767_n("Comparator")) {
            return new InventoryComparatorTool(player, hand, stack);
        }
        return new InventoryMachineTool(player, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(playerIn.func_184586_b(handIn));
            boolean result = !nbt.func_74767_n("Comparator");
            nbt.func_74757_a("Comparator", result);
            IC2.platform.messagePlayer(playerIn, result ? Ic2InfoLang.machineToolComparatorMode : Ic2InfoLang.machineToolInventoryMode);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        tooltip.add((StackUtil.getNbtData(stack).func_74767_n("Comparator") ? Ic2InfoLang.machineToolComparatorMode : Ic2InfoLang.machineToolInventoryMode).getLocalized());
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.toggleMachineToolMode));
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.accessMachineToolData.getLocalized());
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!IC2.keyboard.isModeSwitchKeyDown(player)) {
            IHasHandler handler;
            TileEntity tile = world.func_175625_s(pos);
            boolean comparator = StackUtil.getNbtData(stack).func_74767_n("Comparator");
            if (comparator) {
                ComparatorManager manager;
                if (tile instanceof IHasComparator && (manager = ((IHasComparator)tile).getManager()) != null) {
                    this.setPos(stack, pos);
                    if (IC2.platform.isSimulating()) {
                        NBTTagCompound data = new NBTTagCompound();
                        manager.writeToNBT(data);
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74757_a("Server", false);
                        nbt.func_74782_a("Data", (NBTBase)data);
                        IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
                        IC2.network.get().initiateCustomItemEvent(player, stack, new NBTFieldPacket(nbt));
                        return EnumActionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof IHasHandler && (handler = (IHasHandler)tile).getHandler() != null) {
                this.setPos(stack, pos);
                if (IC2.platform.isSimulating()) {
                    IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public void setPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74783_a("Pos", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public BlockPos getBlockPos(NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k("Pos");
        if (array.length != 3) {
            return null;
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, INetworkFieldData data) {
        if (!StackUtil.isStackEqual(stack, Ic2Items.machineTool)) {
            return;
        }
        if (!(data instanceof NBTFieldPacket)) {
            return;
        }
        NBTTagCompound nbt = ((NBTFieldPacket)data).getNBTData();
        if (nbt.func_74767_n("Server")) {
            ComparatorManager manager;
            TileEntity tile;
            BlockPos pos = this.getBlockPos(nbt);
            if (pos != null && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IHasComparator && (manager = ((IHasComparator)tile).getManager()) != null) {
                manager.readFromNBT(nbt.func_74775_l("Data"));
                manager.forceUpdate();
                IC2.platform.messagePlayer(player, Ic2InfoLang.machineToolSavedData);
            }
        } else if (player.field_71070_bA instanceof ContainerComparatorTool) {
            ContainerComparatorTool tool = (ContainerComparatorTool)player.field_71070_bA;
            ((InventoryComparatorTool)tool.getGuiHolder()).readFromNBT(nbt.func_74775_l("Data"));
        }
    }
}

