/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolWrench
extends ItemToolWrench
implements IDamagelessElectricItem,
IElectricTool {
    public ItemElectricToolWrench() {
        this.func_77656_e(0);
        this.setTranslationKey(Ic2ItemLang.wrenchElectric);
        this.setNoRepair();
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        tooltip.add(Ic2InfoLang.losslessWrenchUses.getLocalizedFormatted(15 - nbt.func_74762_e("LossUses")));
        tooltip.add((nbt.func_74767_n("losslessMode") ? Ic2InfoLang.losslessWrenchModeOn : Ic2InfoLang.losslessWrenchModeOff).getLocalized());
        List<String> list = sortedTooltip.get((Object)ToolTipType.Ctrl);
        list.add(Ic2Lang.onItemRightClick.getLocalized());
        list.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.toggleLosslessMode));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 12000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 250.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[35];
    }

    @Override
    public boolean canOverrideLossChance(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        return nbt.func_74767_n("losslessMode") && nbt.func_74762_e("LossUses") < 15;
    }

    @Override
    public void onLossPrevented(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int uses = nbt.func_74762_e("LossUses") + 1;
        nbt.func_74768_a("LossUses", uses);
        if (uses >= 15) {
            nbt.func_74757_a("losslessMode", false);
            IC2.platform.messagePlayer(player, Ic2InfoLang.losslessWrenchModeOff);
        }
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int damage) {
        return ElectricItem.manager.canUse(stack, damage * 50);
    }

    @Override
    public void damageItem(ItemStack stack, int damage, EntityPlayer player) {
        ElectricItem.manager.use(stack, damage * 50, (EntityLivingBase)player);
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return IC2.keyboard.isModeSwitchKeyDown(player) ? EnumActionResult.PASS : super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
            if (nbtData.func_74762_e("LossUses") < 15) {
                boolean newValue = !nbtData.func_74767_n("losslessMode");
                nbtData.func_74757_a("losslessMode", newValue);
                IC2.platform.messagePlayer(playerIn, newValue ? Ic2InfoLang.losslessWrenchModeOn : Ic2InfoLang.losslessWrenchModeOff);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    @Override
    public double getModifier(ItemStack stack) {
        return 1.1;
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185308_t;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

