/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.INetworkGuiDataProvider;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.network.NetworkUtils;
import ic2.core.network.PacketManager;
import ic2.core.network.buffers.FieldBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import ic2.core.network.packets.server.BlockUpdatePacket;
import ic2.core.network.packets.server.EntityGuiPacket;
import ic2.core.network.packets.server.ExplosionPacket;
import ic2.core.network.packets.server.FieldUpdatePacket;
import ic2.core.network.packets.server.GuiFieldPacket;
import ic2.core.network.packets.server.ItemCustomEventPacket;
import ic2.core.network.packets.server.ItemEventPacket;
import ic2.core.network.packets.server.ItemGuiPacket;
import ic2.core.network.packets.server.LoginPacket;
import ic2.core.network.packets.server.TileCustomEventPacket;
import ic2.core.network.packets.server.TileGuiPacket;
import ic2.core.network.packets.server.TileServerEventPacket;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.IntCounter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class NetworkManager {
    public static final String IC2_DATA = "ic2cData";
    protected static Map<Class<? extends TileEntity>, FieldBuffer> fieldBuffers = new HashMap<Class<? extends TileEntity>, FieldBuffer>();
    protected static Map<World, IntCounter> fieldDelay = new HashMap<World, IntCounter>();
    protected static Map<World, FieldStorage> fieldsToUpdateSet = new HashMap<World, FieldStorage>();
    protected static Map<World, GuiFieldStorage> guiToSync = new LinkedHashMap<World, GuiFieldStorage>();
    public static Map<String, Class<? extends INetworkFieldData>> idToClass = new HashMap<String, Class<? extends INetworkFieldData>>();
    public static Map<Class<? extends INetworkFieldData>, String> classToID = new HashMap<Class<? extends INetworkFieldData>, String>();
    public static Map<EntityPlayer, List<IC2Packet>> packets = new LinkedHashMap<EntityPlayer, List<IC2Packet>>();

    public void init() {
        PacketManager.instance.init();
    }

    public void onUnload() {
        fieldsToUpdateSet.clear();
        guiToSync.clear();
    }

    public void clearGuiFields() {
        for (GuiFieldStorage guiFieldStorage : guiToSync.values()) {
            guiFieldStorage.clear();
        }
        for (Map.Entry entry : packets.entrySet()) {
            EntityPlayer player = (EntityPlayer)entry.getKey();
            if (player.field_70128_L) continue;
            for (IC2Packet packet : (List)entry.getValue()) {
                this.sendCustomPacket(player, packet);
            }
        }
        packets.clear();
    }

    public void onWorldUnload(World world) {
        GuiFieldStorage gui;
        FieldStorage storage = fieldsToUpdateSet.remove(world);
        if (storage != null) {
            storage.clear();
        }
        if ((gui = guiToSync.remove(world)) != null) {
            gui.clear();
        }
        fieldDelay.remove(world);
    }

    public void onTick(World world) {
        IntCounter counter = fieldDelay.get(world);
        if (counter == null) {
            counter = new IntCounter(5);
            fieldDelay.put(world, counter);
        }
        counter.decrease();
        if (counter.getValue() <= 0) {
            this.sendUpdatePacket(world);
            counter.reset();
        }
    }

    public void startWatchingTile(EntityPlayer player, TileEntity tile) {
        PlayerHandler.getHandlerForPlayer((EntityPlayer)player).watching = tile;
    }

    public void updateGuiChanges(EntityPlayer player, TileEntity tile) {
        GuiFieldStorage storage = guiToSync.get(tile.func_145831_w());
        if (storage == null) {
            return;
        }
        List<FieldData> data = storage.getData(tile);
        if (data.isEmpty()) {
            return;
        }
        PacketManager.instance.sendToPlayer(new GuiFieldPacket(tile, data), player);
    }

    public void updateTileEntityField(TileEntity te, String field) {
        if (te == null || !te.func_145830_o()) {
            return;
        }
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new FieldStorage();
            fieldsToUpdateSet.put(te.func_145831_w(), worldFieldStorage);
        }
        if (worldFieldStorage.addGlobalField(te, field)) {
            this.sendUpdatePacket(te.func_145831_w());
        }
    }

    public void updateTileEntityField(TileEntity te, String field, EntityPlayerMP player) {
        if (te == null || !te.func_145830_o()) {
            return;
        }
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new FieldStorage();
            fieldsToUpdateSet.put(te.func_145831_w(), worldFieldStorage);
        }
        if (worldFieldStorage.addPlayerField(player, te, field)) {
            this.sendUpdatePacket(te.func_145831_w());
        }
    }

    public void updateTileGuiField(TileEntity te, String field) {
        GuiFieldStorage worldFieldStorage = guiToSync.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new GuiFieldStorage();
            guiToSync.put(te.func_145831_w(), worldFieldStorage);
        }
        worldFieldStorage.addTileEntityField(te, field);
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 50 : IC2.platform.getServer().func_184103_al().func_72372_a() + 16;
        World world = te.func_145831_w();
        int x = te.func_174877_v().func_177958_n();
        int z = te.func_174877_v().func_177952_p();
        TileServerEventPacket packet = null;
        for (EntityPlayer player : world.field_73010_i) {
            int distanceX = x - (int)player.field_70165_t;
            int distanceZ = z - (int)player.field_70161_v;
            int distance = (int)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
            if (distance > maxDistance) continue;
            if (packet == null) {
                packet = new TileServerEventPacket(te, event);
            }
            PacketManager.instance.sendToPlayer(packet, player);
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        ItemEventPacket packet = new ItemEventPacket(itemStack, event);
        PacketManager.instance.sendToPlayer(packet, player);
    }

    public void initiateCustomItemEvent(EntityPlayer player, ItemStack stack, INetworkFieldData data) {
        String id = classToID.get(data.getClass());
        if (id == null) {
            return;
        }
        PacketManager.instance.sendToPlayer(new ItemCustomEventPacket(stack, id, data), player);
    }

    public void announceBlockUpdate(World world, BlockPos pos) {
        BlockUpdatePacket packet = null;
        int maxDistance = IC2.platform.getServer().func_184103_al().func_72372_a() + 16;
        for (EntityPlayer player : world.field_73010_i) {
            int distance = Math.min(Math.abs(pos.func_177958_n() - (int)player.field_70165_t), Math.abs(pos.func_177952_p() - (int)player.field_70161_v));
            if (distance > maxDistance) continue;
            if (packet == null) {
                packet = new BlockUpdatePacket(world, pos);
            }
            PacketManager.instance.sendToPlayer(packet, player);
        }
    }

    public void sendCustomPacket(IC2Packet packet) {
    }

    public void sendCustomPacket(EntityPlayer player, IC2Packet packet) {
        PacketManager.instance.sendToPlayer(packet, player);
    }

    public void sendInitialData(INetworkDataProvider prov, NBTTagCompound nbt) {
        List<FieldData> data = NetworkUtils.createFieldData(prov);
        if (data.isEmpty()) {
            return;
        }
        ByteBuf buf = Unpooled.buffer();
        NetworkUtils.writeEntries(new OutputBuffer((ByteBuf)new PacketBuffer(buf)), data);
        byte[] result = new byte[buf.writerIndex()];
        buf.readBytes(result);
        nbt.func_74773_a(IC2_DATA, result);
    }

    public void handleInitialChange(TileEntity prov, NBTTagCompound nbt) {
    }

    public void requestInitialData(INetworkDataProvider dataProvider) {
        if (!(dataProvider instanceof TileEntity)) {
            return;
        }
        for (String field : dataProvider.getNetworkedFields()) {
            this.updateTileEntityField((TileEntity)dataProvider, field);
        }
    }

    public void requestInitialGuiData(EntityPlayer player, INetworkGuiDataProvider dataProvider) {
        if (!(dataProvider instanceof TileEntity)) {
            return;
        }
        TileEntity tile = (TileEntity)dataProvider;
        ArrayList<FieldData> data = new ArrayList<FieldData>();
        FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
        for (String field : dataProvider.getGuiFields()) {
            FieldBuffer.FieldInfo info = buffer.getInfo(field);
            if (info == null) continue;
            data.add(new FieldData(tile, info));
        }
        PacketManager.instance.sendToPlayer(new GuiFieldPacket((TileEntity)dataProvider, data), player);
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateCustomClientItemEvent(ItemStack itemStack, INetworkFieldData data) {
    }

    public void initiateCustomTileEntityEvent(TileEntity te, EntityPlayer player, INetworkFieldData data) {
        String id = classToID.get(data.getClass());
        if (id == null) {
            return;
        }
        PacketManager.instance.sendToPlayer(new TileCustomEventPacket(te, id, data), player);
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event, int value) {
    }

    public void initiateCustomClientTileEntityEvent(TileEntity te, INetworkFieldData data) {
    }

    public void registerEventFieldData(Class<? extends INetworkFieldData> clz, String id) {
        ModContainer mod = Loader.instance().activeModContainer();
        String finalID = mod.getModId() + ":" + id;
        if (!idToClass.containsKey(finalID)) {
            idToClass.put(finalID, clz);
            classToID.put(clz, finalID);
        }
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, EnumHand hand, IHasGui inventory, int windowId) {
        if (hand == null) {
            hand = EnumHand.MAIN_HAND;
        }
        IC2Packet packet = null;
        if (inventory instanceof TileEntity) {
            TileEntity tile = (TileEntity)inventory;
            packet = new TileGuiPacket(tile, entityPlayer.field_70170_p, windowId);
            if (tile instanceof INetworkGuiDataProvider) {
                this.requestInitialGuiData((EntityPlayer)entityPlayer, (INetworkGuiDataProvider)tile);
            }
            this.startWatchingTile((EntityPlayer)entityPlayer, tile);
        } else if (inventory instanceof Entity) {
            packet = new EntityGuiPacket((Entity)inventory, entityPlayer.field_70170_p, windowId);
        } else {
            ItemStack stack = entityPlayer.func_184586_b(hand);
            if (stack != null && stack.func_77973_b() instanceof IHandHeldInventory) {
                int slot = hand == EnumHand.OFF_HAND ? -1 : entityPlayer.field_71071_by.field_70461_c;
                packet = new ItemGuiPacket(slot, windowId);
            } else {
                IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
            }
        }
        if (packet != null) {
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void sendUpdatePacket(World world) {
        FieldBuffer.FieldInfo info;
        FieldBuffer buffer;
        if (!fieldsToUpdateSet.containsKey(world)) {
            return;
        }
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(world);
        if (worldFieldStorage.isEmpty()) {
            return;
        }
        if (world.field_73010_i.isEmpty()) {
            worldFieldStorage.clear();
            return;
        }
        LinkedHashMap playerQuere = new LinkedHashMap();
        int viewDistance = IC2.platform.getServer().func_184103_al().func_72372_a() + 16;
        if (worldFieldStorage.hasGlobalFields()) {
            for (Map.Entry<Object, Object> entry : worldFieldStorage.getGlobalFields().entrySet()) {
                if (((TileEntity)entry.getKey()).func_145837_r()) continue;
                TileEntity tile = (TileEntity)entry.getKey();
                buffer = NetworkManager.getFieldBuffer(tile);
                ArrayList<FieldData> dataList = new ArrayList<FieldData>();
                for (String string : (Set)entry.getValue()) {
                    info = buffer.getInfo(string);
                    if (info == null) continue;
                    dataList.add(new FieldData(tile, info));
                }
                BlockPos pos = tile.func_174877_v();
                for (EntityPlayer player : world.field_73010_i) {
                    int distance = Math.min(Math.abs(pos.func_177958_n() - (int)player.field_70165_t), Math.abs(pos.func_177952_p() - (int)player.field_70161_v));
                    if (distance > viewDistance) continue;
                    LinkedHashMap quere = (LinkedHashMap)playerQuere.get(player);
                    if (quere == null) {
                        quere = new LinkedHashMap();
                        playerQuere.put(player, quere);
                    }
                    quere.put(pos, dataList);
                }
            }
        }
        if (worldFieldStorage.hasPlayerFields()) {
            for (Map.Entry<Object, Object> entry : worldFieldStorage.getPlayerFields().entrySet()) {
                TileEntity field = (TileEntity)entry.getKey();
                if (field.func_145837_r()) continue;
                buffer = NetworkManager.getFieldBuffer(field);
                BlockPos pos = field.func_174877_v();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    info = buffer.getInfo((String)entry2.getKey());
                    if (info == null) continue;
                    FieldData data = new FieldData(field, info);
                    for (EntityPlayerMP player : (Set)entry2.getValue()) {
                        ArrayList<FieldData> dataList;
                        int distance;
                        if (player.field_70170_p.field_73011_w.getDimension() != world.field_73011_w.getDimension() || (distance = Math.min(Math.abs(pos.func_177958_n() - (int)player.field_70165_t), Math.abs(pos.func_177952_p() - (int)player.field_70161_v))) > viewDistance) continue;
                        LinkedHashMap<BlockPos, ArrayList<FieldData>> quere = (LinkedHashMap<BlockPos, ArrayList<FieldData>>)playerQuere.get(player);
                        if (quere == null) {
                            quere = new LinkedHashMap<BlockPos, ArrayList<FieldData>>();
                            playerQuere.put(player, quere);
                        }
                        if ((dataList = (ArrayList<FieldData>)quere.get(pos)) == null) {
                            dataList = new ArrayList<FieldData>();
                            quere.put(pos, dataList);
                        }
                        dataList.add(data);
                    }
                }
            }
        }
        for (Map.Entry<Object, Object> entry : playerQuere.entrySet()) {
            List<IC2Packet> packet = packets.get(entry.getKey());
            if (packet == null) {
                packet = new LinkedList<IC2Packet>();
                packets.put((EntityPlayer)entry.getKey(), packet);
            }
            packet.add(new FieldUpdatePacket((Map)entry.getValue(), world));
        }
        worldFieldStorage.clear();
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void sendLoginData(EntityPlayer player) {
        PacketManager.instance.sendToPlayer(new LoginPacket(), player);
    }

    public void sendInitialData(EntityPlayerMP mp, TileEntity tile) {
        if (tile instanceof INetworkDataProvider) {
            for (String key : ((INetworkDataProvider)tile).getNetworkedFields()) {
                this.updateTileEntityField(tile, key, mp);
            }
        }
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        this.initiateExplosionEffect(world, x, y, z, false);
    }

    public void initiateExplosionEffect(World world, double x, double y, double z, boolean nuke) {
        ExplosionPacket packet = new ExplosionPacket(world, x, y, z, nuke);
        for (Object player : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
            if (!(entityPlayer.func_70092_e(x, y, z) < 128.0)) continue;
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
        if (!nuke) {
            world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    public static FieldBuffer getFieldBuffer(TileEntity tile) {
        FieldBuffer buffer = fieldBuffers.get(tile.getClass());
        if (buffer == null) {
            buffer = new FieldBuffer(tile.getClass());
            fieldBuffers.put(tile.getClass(), buffer);
            buffer.initClass(tile);
        }
        return buffer;
    }

    public static class GuiFieldStorage {
        Map<TileEntity, Set<String>> fieldStorage = new HashMap<TileEntity, Set<String>>();
        Map<TileEntity, Map<String, FieldData>> dataStorage = new HashMap<TileEntity, Map<String, FieldData>>();

        public void addTileEntityField(TileEntity tile, String id) {
            Set<String> keys = this.fieldStorage.get(tile);
            if (keys == null) {
                keys = new LinkedHashSet<String>();
                this.fieldStorage.put(tile, keys);
            }
            keys.add(id);
        }

        public void clear() {
            this.fieldStorage = new LinkedHashMap<TileEntity, Set<String>>();
            this.dataStorage = new HashMap<TileEntity, Map<String, FieldData>>();
        }

        public List<FieldData> getData(TileEntity tile) {
            Set<String> keys = this.fieldStorage.get(tile);
            if (keys == null || keys.isEmpty()) {
                return new ArrayList<FieldData>();
            }
            Map<String, FieldData> data = this.dataStorage.get(tile);
            if (data == null) {
                data = new HashMap<String, FieldData>();
                this.dataStorage.put(tile, data);
            }
            FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
            ArrayList<FieldData> result = new ArrayList<FieldData>();
            for (String key : keys) {
                FieldBuffer.FieldInfo info;
                FieldData local = data.get(key);
                if (local == null && (info = buffer.getInfo(key)) != null) {
                    local = new FieldData(tile, info);
                    data.put(key, local);
                }
                if (local == null) continue;
                result.add(local);
            }
            return result;
        }
    }

    public static class FieldStorage {
        int count = 0;
        Map<TileEntity, Set<String>> globalFields = new LinkedHashMap<TileEntity, Set<String>>();
        Map<TileEntity, Map<String, Set<EntityPlayerMP>>> playerFields = new LinkedHashMap<TileEntity, Map<String, Set<EntityPlayerMP>>>();

        public boolean isEmpty() {
            return this.globalFields.isEmpty() && this.playerFields.isEmpty();
        }

        public boolean hasGlobalFields() {
            return this.globalFields.size() > 0;
        }

        public boolean hasPlayerFields() {
            return this.playerFields.size() > 0;
        }

        public int size() {
            return this.count;
        }

        public void clear() {
            this.globalFields = new LinkedHashMap<TileEntity, Set<String>>();
            this.playerFields = new LinkedHashMap<TileEntity, Map<String, Set<EntityPlayerMP>>>();
            this.count = 0;
        }

        public boolean addGlobalField(TileEntity tile, String field) {
            Set<String> fields = this.globalFields.get(tile);
            if (fields == null) {
                fields = new LinkedHashSet<String>();
                this.globalFields.put(tile, fields);
            }
            if (!fields.add(field)) {
                return false;
            }
            ++this.count;
            Map<String, Set<EntityPlayerMP>> playerMap = this.playerFields.get(tile);
            if (playerMap != null && playerMap.remove(field) != null) {
                --this.count;
                if (playerMap.isEmpty()) {
                    this.playerFields.remove(tile);
                }
            }
            return this.size() >= 10000;
        }

        public boolean addPlayerField(EntityPlayerMP player, TileEntity tile, String field) {
            Set<String> globals = this.globalFields.get(tile);
            if (globals != null && globals.contains(field)) {
                return false;
            }
            Map<String, Set<EntityPlayerMP>> fieldMap = this.playerFields.get(tile);
            if (fieldMap == null) {
                fieldMap = new LinkedHashMap<String, Set<EntityPlayerMP>>();
                this.playerFields.put(tile, fieldMap);
            }
            Set<EntityPlayerMP> players = fieldMap.get(field);
            boolean result = false;
            if (players == null) {
                players = new LinkedHashSet<EntityPlayerMP>();
                fieldMap.put(field, players);
                ++this.count;
                boolean bl = result = this.size() >= 10000;
            }
            if (players.add(player)) {
                return result;
            }
            return false;
        }

        public Map<TileEntity, Set<String>> getGlobalFields() {
            return this.globalFields;
        }

        public Map<TileEntity, Map<String, Set<EntityPlayerMP>>> getPlayerFields() {
            return this.playerFields;
        }
    }

    public static class FieldData {
        public String fieldName;
        public int index;
        public boolean isNew;
        public NetworkField.BitLevel bitLevel;
        public Object data;

        public FieldData(String field, Object theData) {
            this.fieldName = field;
            this.index = -1;
            this.isNew = false;
            this.bitLevel = NetworkField.BitLevel.Bit0;
            this.data = theData;
        }

        public FieldData(int id, NetworkField.BitLevel level, Object theData) {
            this.index = id;
            this.isNew = true;
            this.bitLevel = level;
            this.data = theData;
        }

        public FieldData(TileEntity tile, FieldBuffer.FieldInfo info) {
            this.fieldName = info.getFieldID();
            this.index = info.getIndex();
            this.isNew = info.isNew();
            this.bitLevel = info.getBits();
            this.data = info.getData(tile);
        }
    }
}

