/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.classic.network.INetworkGuiDataProvider;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.buffers.FieldBuffer;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class NetworkUtils {
    public static List<NetworkManager.FieldData> createFieldData(INetworkDataProvider prov) {
        if (!(prov instanceof TileEntity)) {
            return Collections.emptyList();
        }
        TileEntity tile = (TileEntity)prov;
        FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
        ArrayList<NetworkManager.FieldData> fields = new ArrayList<NetworkManager.FieldData>();
        for (String s : prov.getNetworkedFields()) {
            FieldBuffer.FieldInfo info = buffer.getInfo(s);
            if (info == null) continue;
            fields.add(new NetworkManager.FieldData(tile, info));
        }
        return fields;
    }

    public static void writeData(OutputBuffer buffer, Map<BlockPos, List<NetworkManager.FieldData>> data) {
        buffer.writeMedium(data.size());
        for (Map.Entry<BlockPos, List<NetworkManager.FieldData>> entry : data.entrySet()) {
            buffer.writeLong(entry.getKey().func_177986_g());
            NetworkUtils.writeEntries(buffer, entry.getValue());
        }
    }

    public static void writeEntries(OutputBuffer buffer, List<NetworkManager.FieldData> data) {
        buffer.writeByte((byte)data.size());
        for (NetworkManager.FieldData subData : data) {
            if (subData.isNew) {
                buffer.writeByte((byte)(1 + subData.bitLevel.getIndex()));
                buffer.writeByte((byte)subData.index);
                DataEncoder.encode(buffer, subData.data, subData.bitLevel);
                continue;
            }
            buffer.writeByte((byte)0);
            buffer.writeString(subData.fieldName);
            DataEncoder.encode(buffer, subData.data);
        }
    }

    public static void applyFields(TileEntity tile, List<NetworkManager.FieldData> data, boolean gui) {
        Consumer<String> notify = gui ? (tile instanceof INetworkUpdateListener ? ((INetworkUpdateListener)tile)::onNetworkUpdate : null) : (tile instanceof INetworkGuiDataProvider ? ((INetworkGuiDataProvider)tile)::onGuiFieldSynced : null);
        FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
        data.sort(Comparator.comparingInt(K -> K.index));
        LinkedHashSet<String> fieldsChanged = new LinkedHashSet<String>();
        for (NetworkManager.FieldData fields : data) {
            FieldBuffer.FieldInfo info;
            FieldBuffer.FieldInfo fieldInfo = info = fields.isNew ? buffer.getInfo(fields.index) : buffer.getInfo(fields.fieldName);
            if (info == null) {
                IC2.log.info("Field: [New=" + fields.isNew + ", Index=" + fields.index + ", Name=" + fields.fieldName + "], Not Existent In the clientSide");
                continue;
            }
            try {
                info.setData(tile, fields.data);
            }
            catch (Exception e) {
                IC2.log.catching((Throwable)e);
                continue;
            }
            fieldsChanged.add(info.getFieldID());
        }
        if (notify != null) {
            fieldsChanged.forEach(notify);
        }
    }

    public static Map<BlockPos, List<NetworkManager.FieldData>> readData(InputBuffer buffer) {
        LinkedHashMap<BlockPos, List<NetworkManager.FieldData>> result = new LinkedHashMap<BlockPos, List<NetworkManager.FieldData>>();
        int length = buffer.readMedium();
        for (int i = 0; i < length; ++i) {
            BlockPos pos = BlockPos.func_177969_a((long)buffer.readLong());
            result.put(pos, NetworkUtils.readEntries(buffer));
        }
        return result;
    }

    public static List<NetworkManager.FieldData> readEntries(InputBuffer buffer) {
        int expected = buffer.readByte();
        ArrayList<NetworkManager.FieldData> list = new ArrayList<NetworkManager.FieldData>(expected);
        for (int x = 0; x < expected; ++x) {
            byte data = buffer.readByte();
            if (data > 0) {
                byte index = buffer.readByte();
                NetworkField.BitLevel level = NetworkField.BitLevel.getLevel(data - 1);
                list.add(new NetworkManager.FieldData(index, level, DataEncoder.decode(buffer, level)));
                continue;
            }
            String id = buffer.readString();
            list.add(new NetworkManager.FieldData(id, DataEncoder.decode(buffer)));
        }
        return list;
    }
}

