/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core.machine.canner;

import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.jeiIntigration.core.machine.canner.CannerRecipeWrapper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class FuelableCannerRecipeWrapper
extends CannerRecipeWrapper {
    FuelableItem type;

    public FuelableCannerRecipeWrapper(FuelableItem item) {
        this.type = item;
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.asList(this.type.getFuel());
    }

    @Override
    public ItemStack getContainer() {
        return this.type.getItem();
    }

    @Override
    public ItemStack getOutput() {
        return this.type.getItem();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        String energy = Ic2InfoLang.isFuelable.getLocalized();
        boolean adv = false;
        if (this.type.hasValue()) {
            energy = Ic2InfoLang.isFuelablePoints.getLocalizedFormatted(this.type.getValue());
            adv = true;
        }
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        int stringWidth = fontRendererObj.func_78256_a(energy);
        fontRendererObj.func_78276_b(energy, recipeWidth - stringWidth + (adv ? 45 : -5), 2, Color.gray.getRGB());
    }

    public static class FuelableItem {
        ItemStack item;
        ItemStack fuel;
        int points = 0;

        public FuelableItem(ItemStack stack) {
            this.item = stack.func_77946_l();
            this.fuel = Ic2Items.coalFuelCell.func_77946_l();
        }

        public FuelableItem(ItemStack stack, ItemStack itemFuel, int value) {
            this.item = stack.func_77946_l();
            this.fuel = itemFuel.func_77946_l();
            this.points = value;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public ItemStack getFuel() {
            return this.fuel;
        }

        public boolean hasValue() {
            return this.points != 0;
        }

        public int getValue() {
            return this.points;
        }
    }
}

