/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.common.lib.research.ResearchManager;
import thecodex6824.tcresearchpatcher.TCResearchPatcher;
import thecodex6824.tcresearchpatcher.TCResearchPatcherContainer;
import thecodex6824.tcresearchpatcher.api.event.ResearchPatchEvent;
import thecodex6824.tcresearchpatcher.json.JsonSchemaException;
import thecodex6824.tcresearchpatcher.json.JsonUtils;
import thecodex6824.tcresearchpatcher.patch.JsonPatch;
import thecodex6824.tcresearchpatcher.patch.PatchHelper;

public final class Hooks {
    private static final HashMap<String, ArrayList<ArrayList<JsonPatch>>> PATCHES = new HashMap();
    private static final Method JSON_DEEP_COPY;
    private static final Method PARSE_RESEARCH_JSON;
    private static final Method ADD_RESEARCH_TO_CATEGORY;

    private Hooks() {
    }

    private static ResearchEntry parseResearchJson(JsonObject entry) {
        try {
            return (ResearchEntry)PARSE_RESEARCH_JSON.invoke(null, entry);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void addResearchToCategory(ResearchEntry entry) {
        try {
            ADD_RESEARCH_TO_CATEGORY.invoke(null, entry);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void onEnterParseResearch() {
        File entryFolder;
        PATCHES.clear();
        Logger log = TCResearchPatcher.getLogger();
        JsonParser parser = new JsonParser();
        File patchFolder = new File("config/tcresearchpatcher", "patches");
        if (patchFolder.isDirectory()) {
            File[] files;
            for (File f : files = patchFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".json");
                }
            })) {
                try (FileInputStream s = new FileInputStream(f);){
                    String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                    JsonElement element = parser.parse(content);
                    List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                    for (JsonObject o : objects) {
                        JsonPrimitive key = JsonUtils.getPrimitiveOrThrow("key", o);
                        JsonArray ops = JsonUtils.getArrayOrThrow("ops", o);
                        ArrayList<JsonPatch> insertTo = new ArrayList<JsonPatch>();
                        for (JsonElement e : ops.getAsJsonArray()) {
                            if (!e.isJsonObject()) {
                                throw new JsonSchemaException(e + ": Patch entry not an object");
                            }
                            insertTo.add(PatchHelper.parsePatch(e.getAsJsonObject()));
                        }
                        ArrayList<ArrayList<JsonPatch>> list = PATCHES.get(key.getAsString());
                        if (list == null) {
                            list = new ArrayList();
                            PATCHES.put(key.getAsString(), list);
                        }
                        list.add(insertTo);
                    }
                }
                catch (Exception ex) {
                    log.error("patches/" + f.getName() + ": Error reading file: " + ex.getMessage());
                    TCResearchPatcherContainer.instance.setErrorsDetected();
                }
            }
        }
        if ((entryFolder = new File("config/tcresearchpatcher", "entries")).isDirectory()) {
            File[] files;
            for (File f : files = entryFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".json");
                }
            })) {
                try (FileInputStream s = new FileInputStream(f);){
                    String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                    JsonElement element = parser.parse(content);
                    List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                    if (objects.size() == 1 && JsonUtils.tryGetArray("entries", objects.get(0)).isPresent()) {
                        objects = JsonUtils.getObjectOrArrayContainedObjects(objects.get(0).get("entries"));
                    }
                    int i = 0;
                    for (JsonObject entry : objects) {
                        if (!Hooks.patchResearchJSON(entry)) continue;
                        ResearchEntry researchEntry = Hooks.parseResearchJson(entry);
                        Hooks.addResearchToCategory(researchEntry);
                        ++i;
                    }
                    log.info("entries/" + f.getName() + ": loaded " + i + " entries");
                }
                catch (Exception ex) {
                    log.error("entries/" + f.getName() + ": Error reading file: " + ex.getMessage());
                    TCResearchPatcherContainer.instance.setErrorsDetected();
                }
            }
        }
    }

    private static <T extends JsonElement> T deepCopy(T element) {
        try {
            return (T)((JsonElement)JSON_DEEP_COPY.invoke(element, new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean patchResearchJSON(JsonObject json) {
        boolean allowLoading = true;
        Logger log = TCResearchPatcher.getLogger();
        JsonElement key = json.get("key");
        if (key != null && key.isJsonPrimitive()) {
            ResearchPatchEvent.Pre preEvent = new ResearchPatchEvent.Pre(json);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (preEvent.isCanceled() || preEvent.getResult() == Event.Result.DENY) {
                return false;
            }
            if (preEvent.getResult() == Event.Result.ALLOW) {
                return true;
            }
            ArrayList<ArrayList<JsonPatch>> apply = PATCHES.get(key.getAsString());
            if (apply != null) {
                for (ArrayList<JsonPatch> patchList : apply) {
                    if (patchList.isEmpty()) continue;
                    boolean applyChanges = true;
                    JsonObject working = Hooks.deepCopy(json);
                    for (JsonPatch p : patchList) {
                        try {
                            applyChanges &= PatchHelper.applyPatch(working, p);
                        }
                        catch (JsonSchemaException ex) {
                            log.warn(ex.getMessage());
                            applyChanges = false;
                        }
                        if (applyChanges) continue;
                        break;
                    }
                    if (!applyChanges) continue;
                    HashSet toRemove = new HashSet();
                    for (Map.Entry entry : json.entrySet()) {
                        toRemove.add(entry.getKey());
                    }
                    for (String s : toRemove) {
                        json.remove(s);
                    }
                    for (Map.Entry entry : working.entrySet()) {
                        json.add((String)entry.getKey(), Hooks.deepCopy((JsonElement)entry.getValue()));
                    }
                }
                allowLoading = JsonUtils.tryGetPrimitive("key", json).isPresent();
            }
        } else {
            log.error("An entry is missing a key (before patching), it will not be loaded. See debug log for json dump");
            log.debug(json.toString());
            allowLoading = false;
            TCResearchPatcherContainer.instance.setErrorsDetected();
        }
        if (!allowLoading) {
            return false;
        }
        ResearchPatchEvent.Post postEvent = new ResearchPatchEvent.Post(json);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        return !postEvent.isCanceled();
    }

    public static void onExitParseResearch() {
        PATCHES.clear();
    }

    static {
        Method temp = null;
        try {
            temp = JsonElement.class.getDeclaredMethod("deepCopy", new Class[0]);
            temp.setAccessible(true);
        }
        catch (Exception ex) {
            TCResearchPatcher.getLogger().error("Could not access JsonElement#deepCopy");
        }
        JSON_DEEP_COPY = temp;
        try {
            temp = ResearchManager.class.getDeclaredMethod("parseResearchJson", JsonObject.class);
            temp.setAccessible(true);
        }
        catch (Exception ex) {
            TCResearchPatcher.getLogger().error("Could not access ResearchManager#parseResearchJson");
        }
        PARSE_RESEARCH_JSON = temp;
        try {
            temp = ResearchManager.class.getDeclaredMethod("addResearchToCategory", ResearchEntry.class);
            temp.setAccessible(true);
        }
        catch (Exception ex) {
            TCResearchPatcher.getLogger().error("Could not access ResearchManager#parseResearchJson");
        }
        ADD_RESEARCH_TO_CATEGORY = temp;
    }
}

