/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanningManager;
import thecodex6824.tcresearchpatcher.InternalMethodHandler;
import thecodex6824.tcresearchpatcher.TCResearchPatcher;
import thecodex6824.tcresearchpatcher.TCResearchPatcherConfig;
import thecodex6824.tcresearchpatcher.api.ThaumcraftResearchPatcherApi;
import thecodex6824.tcresearchpatcher.json.JsonSchemaException;
import thecodex6824.tcresearchpatcher.json.JsonUtils;
import thecodex6824.tcresearchpatcher.parser.ScanParserBlock;
import thecodex6824.tcresearchpatcher.parser.ScanParserEntity;
import thecodex6824.tcresearchpatcher.parser.ScanParserItem;
import thecodex6824.tcresearchpatcher.parser.ScanParserItemExtended;

@Mod(modid="tcresearchpatcher", name="Thaumcraft Research Patcher", version="1.12.2-1.1.3", certificateFingerprint="8f678591ba6f78d579e553a8aa94b4c4766cb13d", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class TCResearchPatcherContainer {
    @Mod.Instance(value="tcresearchpatcher")
    public static TCResearchPatcherContainer instance;
    protected boolean researchErrors;

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        TCResearchPatcher.getLogger().error("Thaumcraft Research Patcher is expecting signature {}, however there is no signature matching that description", (Object)event.getExpectedFingerprint());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ThaumcraftResearchPatcherApi.setInternalMethodHandler(new InternalMethodHandler());
        ThaumcraftResearchPatcherApi.registerScanParser(new ScanParserBlock(), 1000);
        ThaumcraftResearchPatcherApi.registerScanParser(new ScanParserItem(), 1000);
        ThaumcraftResearchPatcherApi.registerScanParser(new ScanParserItemExtended(), 1000);
        ThaumcraftResearchPatcherApi.registerScanParser(new ScanParserEntity(), 1000);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        File scans;
        Logger log = TCResearchPatcher.getLogger();
        JsonParser parser = new JsonParser();
        File cats = new File("config/tcresearchpatcher", "categories.json");
        if (cats.isFile()) {
            try (FileInputStream s = new FileInputStream(cats);){
                String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                JsonElement element = parser.parse(content);
                List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                for (JsonObject o : objects) {
                    JsonPrimitive key = JsonUtils.getPrimitiveOrThrow("key", o);
                    JsonPrimitive requirement = JsonUtils.getPrimitiveOrThrow("requirement", o);
                    AspectList list = new AspectList();
                    JsonObject aspects = (JsonObject)JsonUtils.tryGetObject("aspects", o).or((Object)new JsonObject());
                    for (Map.Entry pair : aspects.entrySet()) {
                        if (!((JsonElement)pair.getValue()).isJsonPrimitive()) continue;
                        Aspect aspect = Aspect.getAspect((String)((String)pair.getKey()));
                        if (aspect == null) {
                            throw new JsonSchemaException(aspects + ": Invalid aspect entry: invalid aspect tag");
                        }
                        int amount = -1;
                        try {
                            amount = ((JsonElement)pair.getValue()).getAsInt();
                        }
                        catch (ClassCastException ex) {
                            throw new JsonSchemaException(aspects + ": Invalid aspect entry: invalid amount");
                        }
                        if (amount <= 0) continue;
                        list.add(aspect, amount);
                    }
                    JsonPrimitive icon = JsonUtils.getPrimitiveOrThrow("icon", o);
                    JsonPrimitive background = JsonUtils.getPrimitiveOrThrow("background", o);
                    JsonPrimitive backgroundOverlay = JsonUtils.getPrimitiveOrThrow("backgroundOverlay", o);
                    ResearchCategories.registerCategory((String)key.getAsString(), (String)requirement.getAsString(), (AspectList)list, (ResourceLocation)new ResourceLocation(icon.getAsString()), (ResourceLocation)new ResourceLocation(background.getAsString()), (ResourceLocation)new ResourceLocation(backgroundOverlay.getAsString()));
                }
            }
            catch (Exception ex) {
                log.error("categories.json: Error reading file: " + ex.getMessage());
                this.researchErrors = true;
            }
        }
        if ((scans = new File("config/tcresearchpatcher", "scans")).isDirectory()) {
            File[] files;
            for (File f : files = scans.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".json");
                }
            })) {
                try {
                    Throwable[] throwableArray = null;
                    try (FileInputStream s = new FileInputStream(f);){
                        String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                        JsonElement element = parser.parse(content);
                        List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                        int scanKeys = 0;
                        int totalScans = 0;
                        for (JsonObject o : objects) {
                            String key = JsonUtils.getPrimitiveOrThrow("key", o).getAsString();
                            ResourceLocation type = new ResourceLocation(JsonUtils.getPrimitiveOrThrow("type", o).getAsString());
                            JsonElement obj = JsonUtils.getOrThrow("object", o);
                            for (IScanThing thing : ThaumcraftResearchPatcherApi.parseScans(key, type, obj)) {
                                ScanningManager.addScannableThing((IScanThing)thing);
                                ++totalScans;
                            }
                            ++scanKeys;
                        }
                        log.info("scans/" + f.getName() + ": loaded " + scanKeys + " scan keys with " + totalScans + " scan entries");
                    }
                    catch (Throwable object) {
                        throwableArray = object;
                        throw object;
                    }
                }
                catch (Exception ex) {
                    log.error("scans/" + f.getName() + ": Error reading file: " + ex.getMessage());
                    for (Throwable t : ex.getSuppressed()) {
                        log.error(t.getMessage());
                    }
                    this.researchErrors = true;
                }
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Logger log = TCResearchPatcher.getLogger();
        for (String s : TCResearchPatcherConfig.removedCategories) {
            if (ResearchCategories.researchCategories.remove(s) != null) {
                log.info("Removing research category " + s);
                continue;
            }
            log.warn("Research category " + s + " was supposed to be removed, but did not exist");
        }
        if (this.researchErrors) {
            log.error("One or more research errors have occurred. Please check the log file for more information.");
        }
    }

    public void setErrorsDetected() {
        this.researchErrors = true;
    }
}

