/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher.parser;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ScanEntity;
import thecodex6824.tcresearchpatcher.api.scan.IScanParser;
import thecodex6824.tcresearchpatcher.json.JsonSchemaException;
import thecodex6824.tcresearchpatcher.json.JsonUtils;

public class ScanParserEntity
implements IScanParser {
    protected IScanThing parseElement(String key, JsonElement e) {
        if (e.isJsonArray()) {
            throw new JsonSchemaException(key + ": Invalid object entry: must be object or primitive");
        }
        if (e.isJsonPrimitive()) {
            ResourceLocation loc = new ResourceLocation(e.getAsString());
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
            if (entry == null) {
                throw new NullPointerException(key + ": Entity " + loc + " does not exist");
            }
            return new ScanEntity(key, entry.getEntityClass(), true);
        }
        ResourceLocation loc = new ResourceLocation(JsonUtils.getPrimitiveOrThrow("name", e.getAsJsonObject()).getAsString());
        JsonPrimitive inherit = (JsonPrimitive)JsonUtils.tryGetPrimitive("inherit", e.getAsJsonObject()).orNull();
        JsonElement nbt = (JsonElement)JsonUtils.tryGet("nbt", e.getAsJsonObject()).orNull();
        if (nbt != null && nbt.isJsonArray()) {
            throw new JsonSchemaException(key + ": nbt must be object or string");
        }
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc);
        if (entry == null) {
            throw new NullPointerException(key + ": Entity " + loc + " does not exist");
        }
        ThaumcraftApi.EntityTagsNBT[] tcNbt = null;
        if (nbt != null) {
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)(nbt.isJsonObject() ? new Gson().toJson((JsonElement)nbt.getAsJsonObject()) : nbt.getAsString()));
                tcNbt = new ThaumcraftApi.EntityTagsNBT[tag.func_186856_d()];
                int i = 0;
                for (String s : tag.func_150296_c()) {
                    tcNbt[i] = new ThaumcraftApi.EntityTagsNBT(s, ThaumcraftApiHelper.getNBTDataFromId((NBTTagCompound)tag, (byte)tag.func_150299_b(s), (String)s));
                    ++i;
                }
            }
            catch (NBTException ex) {
                throw new JsonSchemaException(key + ": Invalid nbt: " + (Object)((Object)ex));
            }
        }
        return new ScanEntity(key, entry.getEntityClass(), inherit != null ? inherit.getAsBoolean() : true, tcNbt);
    }

    @Override
    public boolean matches(ResourceLocation type) {
        return type.func_110624_b().equals("thaumcraft") && type.func_110623_a().equals("entity");
    }

    @Override
    public Collection<IScanThing> parseScan(String key, ResourceLocation type, JsonElement input) {
        if (input.isJsonArray()) {
            ArrayList<IScanThing> things = new ArrayList<IScanThing>();
            for (JsonElement e : input.getAsJsonArray()) {
                things.add(this.parseElement(key, e));
            }
            return things;
        }
        return Lists.newArrayList((Object[])new IScanThing[]{this.parseElement(key, input)});
    }
}

