/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.modmanager;

import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.modmanager.IMod;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import murlen.util.fscript.FSException;
import murlen.util.fscript.FSFastExtension;
import murlen.util.fscript.FSFunctionExtension;
import murlen.util.fscript.FScript;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;

public class ModManager {
    HashSet<ModDescription> mods = new HashSet();
    private static final String modsClassPath = "com.bymarcin.zettaindustries.mods.";
    private FScript fsEngine = new FScript();
    private final HashSet<String> aMods = new HashSet();

    public ModManager() {
        FSFastExtension ext = new FSFastExtension();
        ext.addFunctionExtension("C", new FSFunctionExtension(){

            @Override
            public Object callFunction(String name, ArrayList params) throws FSException {
                if (params.size() != 1) {
                    return 0;
                }
                return ModManager.this.aMods.contains(params.get(0)) ? 1 : 0;
            }
        });
        this.fsEngine.registerExtension(ext);
    }

    private void addMods() {
        this.addMod("quarryfixer.QuarryFixer", "$('buildcraftbuilders')", "QuarryFixer");
        this.addMod("nfc.NFC", "$('opencomputers')", "NFC");
        this.addMod("rfpowermeter.RFMeter", "", "FUPowerMeter");
        this.addMod("vanillautils.VanillaUtils", "", "VanillaUtils");
        this.addMod("battery.Battery", "", "BigBattery");
        this.addMod("ecatalogue.ECatalogueMod", "$('opencomputers') && $('forestry')", "E-Catalogue");
        this.addMod("battery.CharcoalBlockMod", "", "CharcoalBlock");
        this.addMod("ocwires.OCWires", "$('opencomputers') && $('immersiveengineering')", "OCWires");
        this.addMod("wiregun.WireGun", "$('immersiveengineering')", "WireGun");
    }

    private void addMod(String path, String dependencies, String name) {
        this.mods.add(new ModDescription(modsClassPath + path, dependencies, ZettaIndustries.instance.config.get("Mods", name, true).getBoolean(true)));
    }

    public void preInit() {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            this.aMods.add(modContainer.getModId());
        }
        for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
            this.aMods.add(modContainer.getModId());
        }
        this.addMods();
        for (ModDescription modDescription : this.mods) {
            if (modDescription.toLoad.booleanValue()) {
                this.loadMod(modDescription);
            }
            if (!modDescription.isLoaded.booleanValue()) continue;
            ZettaIndustries.logger.info("Start loading [" + modDescription.classPath + "]");
            MinecraftForge.EVENT_BUS.register((Object)modDescription.mod);
            modDescription.mod.preInit();
            ZettaIndustries.logger.info("Modification has been loaded [" + modDescription.classPath + "]");
        }
    }

    public void init() {
        for (ModDescription mod : this.mods) {
            if (!mod.isLoaded.booleanValue()) continue;
            ZettaIndustries.logger.info("Start init [" + mod.classPath + "]");
            mod.mod.init();
            ZettaIndustries.logger.info("Finish init [" + mod.classPath + "]");
        }
    }

    public void postInit() {
        for (ModDescription mod : this.mods) {
            if (!mod.isLoaded.booleanValue()) continue;
            mod.mod.postInit();
        }
    }

    private void loadMod(ModDescription mod) {
        try {
            Class<?> modClass = Class.forName(mod.classPath);
            Constructor<?> c = modClass.getConstructor(new Class[0]);
            mod.mod = (IMod)c.newInstance(new Object[0]);
            mod.isLoaded = mod.mod != null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            ZettaIndustries.logger.info("NoClassDefFoundError in:" + mod.classPath);
            throw e;
        }
    }

    private class ModDescription {
        Boolean toLoad = false;
        Boolean isLoaded = false;
        IMod mod = null;
        String classPath;

        public ModDescription(String classPath, String dependencies, Boolean toLoad) {
            this.classPath = classPath;
            this.toLoad = toLoad != false && this.eval(dependencies);
        }

        private boolean eval(String dependencies) {
            if (dependencies.trim().isEmpty()) {
                return true;
            }
            try {
                return (Integer)ModManager.this.fsEngine.evaluateExpression(dependencies.replace("'", "\"").replace("$", "C")) != 0;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (FSException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

