/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.common;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;

public class CoordTriplet
implements Comparable {
    public int x;
    public int y;
    public int z;

    public CoordTriplet(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public long getChunkXZHash() {
        return ChunkPos.func_77272_a((int)(this.x >> 4), (int)(this.z >> 4));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CoordTriplet) {
            CoordTriplet otherTriplet = (CoordTriplet)other;
            return this.x == otherTriplet.x && this.y == otherTriplet.y && this.z == otherTriplet.z;
        }
        return false;
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.x;
        hash = 71 * hash + this.y;
        hash = 71 * hash + this.z;
        return hash;
    }

    public CoordTriplet copy() {
        return new CoordTriplet(this.x, this.y, this.z);
    }

    public void copy(CoordTriplet other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public CoordTriplet[] getNeighbors() {
        return new CoordTriplet[]{new CoordTriplet(this.x + 1, this.y, this.z), new CoordTriplet(this.x - 1, this.y, this.z), new CoordTriplet(this.x, this.y + 1, this.z), new CoordTriplet(this.x, this.y - 1, this.z), new CoordTriplet(this.x, this.y, this.z + 1), new CoordTriplet(this.x, this.y, this.z - 1)};
    }

    public int compareTo(Object o) {
        if (o instanceof CoordTriplet) {
            CoordTriplet other = (CoordTriplet)o;
            if (this.x < other.x) {
                return -1;
            }
            if (this.x > other.x) {
                return 1;
            }
            if (this.y < other.y) {
                return -1;
            }
            if (this.y > other.y) {
                return 1;
            }
            if (this.z < other.z) {
                return -1;
            }
            if (this.z > other.z) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public EnumFacing getDirectionFromSourceCoords(int x, int y, int z) {
        if (this.x < x) {
            return EnumFacing.WEST;
        }
        if (this.x > x) {
            return EnumFacing.EAST;
        }
        if (this.y < y) {
            return EnumFacing.DOWN;
        }
        if (this.y > y) {
            return EnumFacing.UP;
        }
        if (this.z < z) {
            return EnumFacing.SOUTH;
        }
        if (this.z > z) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public EnumFacing getOppositeDirectionFromSourceCoords(int x, int y, int z) {
        if (this.x < x) {
            return EnumFacing.EAST;
        }
        if (this.x > x) {
            return EnumFacing.WEST;
        }
        if (this.y < y) {
            return EnumFacing.UP;
        }
        if (this.y > y) {
            return EnumFacing.DOWN;
        }
        if (this.z < z) {
            return EnumFacing.NORTH;
        }
        if (this.z > z) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.x, this.y, this.z);
    }

    public int compareTo(int xCoord, int yCoord, int zCoord) {
        if (this.x < xCoord) {
            return -1;
        }
        if (this.x > xCoord) {
            return 1;
        }
        if (this.y < yCoord) {
            return -1;
        }
        if (this.y > yCoord) {
            return 1;
        }
        if (this.z < zCoord) {
            return -1;
        }
        if (this.z > zCoord) {
            return 1;
        }
        return 0;
    }
}

