/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils.render;

import com.bymarcin.zettaindustries.utils.render.LightInfo;
import com.bymarcin.zettaindustries.utils.render.cmd.RenderCommand;
import com.bymarcin.zettaindustries.utils.render.cmd.executor.IRenderCommandExecutor;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix4f;

public class CustomModel {
    private LinkedList<RenderCommand> modelCommands = new LinkedList();
    private ArrayList<IRenderCommandExecutor> buffer = new ArrayList();
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;
    private boolean hasBuffer = false;
    private LightInfo[] currentLight = new LightInfo[6];
    private int lastNormalDir = 0;

    public CustomModel() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public CustomModel dispose() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        return this;
    }

    public void generateBuffer() {
        LinkedList<Matrix4f> transformationMatrix = new LinkedList<Matrix4f>();
        transformationMatrix.add(Matrix4f.setIdentity((Matrix4f)new Matrix4f()));
        for (RenderCommand cmd : this.modelCommands) {
            IRenderCommandExecutor executor = cmd.getExecutor(transformationMatrix, this.minU, this.maxU, this.minV, this.maxV);
            if (executor == null) continue;
            this.buffer.add(executor);
        }
        this.hasBuffer = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Post event) {
        this.clearBuffer();
    }

    public CustomModel addCommand(RenderCommand cmd) {
        this.modelCommands.add(cmd);
        return this;
    }

    public CustomModel create() {
        this.clearBuffer();
        this.generateBuffer();
        return this;
    }

    public void clearBuffer() {
        this.buffer.clear();
        this.hasBuffer = false;
    }

    public LinkedList<RenderCommand> getModelCommands() {
        return this.modelCommands;
    }

    public CustomModel setUV(float minU, float maxU, float minV, float maxV) {
        this.minU = minU;
        this.maxU = maxU;
        this.minV = minV;
        this.maxV = maxV;
        return this;
    }

    public LightInfo getCurrentLightForLastNormalDir() {
        return this.currentLight[this.lastNormalDir];
    }

    public void setLastNormalDir(int lastNormalDir) {
        this.lastNormalDir = lastNormalDir;
    }

    public int getLastNormalDir() {
        return this.lastNormalDir;
    }

    public LightInfo getCurrentLightForSide(int side) {
        return this.currentLight[side];
    }

    public boolean hasBuffer() {
        return this.hasBuffer;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public float getMinU() {
        return this.minU;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public float getMinV() {
        return this.minV;
    }
}

