/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils.render;

import com.bymarcin.zettaindustries.utils.render.CustomModel;
import com.bymarcin.zettaindustries.utils.render.cmd.RenderCommand;
import com.bymarcin.zettaindustries.utils.render.cmd.Rotate;
import com.bymarcin.zettaindustries.utils.render.cmd.Translate;

public class CustomModelFactory {
    static float angel = 0.0f;

    public static CustomModel createModel() {
        return new CustomModel();
    }

    public static CustomModel rotateModel(float angle, float x, float y, float z, CustomModel model) {
        CustomModel newModel = CustomModelFactory.createModel();
        newModel.setUV(model.getMinU(), model.getMaxU(), model.getMinV(), model.getMaxV());
        newModel.addCommand(new Translate(0.5f, 0.5f, 0.5f));
        newModel.addCommand(new Rotate(angle, x, y, z));
        newModel.addCommand(new Translate(-0.5f, -0.5f, -0.5f));
        for (RenderCommand cmd : model.getModelCommands()) {
            newModel.addCommand(cmd);
        }
        return newModel;
    }

    public static CustomModel translateModel(float x, float y, float z, CustomModel model) {
        CustomModel newModel = CustomModelFactory.createModel();
        newModel.setUV(model.getMinU(), model.getMaxU(), model.getMinV(), model.getMaxV());
        newModel.addCommand(new Translate(x, y, z));
        for (RenderCommand cmd : model.getModelCommands()) {
            newModel.addCommand(cmd);
        }
        return newModel;
    }
}

