/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import murlen.util.fscript.ETreeNode;
import murlen.util.fscript.FSException;
import murlen.util.fscript.FSObject;
import murlen.util.fscript.FScript;
import murlen.util.fscript.LexAnn;
import murlen.util.fscript.LineLoader;

final class Parser {
    public static final Integer FS_TRUE = new Integer(1);
    public static final Integer FS_FALSE = new Integer(0);
    private LineLoader code;
    private LexAnn tok;
    private int maxLine;
    private HashMap vars;
    private HashMap gVars;
    private static HashMap opPrio;
    private FScript host;
    private HashMap funcs;
    private Object retVal;
    private Parser subParser;
    private String[] error;

    Parser(FScript h) {
        this.vars = new HashMap();
        this.gVars = null;
        this.funcs = new HashMap();
        this.host = h;
        this.setPrio();
    }

    private Parser(FScript h, HashMap l, HashMap g, HashMap f) {
        this.vars = l;
        this.gVars = g;
        this.funcs = f;
        this.host = h;
    }

    void setCode(LineLoader in) {
        this.code = in;
    }

    Object parse(int from, int to) throws IOException, FSException {
        if (this.code.lineCount() <= from) {
            return null;
        }
        this.maxLine = to;
        this.code.setCurLine(from);
        this.tok = new LexAnn(this.code.getLine());
        this.getNextToken();
        while (this.tok.ttype != 9003) {
            try {
                this.parseStmt();
            }
            catch (RetException e) {
                return this.retVal;
            }
            this.getNextToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object parse(String line) throws IOException, FSException {
        int oldLine = this.code.curLine;
        try {
            this.code.curLine = -1;
            this.code.forError = line;
            char[] chars = line.toCharArray();
            LineLoader.checkLine(chars);
            this.tok = new LexAnn(chars);
            this.tok.nextToken();
            try {
                this.parseStmt();
            }
            catch (RetException e) {
                Object object = this.retVal;
                this.code.curLine = oldLine;
                return object;
            }
        }
        finally {
            this.code.curLine = oldLine;
        }
        return null;
    }

    void reset() {
        if (this.vars != null) {
            this.vars.clear();
        }
        if (this.gVars != null) {
            this.gVars.clear();
        }
    }

    private void setPrio() {
        if (opPrio == null) {
            opPrio = new HashMap();
            Integer prio = new Integer(1);
            opPrio.put(new Integer(9029), prio);
            prio = new Integer(2);
            opPrio.put(new Integer(9028), prio);
            prio = new Integer(5);
            opPrio.put(new Integer(9030), prio);
            opPrio.put(new Integer(9031), prio);
            opPrio.put(new Integer(9032), prio);
            opPrio.put(new Integer(9034), prio);
            opPrio.put(new Integer(9033), prio);
            opPrio.put(new Integer(9035), prio);
            prio = new Integer(10);
            opPrio.put(new Integer(9023), prio);
            opPrio.put(new Integer(9024), prio);
            prio = new Integer(20);
            opPrio.put(new Integer(9025), prio);
            opPrio.put(new Integer(9026), prio);
            opPrio.put(new Integer(9027), prio);
        }
    }

    private void parseStmt() throws IOException, FSException, RetException {
        switch (this.tok.ttype) {
            case 9018: 
            case 9019: 
            case 9020: 
            case 9021: {
                this.parseVarDef();
                break;
            }
            case 9009: {
                this.parseIf();
                break;
            }
            case 9016: {
                this.parseWhile();
                break;
            }
            case 9022: {
                this.parseReturn();
                break;
            }
            case 9014: {
                this.parseFunctionDef();
                break;
            }
            case 9015: {
                this.parseFunctionEnd();
                break;
            }
            case 9010: {
                throw new FSException("unexpected endif");
            }
            case 9017: {
                throw new FSException("unexpected endwhile");
            }
            case 9006: {
                this.parseFunc();
                break;
            }
            case 9007: {
                this.parseArrayAssign();
                break;
            }
            case 9000: {
                this.parseAssign();
                break;
            }
            case 9004: {
                this.tok.nextToken();
                break;
            }
            case 9003: {
                break;
            }
            default: {
                this.parseError("Expected identifier " + this.tok);
            }
        }
    }

    private void parseFunc() throws IOException, FSException {
        String name = (String)this.tok.value;
        this.getNextToken();
        this.parseCallFunc(name);
        this.getNextToken();
    }

    private void parseArrayAssign() throws IOException, FSException {
        String name = (String)this.tok.value;
        this.getNextToken();
        this.getNextToken();
        Object index = this.parseExpr();
        this.getNextToken();
        if (this.tok.ttype != 9037) {
            this.parseError("Expected '='");
        } else {
            this.getNextToken();
            Object val = this.parseExpr();
            try {
                this.host.setVarEntry(name, index, val);
            }
            catch (Exception e) {
                this.parseError(e.getMessage());
            }
        }
    }

    private void parseReturn() throws IOException, FSException, RetException {
        this.getNextToken();
        this.retVal = this.parseExpr();
        throw new RetException();
    }

    private void parseFunctionEnd() throws RetException {
        this.retVal = FS_TRUE;
        throw new RetException();
    }

    private void parseAssign() throws IOException, FSException {
        String name = (String)this.tok.value;
        this.getNextToken();
        if (this.tok.ttype != 9037) {
            this.parseError("Expected '='");
        } else {
            this.getNextToken();
            Object val = this.parseExpr();
            if (this.hasVar(name)) {
                this.setVar(name, val);
            } else {
                try {
                    this.host.setVarEntry(name, null, val);
                }
                catch (Exception e) {
                    this.parseError(e.getMessage());
                }
            }
        }
    }

    Object callFunction(String name, ArrayList params) throws IOException, FSException {
        Object val = null;
        if (this.funcs.containsKey(name)) {
            FuncEntry fDef = (FuncEntry)this.funcs.get(name);
            if (fDef.paramNames.size() != params.size()) {
                this.parseError("Expected " + fDef.paramNames.size() + " parameters, Found " + params.size());
            }
            HashMap locals = new HashMap();
            for (int n = 0; n < fDef.paramNames.size(); ++n) {
                locals.put(fDef.paramNames.get(n), params.get(n));
            }
            Parser p = this.gVars == null ? new Parser(this.host, locals, this.vars, this.funcs) : new Parser(this.host, locals, this.gVars, this.funcs);
            int oldLine = this.code.getCurLine();
            p.setCode(this.code);
            Parser oldSubParser = this.subParser;
            this.subParser = p;
            val = p.parse(fDef.startLine + 1, fDef.endLine - 1);
            this.subParser = oldSubParser;
            this.code.setCurLine(oldLine);
        } else {
            try {
                val = this.host.callFunctionEntry(name, params);
            }
            catch (Exception e) {
                this.parseError(e.getMessage());
            }
        }
        return val;
    }

    private Object parseCallFunc(String name) throws IOException, FSException {
        ArrayList<Object> params = new ArrayList<Object>(4);
        do {
            this.getNextToken();
            if (this.tok.ttype == 44) {
                this.getNextToken();
            } else if (this.tok.ttype == 41) break;
            params.add(this.parseExpr());
        } while (this.tok.ttype == 44);
        return this.callFunction(name, params);
    }

    private void parseFunctionDef() throws IOException, FSException {
        FuncEntry fDef = new FuncEntry();
        fDef.startLine = this.code.getCurLine();
        this.getNextToken();
        if (this.tok.ttype != 9006) {
            this.parseError("Expected function start identifier");
        }
        String fName = (String)this.tok.value;
        this.getNextToken();
        if (this.tok.ttype != 40) {
            this.parseError("Expected (");
        }
        this.getNextToken();
        while (this.tok.ttype != 41) {
            Object val = null;
            if (this.tok.ttype == 9018) {
                val = FS_FALSE;
            } else if (this.tok.ttype == 9019) {
                val = new String("");
            } else if (this.tok.ttype == 9021) {
                val = new FSObject();
            } else {
                this.parseError("Expected type name");
            }
            this.getNextToken();
            if (this.tok.ttype != 9000) {
                this.parseError("Expected function parameter name identifier");
            }
            String name = (String)this.tok.value;
            fDef.paramNames.add(name);
            fDef.params.put(name, val);
            this.getNextToken();
            if (this.tok.ttype != 44) continue;
            this.getNextToken();
        }
        while (this.tok.ttype != 9015 && this.tok.ttype != 9003) {
            this.getNextToken();
            if (this.tok.ttype != 9014) continue;
            this.parseError("Nested functions are illegal");
        }
        fDef.endLine = this.code.getCurLine();
        this.getNextToken();
        this.funcs.put(fName, fDef);
    }

    private Object parseExpr() throws IOException, FSException {
        ETreeNode curNode = null;
        boolean end = false;
        boolean negate = false;
        boolean not = false;
        boolean prevOp = true;
        while (!end) {
            switch (this.tok.ttype) {
                case 9000: 
                case 9001: 
                case 9002: 
                case 9005: 
                case 9006: 
                case 9007: 
                case 9008: {
                    if (!prevOp) {
                        this.parseError("Expected Operator");
                        break;
                    }
                    Object val = null;
                    ETreeNode node = new ETreeNode();
                    node.type = ETreeNode.E_VAL;
                    switch (this.tok.ttype) {
                        case 9001: {
                            val = this.tok.value;
                            break;
                        }
                        case 9002: {
                            val = this.tok.value;
                            break;
                        }
                        case 9006: {
                            String name = (String)this.tok.value;
                            this.getNextToken();
                            val = this.parseCallFunc(name);
                            break;
                        }
                        case 9007: {
                            String name = (String)this.tok.value;
                            this.getNextToken();
                            this.getNextToken();
                            Object index = this.parseExpr();
                            try {
                                val = this.host.getVarEntry(name, index);
                            }
                            catch (Exception e) {
                                this.parseError(e.getMessage());
                            }
                            break;
                        }
                        case 9000: {
                            if (this.hasVar((String)this.tok.value)) {
                                val = this.getVar((String)this.tok.value);
                                break;
                            }
                            try {
                                val = this.host.getVarEntry((String)this.tok.value, null);
                            }
                            catch (Exception e) {
                                this.parseError(e.getMessage());
                            }
                            break;
                        }
                        case 9005: {
                            val = this.tok.value;
                            break;
                        }
                        case 9008: {
                            val = new FSObject(null);
                        }
                    }
                    if (not) {
                        if (val instanceof Integer) {
                            val = (Integer)val == 0 ? FS_TRUE : FS_FALSE;
                            not = false;
                        } else if (val instanceof FSObject && ((FSObject)val).getObject() instanceof Boolean) {
                            val = ((FSObject)val).getObject().equals(Boolean.FALSE) ? FS_TRUE : FS_FALSE;
                        } else if (val instanceof FSObject && ((FSObject)val).getObject() instanceof Integer) {
                            val = (Integer)((FSObject)val).getObject() == 0 ? FS_TRUE : FS_FALSE;
                        } else {
                            String msg = val.getClass().getName();
                            if (val instanceof FSObject) {
                                msg = "FSObject with " + ((FSObject)val).getNullClass().getName();
                            }
                            this.parseError("Type mismatch for ! " + msg);
                        }
                    }
                    if (negate) {
                        if (val instanceof Integer) {
                            val = new Integer(-((Integer)val).intValue());
                        } else if (val instanceof Double) {
                            val = new Double(-((Double)val).doubleValue());
                        } else {
                            this.parseError("Type mistmatch for unary -");
                        }
                    }
                    node.value = val;
                    if (curNode != null) {
                        if (curNode.left == null) {
                            curNode.left = node;
                            node.parent = curNode;
                            curNode = node;
                        } else if (curNode.right == null) {
                            curNode.right = node;
                            node.parent = curNode;
                            curNode = node;
                        }
                    } else {
                        curNode = node;
                    }
                    prevOp = false;
                    break;
                }
                case 9023: 
                case 9024: 
                case 9025: 
                case 9026: 
                case 9027: 
                case 9028: 
                case 9029: 
                case 9030: 
                case 9031: 
                case 9032: 
                case 9033: 
                case 9034: 
                case 9035: 
                case 9036: {
                    if (prevOp) {
                        if (this.tok.ttype == 9024) {
                            negate = true;
                            break;
                        }
                        if (this.tok.ttype == 9036) {
                            not = true;
                            break;
                        }
                        this.parseError("Expected Expression");
                        break;
                    }
                    ETreeNode node = new ETreeNode();
                    node.type = ETreeNode.E_OP;
                    node.value = new Integer(this.tok.ttype);
                    if (curNode.parent != null) {
                        int parPrio;
                        int curPrio = this.getPrio(this.tok.ttype);
                        if (curPrio <= (parPrio = this.getPrio((Integer)curNode.parent.value))) {
                            node.parent = curNode.parent.parent;
                            node.left = curNode.parent;
                            if (curNode.parent.parent != null) {
                                curNode.parent.parent.right = node;
                            }
                            curNode.parent = node;
                            curNode = node;
                        } else {
                            curNode.parent.right = node;
                            node.left = curNode;
                            node.parent = curNode.parent;
                            curNode.parent = node;
                            curNode = node;
                        }
                    } else {
                        node.left = curNode;
                        curNode.parent = node;
                        curNode = node;
                    }
                    prevOp = true;
                    break;
                }
                case 40: {
                    this.getNextToken();
                    Object val = this.parseExpr();
                    if (negate) {
                        if (val instanceof Integer) {
                            val = new Integer(-((Integer)val).intValue());
                        } else if (val instanceof Double) {
                            val = new Double(-((Double)val).doubleValue());
                        } else {
                            this.parseError("Type mistmatch for unary -");
                        }
                    }
                    ETreeNode node = new ETreeNode();
                    node.value = val;
                    node.type = ETreeNode.E_VAL;
                    if (curNode != null) {
                        if (curNode.left == null) {
                            curNode.left = node;
                            node.parent = curNode;
                            curNode = node;
                        } else if (curNode.right == null) {
                            curNode.right = node;
                            node.parent = curNode;
                            curNode = node;
                        }
                    } else {
                        curNode = node;
                    }
                    prevOp = false;
                    break;
                }
                default: {
                    end = true;
                }
            }
            if (end) continue;
            this.tok.nextToken();
        }
        if (curNode == null) {
            this.parseError("Missing Expression");
        }
        while (curNode.parent != null) {
            curNode = curNode.parent;
        }
        return this.evalETree(curNode);
    }

    private int getPrio(int op) {
        return (Integer)opPrio.get(new Integer(op));
    }

    private Object evalETree(ETreeNode node) throws FSException {
        if (node == null) {
            this.parseError("Malformed expression");
            return null;
        }
        if (node.type == ETreeNode.E_VAL) {
            return node.value;
        }
        Object lVal = this.evalETree(node.left);
        Object rVal = this.evalETree(node.right);
        switch ((Integer)node.value) {
            case 9023: {
                return this.evalPlus(lVal, rVal);
            }
            case 9024: {
                return this.evalMinus(lVal, rVal);
            }
            case 9025: {
                return this.evalMult(lVal, rVal);
            }
            case 9026: {
                return this.evalDiv(lVal, rVal);
            }
            case 9030: {
                return this.evalEq(lVal, rVal);
            }
            case 9031: {
                return this.evalNEq(lVal, rVal);
            }
            case 9033: {
                return this.evalLs(lVal, rVal);
            }
            case 9035: {
                return this.evalLse(lVal, rVal);
            }
            case 9032: {
                return this.evalGr(lVal, rVal);
            }
            case 9034: {
                return this.evalGre(lVal, rVal);
            }
            case 9027: {
                return this.evalMod(lVal, rVal);
            }
            case 9028: {
                return this.evalAnd(lVal, rVal);
            }
            case 9029: {
                return this.evalOr(lVal, rVal);
            }
        }
        return null;
    }

    private Object evalPlus(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            return new Integer((Integer)lVal + (Integer)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            return new Double((Double)lVal + (Double)rVal);
        }
        if (lVal instanceof String || rVal instanceof String) {
            return new String(lVal.toString() + rVal.toString());
        }
        if (lVal instanceof Double && rVal instanceof Integer) {
            return new Double((Double)lVal + (double)((Integer)rVal).intValue());
        }
        if (lVal instanceof Integer && rVal instanceof Double) {
            return new Double((double)((Integer)lVal).intValue() + (Double)rVal);
        }
        this.parseError("Type Mismatch for operator +");
        return null;
    }

    private Object evalMinus(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            return new Integer((Integer)lVal - (Integer)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            return new Double((Double)lVal - (Double)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Integer) {
            return new Double((Double)lVal - (double)((Integer)rVal).intValue());
        }
        if (lVal instanceof Integer && rVal instanceof Double) {
            return new Double((double)((Integer)lVal).intValue() - (Double)rVal);
        }
        this.parseError("Type Mismatch for operator -");
        return null;
    }

    private Object evalMult(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            return new Integer((Integer)lVal * (Integer)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            return new Double((Double)lVal * (Double)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Integer) {
            return new Double((Double)lVal * (double)((Integer)rVal).intValue());
        }
        if (lVal instanceof Integer && rVal instanceof Double) {
            return new Double((double)((Integer)lVal).intValue() * (Double)rVal);
        }
        this.parseError("Type Mismatch for operator *");
        return null;
    }

    private Object evalMod(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            return new Integer((Integer)lVal % (Integer)rVal);
        }
        this.parseError("Type Mismatch for operator %");
        return null;
    }

    private Object evalAnd(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            boolean b2;
            boolean b1 = (Integer)lVal != 0;
            boolean bl = b2 = (Integer)rVal != 0;
            if (b1 && b2) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator &&");
        return null;
    }

    private Object evalOr(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            boolean b2;
            boolean b1 = (Integer)lVal != 0;
            boolean bl = b2 = (Integer)rVal != 0;
            if (b1 || b2) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator ||");
        return null;
    }

    private Object evalDiv(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            return new Integer((Integer)lVal / (Integer)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            return new Double((Double)lVal / (Double)rVal);
        }
        if (lVal instanceof Double && rVal instanceof Integer) {
            return new Double((Double)lVal / (double)((Integer)rVal).intValue());
        }
        if (lVal instanceof Integer && rVal instanceof Double) {
            return new Double((double)((Integer)lVal).intValue() / (Double)rVal);
        }
        this.parseError("Type Mismatch for operator /");
        return null;
    }

    private Object evalEq(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            if (lVal.equals(rVal)) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            if (lVal.equals(rVal)) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof String && rVal instanceof String) {
            if (lVal.equals(rVal)) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof FSObject) {
            if (lVal.equals(rVal)) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (rVal instanceof FSObject) {
            if (rVal.equals(lVal)) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator ==");
        return null;
    }

    private Object evalLs(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            if ((Integer)lVal < (Integer)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            if ((Double)lVal < (Double)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof String && rVal instanceof String) {
            if (((String)lVal).compareTo((String)rVal) < 0) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator <");
        return null;
    }

    private Object evalLse(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            if ((Integer)lVal <= (Integer)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            if ((Double)lVal <= (Double)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof String && rVal instanceof String) {
            if (((String)lVal).compareTo((String)rVal) <= 0) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator <=");
        return null;
    }

    private Object evalGr(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            if ((Integer)lVal > (Integer)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            if ((Double)lVal > (Double)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof String && rVal instanceof String) {
            if (((String)lVal).compareTo((String)rVal) > 0) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator >");
        return null;
    }

    private Object evalGre(Object lVal, Object rVal) throws FSException {
        if (lVal instanceof Integer && rVal instanceof Integer) {
            if ((Integer)lVal >= (Integer)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof Double && rVal instanceof Double) {
            if ((Double)lVal >= (Double)rVal) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        if (lVal instanceof String && rVal instanceof String) {
            if (((String)lVal).compareTo((String)rVal) >= 0) {
                return FS_TRUE;
            }
            return FS_FALSE;
        }
        this.parseError("Type Mismatch for operator >=");
        return null;
    }

    private Object evalNEq(Object lVal, Object rVal) throws FSException {
        if (this.evalEq(lVal, rVal) == FS_TRUE) {
            return FS_FALSE;
        }
        return FS_TRUE;
    }

    private void parseIf() throws IOException, FSException, RetException {
        Integer val;
        boolean then = false;
        this.getNextToken();
        Object obj = this.parseExpr();
        if (obj instanceof Integer) {
            val = (Integer)obj;
        } else {
            if (obj instanceof FSObject) {
                obj = ((FSObject)obj).getObject();
            }
            if (obj instanceof Boolean) {
                val = (Boolean)obj != false ? FS_TRUE : FS_FALSE;
            } else if (obj instanceof Integer) {
                val = (Integer)obj;
            } else {
                this.parseError("If condition needs to be Integer");
                return;
            }
        }
        if (this.tok.ttype == 9012) {
            this.getNextToken();
            if (this.tok.ttype != 9004) {
                if (val != 0) {
                    this.parseStmt();
                } else {
                    while (this.tok.ttype != 9004) {
                        this.getNextToken();
                    }
                }
                then = true;
            }
        }
        if (!then) {
            if (val != 0) {
                this.getNextToken();
                while (this.tok.ttype != 9010 && this.tok.ttype != 9011 && this.tok.ttype != 9003 && this.tok.ttype != 9013) {
                    this.parseStmt();
                    this.getNextToken();
                }
                if (this.tok.ttype == 9011 || this.tok.ttype == 9013) {
                    int depth = 1;
                    do {
                        this.getNextToken();
                        if (this.tok.ttype == 9009) {
                            ++depth;
                        }
                        if (this.tok.ttype == 9003) {
                            this.parseError("can't find endif");
                        }
                        if (this.tok.ttype == 9010) {
                            --depth;
                        }
                        if (this.tok.ttype != 9012) continue;
                        this.getNextToken();
                        if (this.tok.ttype != 9004) {
                            --depth;
                        }
                        this.tok.pushBack();
                    } while (depth > 0);
                    this.getNextToken();
                } else {
                    this.getNextToken();
                }
            } else {
                int depth = 1;
                do {
                    this.getNextToken();
                    if (this.tok.ttype == 9009) {
                        ++depth;
                    }
                    if (this.tok.ttype == 9003) {
                        this.parseError("can't find endif");
                    }
                    if (this.tok.ttype == 9010) {
                        --depth;
                    }
                    if ((this.tok.ttype == 9011 || this.tok.ttype == 9013) && depth == 1) {
                        --depth;
                    }
                    if (this.tok.ttype != 9012) continue;
                    this.getNextToken();
                    if (this.tok.ttype != 9004) {
                        --depth;
                    }
                    this.tok.pushBack();
                } while (depth > 0);
                if (this.tok.ttype == 9011) {
                    this.getNextToken();
                    this.getNextToken();
                    while (this.tok.ttype != 9010) {
                        this.parseStmt();
                        this.getNextToken();
                    }
                    this.getNextToken();
                } else if (this.tok.ttype == 9013) {
                    this.parseIf();
                } else {
                    this.getNextToken();
                }
            }
        }
    }

    private void parseWhile() throws IOException, FSException, RetException {
        boolean looping = true;
        int startLine = this.code.getCurLine();
        while (looping) {
            Integer val;
            this.getNextToken();
            Object obj = this.parseExpr();
            if (obj instanceof Integer) {
                val = (Integer)obj;
            } else {
                if (obj instanceof FSObject) {
                    obj = ((FSObject)obj).getObject();
                }
                if (obj instanceof Boolean) {
                    val = (Boolean)obj != false ? FS_TRUE : FS_FALSE;
                } else if (obj instanceof Integer) {
                    val = (Integer)obj;
                } else {
                    this.parseError("While condition needs to be Integer");
                    return;
                }
            }
            this.getNextToken();
            if (val == 0) {
                looping = false;
                continue;
            }
            while (this.tok.ttype != 9017 && this.tok.ttype != 9003) {
                this.parseStmt();
                this.getNextToken();
            }
            this.code.setCurLine(startLine);
            this.resetTokens();
        }
        int depth = 1;
        do {
            this.getNextToken();
            if (this.tok.ttype == 9016) {
                ++depth;
            }
            if (this.tok.ttype == 9017) {
                --depth;
            }
            if (this.tok.ttype != 9003) continue;
            this.parseError("can't find endwhile");
        } while (depth > 0);
        this.getNextToken();
    }

    private void parseVarDef() throws IOException, FSException {
        int type = this.tok.ttype;
        do {
            this.getNextToken();
            if (this.tok.ttype != 9000) {
                this.parseError("Expected variable name identifier,");
            }
            String name = (String)this.tok.value;
            switch (type) {
                case 9018: {
                    this.addVar(name, FS_FALSE);
                    break;
                }
                case 9019: {
                    this.addVar(name, new String(""));
                    break;
                }
                case 9020: {
                    this.addVar(name, new Double(0.0));
                    break;
                }
                case 9021: {
                    this.addVar(name, new FSObject());
                }
            }
            this.getNextToken();
            if (this.tok.ttype == 9037) {
                this.getNextToken();
                this.setVar(name, this.parseExpr());
                continue;
            }
            if (this.tok.ttype == 44 || this.tok.ttype == 9004) continue;
            this.parseError("Expected ','");
        } while (this.tok.ttype != 9004);
    }

    private void parseError(String s) throws FSException {
        this.error = new String[6];
        this.error[0] = s;
        this.error[1] = new Integer(this.code.getCurLine()).toString();
        this.error[2] = this.code.getLineAsString();
        this.error[3] = this.tok.toString();
        this.error[4] = this.vars.toString();
        if (this.gVars != null) {
            this.error[5] = this.gVars == null ? "" : this.gVars.toString();
        }
        s = "\n\t" + s + "\n" + this.getContext();
        throw new FSException(s);
    }

    public String getContext() {
        int l = this.code.getCurLine();
        String s = "\t\t at line:" + l + " ";
        if (l > -1) {
            s = s + "\n\t\t\t  " + this.code.getLineAsString(l - 2);
            s = s + "\n\t\t\t  " + this.code.getLineAsString(l - 1);
            s = s + "\n\t\t\t> " + this.code.getLineAsString(l) + " <";
            s = s + "\n\t\t\t  " + this.code.getLineAsString(l + 1);
            s = s + "\n\t\t\t  " + this.code.getLineAsString(l + 2);
            s = s + "\n\t\t current token:" + this.tok.toString();
            s = s + "\n\t\t Variable dump:" + this.vars;
            if (this.gVars != null) {
                s = s + "\n\t\t Globals:" + this.gVars;
            }
        } else {
            s = s + "\n\t\t\t> " + this.tok.getLine() + " <";
        }
        return s;
    }

    String[] getError() {
        return this.error;
    }

    private void getNextToken() throws IOException {
        if (this.tok.ttype == 9004) {
            if (this.code.getCurLine() < this.maxLine) {
                this.code.setCurLine(this.code.getCurLine() + 1);
                this.tok.setString(this.code.getLine());
                this.tok.nextToken();
            } else {
                this.tok.ttype = 9003;
            }
        } else {
            this.tok.nextToken();
        }
    }

    private void resetTokens() throws IOException {
        this.tok.setString(this.code.getLine());
        this.tok.nextToken();
    }

    void addVar(String name, Object value) throws FSException {
        if (this.vars.containsKey(name)) {
            this.parseError("Already defined in this scope: " + name);
        }
        this.vars.put(name, value);
    }

    public Object getVar(String name) {
        if (this.subParser != null) {
            return this.subParser.getVar(name);
        }
        if (this.vars.containsKey(name)) {
            return this.vars.get(name);
        }
        if (this.gVars != null && this.gVars.containsKey(name)) {
            return this.gVars.get(name);
        }
        try {
            return this.host.getVarEntry(name, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setVar(String name, Object val) throws FSException {
        if (val == null) {
            this.parseError("set variable " + name + " with null value");
        }
        if (this.subParser != null) {
            this.subParser.setVar(name, val);
            return;
        }
        Object obj = this.vars.get(name);
        if (obj != null) {
            if (val.getClass() != obj.getClass()) {
                if (obj instanceof FSObject) {
                    if (((FSObject)obj).getObject() == null) {
                        val = new FSObject(val);
                    } else if (((FSObject)obj).getObject().getClass() == val.getClass()) {
                        val = new FSObject(val);
                    } else {
                        this.parseError("Incompatible types");
                    }
                } else {
                    this.parseError("Incompatible types");
                }
            }
            this.vars.remove(name);
            this.vars.put(name, val);
        } else {
            obj = this.gVars.get(name);
            if (obj != null) {
                if (val.getClass() != obj.getClass()) {
                    this.parseError("Incompatible types");
                }
                this.gVars.remove(name);
                this.gVars.put(name, val);
            }
        }
    }

    public boolean hasVar(String name) {
        if (this.subParser != null) {
            return this.subParser.hasVar(name);
        }
        if (this.gVars == null) {
            return this.vars.containsKey(name);
        }
        return this.vars.containsKey(name) || this.gVars.containsKey(name);
    }

    class RetException
    extends Exception {
        RetException() {
        }
    }

    class FuncEntry {
        int startLine = 0;
        int endLine = 0;
        ArrayList paramNames = new ArrayList(4);
        HashMap params = new HashMap();

        FuncEntry() {
        }

        public String toString() {
            String s = this.startLine + " ";
            s = s + this.endLine + " ";
            s = s + this.paramNames + " ";
            s = s + this.params;
            return s;
        }
    }
}

