/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.configuration;

import java.util.HashMap;
import java.util.Map;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.flows.Tokens;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.crypto.ProfileEncryption;

public final class ProfileBuilder {
    private final Map<String, String> profile = new HashMap<String, String>();
    private final ProfileEncryption encryption;

    public ProfileBuilder(SessionData session, ProfileEncryption encryption) {
        this.encryption = encryption;
        this.profile.put("name", session.username);
        this.profile.put("uuid", session.uuid);
        encryption.saveToProfile(this.profile);
    }

    public final Profile buildMicrosoft(Tokens tokens) {
        this.profile.put("type", "microsoft");
        this.profile.put("xbl-token", this.encryption.encryptFieldOne(tokens.getXblToken()));
        this.profile.put("refresh-token", this.encryption.encryptFieldTwo(tokens.getRefreshToken()));
        return ReAuth.profiles.createProfile(this.profile);
    }

    public final Profile buildMojang(String username, String password) {
        this.profile.put("type", "mojang");
        this.profile.put("username", this.encryption.encryptFieldOne(username));
        this.profile.put("password", this.encryption.encryptFieldTwo(password));
        return ReAuth.profiles.createProfile(this.profile);
    }
}

