/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.api.genetics;

import binnie.core.api.genetics.IFieldKitPlugin;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBreedingSystem {
    public ISpeciesRoot getSpeciesRoot();

    public Collection<IAlleleSpecies> getAllSpecies();

    public Collection<IAlleleSpecies> getDiscoveredSpecies(World var1, GameProfile var2);

    public List<IClassification> getAllBranches();

    public Collection<IClassification> getDiscoveredBranches(World var1, GameProfile var2);

    public List<IMutation> getDiscoveredMutations(World var1, GameProfile var2);

    public List<IMutation> getResultantMutations(IAlleleSpecies var1);

    public List<IMutation> getFurtherMutations(IAlleleSpecies var1);

    public boolean isMutationDiscovered(IMutation var1, World var2, GameProfile var3);

    public float getChance(IMutation var1, EntityPlayer var2, IAlleleSpecies var3, IAlleleSpecies var4);

    public String getAlleleName(IChromosomeType var1, IAllele var2);

    public String getChromosomeName(IChromosomeType var1);

    public String getChromosomeShortName(IChromosomeType var1);

    @Nullable
    public IIndividual getConversion(ItemStack var1);

    public ItemStack getConversionStack(ItemStack var1);

    @Nullable
    public IIndividual getIndividual(String var1);

    public void calculateArrays();

    public void addExtraAlleles(IChromosomeType var1, TreeSet<IAllele> var2);

    public String getDescriptor();

    public String getIdent();

    public ItemStack getItemStackRepresentitive();

    public int getColour();

    public int getDiscoveredSpeciesCount();

    public int getTotalSpeciesCount();

    public float getDiscoveredSpeciesPercentage();

    public int getTotalSecretCount();

    public int getDiscoveredSecretCount();

    public float getDiscoveredBranchPercentage();

    public int getTotalBranchCount();

    public int getDiscoveredBranchCount();

    public String getEpitome();

    public String getEpitome(float var1);

    public Collection<IMutation> getAllMutations();

    public void calculateAlleles(ISpeciesRoot var1);

    public void calculateBranches(ISpeciesRoot var1);

    public void calculateMutations(ISpeciesRoot var1);

    public boolean isBlacklisted(IAllele var1);

    public boolean isMutationDiscovered(IMutation var1, IBreedingTracker var2);

    public boolean isSpeciesDiscovered(IAlleleSpecies var1, World var2, GameProfile var3);

    public boolean isSpeciesDiscovered(IAlleleSpecies var1, IBreedingTracker var2);

    public boolean isSecret(IAlleleSpecies var1);

    public boolean isSecret(IClassification var1);

    public Collection<IClassification> getDiscoveredBranches(IBreedingTracker var1);

    public Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker var1);

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getUndiscoveredIcon();

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDiscoveredIcon();

    public Class<? extends IBreedingTracker> getTrackerClass();

    @SubscribeEvent
    public void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker var1);

    public void syncTracker(IBreedingTracker var1);

    public void onSyncBreedingTracker(IBreedingTracker var1);

    public String getName();

    public boolean isDNAManipulable(ItemStack var1);

    public boolean isDNAManipulable(ISpeciesType var1);

    public IIndividual getDefaultIndividual();

    public ISpeciesType getDefaultType();

    public ISpeciesType[] getActiveTypes();

    public Collection<IChromosomeType> getActiveKaryotype();

    public ItemStack getDefaultMember(String var1);

    public IFieldKitPlugin getFieldKitPlugin();
}

