/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.transmission;

import binnie.core.machines.Machine;
import binnie.extrabees.machines.TileExtraBeeAlveary;
import binnie.extrabees.utils.ComponentBeeModifier;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.multiblock.IMultiblockComponent;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ComponentTransmission
extends ComponentBeeModifier
implements IBeeModifier,
IBeeListener {
    public ComponentTransmission(Machine machine) {
        super(machine);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int energy = this.getUtil().getPoweredMachine().getEnergyStored();
        if (energy == 0) {
            return;
        }
        TileExtraBeeAlveary tile = (TileExtraBeeAlveary)this.getMachine().getTileEntity();
        LinkedList<Object> handlers = new LinkedList<Object>();
        for (IMultiblockComponent component : tile.getAlvearyBlocks()) {
            TileEntity alvearyTile;
            if (!(component instanceof TileEntity) || (alvearyTile = (TileEntity)component) == tile || !alvearyTile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.NORTH)) continue;
            handlers.add(alvearyTile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.NORTH));
        }
        if (handlers.isEmpty()) {
            return;
        }
        int maxOutput = 500;
        int output = energy / handlers.size();
        if (output > 500) {
            output = 500;
        }
        if (output < 1) {
            output = 1;
        }
        for (IEnergyStorage iEnergyStorage : handlers) {
            int recieved = iEnergyStorage.receiveEnergy(output, false);
            this.getUtil().getPoweredMachine().receiveEnergy(-recieved, false);
            energy = this.getUtil().getPoweredMachine().getEnergyStored();
            if (energy > 0) continue;
            return;
        }
    }
}

