/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.awt.Rectangle;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;

public class ClickedIngredient<V>
implements IClickedIngredient<V> {
    private final V value;
    @Nullable
    private final Rectangle area;
    @Nullable
    private IClickedIngredient.IOnClickHandler onClickHandler;
    private boolean allowsCheating;

    @Nullable
    public static <V> ClickedIngredient<V> create(V value, @Nullable Rectangle area) {
        ErrorUtil.checkNotNull(value, "value");
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(value);
        try {
            if (ingredientHelper.isValidIngredient(value)) {
                return new ClickedIngredient<V>(value, area);
            }
            String ingredientInfo = ingredientHelper.getErrorInfo(value);
            Log.get().error("Clicked invalid ingredient. Ingredient Info: {}", (Object)ingredientInfo);
        }
        catch (RuntimeException e) {
            String ingredientInfo = ingredientHelper.getErrorInfo(value);
            Log.get().error("Clicked invalid ingredient. Ingredient Info: {}", (Object)ingredientInfo, (Object)e);
        }
        return null;
    }

    private ClickedIngredient(V value, @Nullable Rectangle area) {
        this.value = value;
        this.area = area;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Rectangle getArea() {
        return this.area;
    }

    public void setAllowsCheating() {
        this.allowsCheating = true;
    }

    @Override
    public void setOnClickHandler(IClickedIngredient.IOnClickHandler onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    @Override
    public ItemStack getCheatItemStack() {
        if (this.allowsCheating) {
            IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
            IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(this.value);
            return ingredientHelper.getCheatItemStack(this.value);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack replaceWithCheatItemStack(ItemStack clickedWithStack) {
        if (this.allowsCheating) {
            IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
            IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(this.value);
            return ingredientHelper.replaceWithCheatItemStack(this.value, clickedWithStack);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void onClickHandled() {
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick();
        }
    }
}

