/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.info.providers;

import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.integration.info.ConfigValues;
import pl.asie.computronics.integration.info.providers.ComputronicsInfoProvider;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.util.StringUtil;

public class InfoLocomotiveRelay
extends ComputronicsInfoProvider {
    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!ConfigValues.RelayBound.getValue(config)) {
            return currenttip;
        }
        NBTTagCompound nbt = accessor.getNBTData();
        String boundKey = "tooltip.computronics.waila.relay." + (nbt.func_74767_n("bound") ? "bound" : "notbound");
        currenttip.add(StringUtil.localize(boundKey));
        return currenttip;
    }

    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileLocomotiveRelay) {
            TileLocomotiveRelay relay = (TileLocomotiveRelay)te;
            tag.func_74757_a("bound", relay.isBound());
        }
        return tag;
    }

    @Override
    protected String getUID() {
        return "locomotive_relay";
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (!(tile instanceof TileLocomotiveRelay)) {
            return;
        }
        TileLocomotiveRelay relay = (TileLocomotiveRelay)tile;
        String boundKey = "tooltip.computronics.waila.relay." + (relay.isBound() ? "bound" : "notbound");
        probeInfo.text(StringUtil.localize(boundKey));
    }
}

