/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.TypeSerializer;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

class MapSerializer
implements TypeSerializer<Map<?, ?>> {
    MapSerializer() {
    }

    @Override
    public Map<?, ?> deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode node) throws ObjectMappingException {
        LinkedHashMap ret = new LinkedHashMap();
        if (node.isMap()) {
            if (!(type.getType() instanceof ParameterizedType)) {
                throw new ObjectMappingException("Raw types are not supported for collections");
            }
            TypeToken key = type.resolveType(Map.class.getTypeParameters()[0]);
            TypeToken value = type.resolveType(Map.class.getTypeParameters()[1]);
            @Nullable TypeSerializer<T> keySerial = node.getOptions().getSerializers().get(key);
            @Nullable TypeSerializer<T> valueSerial = node.getOptions().getSerializers().get(value);
            if (keySerial == null) {
                throw new ObjectMappingException("No type serializer available for type " + key);
            }
            if (valueSerial == null) {
                throw new ObjectMappingException("No type serializer available for type " + value);
            }
            ConfigurationNode keyNode = ConfigurationNode.root(node.getOptions());
            for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
                @Nullable T keyValue = keySerial.deserialize(key, keyNode.setValue(ent.getKey()));
                @Nullable T valueValue = valueSerial.deserialize(value, ent.getValue());
                if (keyValue == null || valueValue == null) continue;
                ret.put(keyValue, valueValue);
            }
        }
        return ret;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Map<?, ?> obj, @NonNull ConfigurationNode node) throws ObjectMappingException {
        if (!(type.getType() instanceof ParameterizedType)) {
            throw new ObjectMappingException("Raw types are not supported for collections");
        }
        TypeToken key = type.resolveType(Map.class.getTypeParameters()[0]);
        TypeToken value = type.resolveType(Map.class.getTypeParameters()[1]);
        TypeSerializer<?> keySerial = node.getOptions().getSerializers().get(key);
        TypeSerializer<?> valueSerial = node.getOptions().getSerializers().get(value);
        if (keySerial == null) {
            throw new ObjectMappingException("No type serializer available for type " + key);
        }
        if (valueSerial == null) {
            throw new ObjectMappingException("No type serializer available for type " + value);
        }
        if (obj == null || obj.isEmpty()) {
            node.setValue(ImmutableMap.of());
        } else {
            HashSet<Object> unvisitedKeys = new HashSet<Object>(node.getChildrenMap().keySet());
            ConfigurationNode keyNode = ConfigurationNode.root(node.getOptions());
            for (Map.Entry<?, ?> entry : obj.entrySet()) {
                keySerial.serialize(key, entry.getKey(), keyNode);
                Object keyObj = Objects.requireNonNull(keyNode.getValue(), "Key must not be null!");
                valueSerial.serialize(value, entry.getValue(), node.getNode(keyObj));
                unvisitedKeys.remove(keyObj);
            }
            for (Map.Entry<Object, Object> entry : unvisitedKeys) {
                node.removeChild(entry);
            }
        }
    }
}

