/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.reactive;

import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.MonotonicNonNull;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Disposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.NoOpDisposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Publisher;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Subscriber;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

class PublisherCached<V>
implements Publisher.Cached<V>,
AutoCloseable {
    private final Publisher<V> parent;
    private final Set<Subscriber<? super V>> subscribers = ConcurrentHashMap.newKeySet();
    private volatile @MonotonicNonNull V value;
    private final Disposable closer;

    public PublisherCached(Publisher<V> parent, @Nullable V initialValue) {
        this.parent = parent;
        this.value = initialValue;
        this.closer = this.parent.subscribe(value -> {
            this.value = value;
        });
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        Disposable disp = this.parent.subscribe(subscriber);
        if (disp != NoOpDisposable.INSTANCE) {
            this.subscribers.add(subscriber);
            V value = this.value;
            if (value != null) {
                subscriber.submit(value);
            }
            return () -> {
                this.subscribers.remove(subscriber);
                disp.dispose();
            };
        }
        return disp;
    }

    @Override
    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    @Override
    public Publisher.Cached<V> cache() {
        return this;
    }

    @Override
    public Publisher.Cached<V> cache(@Nullable V initialValue) {
        if (this.value == null) {
            this.value = initialValue;
        }
        return this;
    }

    @Override
    public Executor getExecutor() {
        return this.parent.getExecutor();
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public void submit(V value) {
        this.value = value;
        this.subscribers.forEach(it -> it.submit(value));
    }

    @Override
    public void close() {
        this.closer.dispose();
    }
}

