/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.surface.builder;

import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.Biome;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.surface.SurfaceConfig;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.surface.builder.SurfaceBuilder;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.source.BiomeSource;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.block.Block;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.block.Blocks;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.rand.ChunkRand;

public class NetherSurfaceBuilder
extends SurfaceBuilder {
    public NetherSurfaceBuilder(SurfaceConfig surfaceConfig) {
        super(surfaceConfig);
    }

    @Override
    public Block[] applyToColumn(BiomeSource source, ChunkRand rand, Block[] column, Biome biome, int x, int z, int maxY, int minY, double noise, int seaLevel, Block defaultBlock, Block defaultFluid) {
        boolean shouldExpose = source.getStaticNoiseSource().getNetherForestsNoise().sample((double)x * 0.03125, (double)z * 0.03125, 0.0) * 75.0 + rand.nextDouble() > 0.0;
        boolean shouldUnderwater = source.getStaticNoiseSource().getNetherForestsNoise().sample((double)x * 0.03125, 109.0, (double)z * 0.03125) * 75.0 + rand.nextDouble() > 0.0;
        int elevation = (int)(noise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int state = -1;
        Block topBlock = this.getSurfaceConfig().getTopBlock();
        Block underBlock = this.getSurfaceConfig().getUnderBlock();
        for (int y = Math.max(127, maxY); y >= minY; --y) {
            Block block = column[y];
            if (Block.IS_AIR.test(source.getVersion(), block)) {
                state = -1;
            } else if (block == defaultBlock) {
                if (state == -1) {
                    boolean isBelow = false;
                    if (elevation <= 0) {
                        isBelow = true;
                        underBlock = this.getSurfaceConfig().getUnderBlock();
                    } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                        topBlock = this.getSurfaceConfig().getTopBlock();
                        underBlock = this.getSurfaceConfig().getUnderBlock();
                        if (shouldUnderwater) {
                            topBlock = Blocks.GRAVEL;
                            underBlock = this.getSurfaceConfig().getUnderwaterBlock();
                        }
                        if (shouldExpose) {
                            topBlock = Blocks.SOUL_SAND;
                            underBlock = Blocks.SOUL_SAND;
                        }
                    }
                    if (y < seaLevel && isBelow) {
                        topBlock = defaultFluid;
                    }
                    state = elevation;
                    block = y >= seaLevel - 1 ? topBlock : underBlock;
                } else if (state > 0) {
                    --state;
                    block = underBlock;
                }
            }
            column[y] = block;
        }
        return column;
    }
}

