/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mathutils.decomposition;

import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mathutils.arithmetic.Rational;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mathutils.arithmetic.Real;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mathutils.component.matrix.QMatrix;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mathutils.component.matrix.RMatrix;

public class LUDecomposition {
    public static Q of(QMatrix matrix) {
        return new Q(matrix);
    }

    public static R of(RMatrix matrix) {
        return new R(matrix);
    }

    public static class R {
        private final RMatrix matrix;
        private final int size;
        private RMatrix P;
        private RMatrix L;
        private RMatrix U;
        private RMatrix LU;
        private boolean singular;
        private int swaps;
        private int[] pivot;
        private Real det;
        private RMatrix inv;

        protected R(RMatrix matrix) {
            if (!matrix.isSquare()) {
                throw new IllegalArgumentException("Matrix is not square");
            }
            this.matrix = matrix;
            this.size = this.matrix.getRowCount();
        }

        public R refresh() {
            this.P = null;
            this.L = null;
            this.U = null;
            this.LU = null;
            this.singular = false;
            this.swaps = -1;
            this.pivot = null;
            this.det = null;
            this.inv = null;
            return this;
        }

        public RMatrix getMatrix() {
            return this.matrix;
        }

        public int getSize() {
            return this.size;
        }

        public RMatrix getP() {
            if (this.P != null) {
                return this.P;
            }
            int[] pivot = this.getPivot();
            if (pivot == null) {
                return null;
            }
            this.P = RMatrix.identity(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.P.swapRowsAndSet(i, pivot[i]);
            }
            return this.P;
        }

        public RMatrix getL() {
            if (this.L != null) {
                return this.L;
            }
            RMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.L = lu.map((row, column, oldValue) -> row > column ? oldValue : (row == column ? Real.ONE : Real.ZERO));
            return this.L;
        }

        public RMatrix getU() {
            if (this.U != null) {
                return this.U;
            }
            RMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.U = lu.map((row, col, oldValue) -> row <= col ? oldValue : Real.ZERO);
            return this.U;
        }

        public boolean isSingular() {
            this.getLU();
            return this.singular;
        }

        public RMatrix getLU() {
            if (this.LU != null || this.singular) {
                return this.LU;
            }
            this.LU = this.matrix.copy();
            this.pivot = new int[this.size];
            this.swaps = 0;
            for (int i = 0; i < this.size; ++i) {
                int row;
                int pivot = -1;
                Real largest = Real.ZERO;
                for (row = i; row < this.size; ++row) {
                    Real value = this.LU.get(row, i).abs();
                    if (value.signum() == 0 || value.compareTo(largest) <= 0) continue;
                    largest = value;
                    pivot = row;
                }
                if (pivot == -1) {
                    this.singular = true;
                    this.LU = null;
                    this.pivot = null;
                    this.swaps = -1;
                    return null;
                }
                this.pivot[i] = pivot;
                if (pivot != i) {
                    this.LU.swapRowsAndSet(i, pivot);
                    ++this.swaps;
                }
                for (row = i + 1; row < this.size; ++row) {
                    Real divisor = this.LU.get(i, i);
                    this.LU.set(row, i, this.LU.get(row, i).divide(divisor));
                }
                for (row = i + 1; row < this.size; ++row) {
                    for (int column = i + 1; column < this.size; ++column) {
                        Real subtrahend = this.LU.get(row, i).multiply(this.LU.get(i, column));
                        this.LU.set(row, column, this.LU.get(row, column).subtract(subtrahend));
                    }
                }
            }
            return this.LU;
        }

        public int getSwaps() {
            if (this.LU != null) {
                return this.swaps;
            }
            this.getLU();
            return this.swaps;
        }

        public int[] getPivot() {
            if (this.pivot != null) {
                return this.pivot;
            }
            this.getLU();
            return this.pivot;
        }

        public Real getDeterminant() {
            if (this.det != null) {
                return this.det;
            }
            RMatrix lu = this.getLU();
            if (!this.isSingular()) {
                this.det = Real.ONE;
                for (int i = 0; i < this.size; ++i) {
                    this.det = this.det.multiply(lu.get(i, i));
                }
                if ((this.getSwaps() & 1) != 0) {
                    this.det = this.det.negate();
                }
            } else {
                this.det = Real.ZERO;
            }
            return this.det;
        }

        public RMatrix getInverse() {
            int col;
            Real value;
            int row;
            int dcol;
            if (this.inv != null) {
                return this.inv;
            }
            RMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.inv = this.getP().copy();
            for (dcol = 0; dcol < this.size; ++dcol) {
                for (row = 0; row < this.size; ++row) {
                    value = this.inv.get(row, dcol);
                    for (col = 0; col < row; ++col) {
                        value = value.subtract(lu.get(row, col).multiply(this.inv.get(col, dcol)));
                    }
                    this.inv.set(row, dcol, value);
                }
            }
            for (dcol = 0; dcol < this.size; ++dcol) {
                for (row = this.size - 1; row >= 0; --row) {
                    value = this.inv.get(row, dcol);
                    for (col = this.size - 1; col > row; --col) {
                        value = value.subtract(lu.get(row, col).multiply(this.inv.get(col, dcol)));
                    }
                    this.inv.set(row, dcol, value.divide(lu.get(row, row)));
                }
            }
            return this.inv;
        }
    }

    public static class Q {
        private final QMatrix matrix;
        private final int size;
        private QMatrix P;
        private QMatrix L;
        private QMatrix U;
        private QMatrix LU;
        private boolean singular;
        private int swaps;
        private int[] pivot;
        private Rational det;
        private QMatrix inv;

        protected Q(QMatrix matrix) {
            if (!matrix.isSquare()) {
                throw new IllegalArgumentException("Matrix is not square");
            }
            this.matrix = matrix;
            this.size = this.matrix.getRowCount();
        }

        public Q refresh() {
            this.P = null;
            this.L = null;
            this.U = null;
            this.LU = null;
            this.singular = false;
            this.swaps = -1;
            this.pivot = null;
            this.det = null;
            this.inv = null;
            return this;
        }

        public QMatrix getMatrix() {
            return this.matrix;
        }

        public int getSize() {
            return this.size;
        }

        public QMatrix getP() {
            if (this.P != null) {
                return this.P;
            }
            int[] pivot = this.getPivot();
            if (pivot == null) {
                return null;
            }
            this.P = QMatrix.identity(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.P.swapRowsAndSet(i, pivot[i]);
            }
            return this.P;
        }

        public QMatrix getL() {
            if (this.L != null) {
                return this.L;
            }
            QMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.L = lu.map((row, column, oldValue) -> row > column ? oldValue : (row == column ? Rational.ONE : Rational.ZERO));
            return this.L;
        }

        public QMatrix getU() {
            if (this.U != null) {
                return this.U;
            }
            QMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.U = lu.map((row, col, oldValue) -> row <= col ? oldValue : Rational.ZERO);
            return this.U;
        }

        public boolean isSingular() {
            this.getLU();
            return this.singular;
        }

        public QMatrix getLU() {
            if (this.LU != null || this.singular) {
                return this.LU;
            }
            this.LU = this.matrix.copy();
            this.pivot = new int[this.size];
            this.swaps = 0;
            for (int i = 0; i < this.size; ++i) {
                int row;
                int pivot = -1;
                Rational largest = Rational.ZERO;
                for (row = i; row < this.size; ++row) {
                    Rational value = this.LU.get(row, i).abs();
                    if (value.signum() == 0 || value.compareTo(largest) <= 0) continue;
                    largest = value;
                    pivot = row;
                }
                if (pivot == -1) {
                    this.singular = true;
                    this.LU = null;
                    this.pivot = null;
                    this.swaps = -1;
                    return null;
                }
                this.pivot[i] = pivot;
                if (pivot != i) {
                    this.LU.swapRowsAndSet(i, pivot);
                    ++this.swaps;
                }
                for (row = i + 1; row < this.size; ++row) {
                    Rational divisor = this.LU.get(i, i);
                    this.LU.set(row, i, this.LU.get(row, i).divide(divisor));
                }
                for (row = i + 1; row < this.size; ++row) {
                    for (int column = i + 1; column < this.size; ++column) {
                        Rational subtrahend = this.LU.get(row, i).multiply(this.LU.get(i, column));
                        this.LU.set(row, column, this.LU.get(row, column).subtract(subtrahend));
                    }
                }
            }
            return this.LU;
        }

        public int getSwaps() {
            if (this.LU != null) {
                return this.swaps;
            }
            this.getLU();
            return this.swaps;
        }

        public int[] getPivot() {
            if (this.pivot != null) {
                return this.pivot;
            }
            this.getLU();
            return this.pivot;
        }

        public Rational getDeterminant() {
            if (this.det != null) {
                return this.det;
            }
            QMatrix lu = this.getLU();
            if (!this.isSingular()) {
                this.det = Rational.ONE;
                for (int i = 0; i < this.size; ++i) {
                    this.det = this.det.multiply(lu.get(i, i));
                }
                if ((this.getSwaps() & 1) != 0) {
                    this.det = this.det.negate();
                }
            } else {
                this.det = Rational.ZERO;
            }
            return this.det;
        }

        public QMatrix getInverse() {
            int col;
            Rational value;
            int row;
            int dcol;
            if (this.inv != null) {
                return this.inv;
            }
            QMatrix lu = this.getLU();
            if (lu == null) {
                return null;
            }
            this.inv = this.getP().copy();
            for (dcol = 0; dcol < this.size; ++dcol) {
                for (row = 0; row < this.size; ++row) {
                    value = this.inv.get(row, dcol);
                    for (col = 0; col < row; ++col) {
                        value = value.subtract(lu.get(row, col).multiply(this.inv.get(col, dcol)));
                    }
                    this.inv.set(row, dcol, value);
                }
            }
            for (dcol = 0; dcol < this.size; ++dcol) {
                for (row = this.size - 1; row >= 0; --row) {
                    value = this.inv.get(row, dcol);
                    for (col = this.size - 1; col > row; --col) {
                        value = value.subtract(lu.get(row, col).multiply(this.inv.get(col, dcol)));
                    }
                    this.inv.set(row, dcol, value.divide(lu.get(row, row)));
                }
            }
            return this.inv;
        }
    }
}

