/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag;

import com.invadermonky.justenoughmagiculture.integrations.jei.JEICategories;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagWrapper;
import com.invadermonky.justenoughmagiculture.util.Reference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.config.Settings;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class LootBagCategory
implements IRecipeCategory<LootBagWrapper> {
    protected static final int ITEMS_PER_ROW = 8;
    protected static final int ITEMS_PER_COLUMN = 4;
    protected static int SPACING_X = 20;
    protected static int SPACING_Y = 20;
    protected static int ITEMS_PER_PAGE = 32;

    public String getUid() {
        return "justenoughmagiculture.loot_bag";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.justenoughmagiculture:loot_bag.title", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Just Enough Magiculture";
    }

    public IDrawable getBackground() {
        return Reference.JEI.LOOT_BAG;
    }

    @Nullable
    public IDrawable getIcon() {
        return JEICategories.getJeiHelpers().getGuiHelper().createDrawable(Reference.JEI.TABS, 16, 0, 16, 16);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull LootBagWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int x = 6;
        int y = 44;
        recipeLayout.getItemStacks().init(0, true, 22, 10);
        for (int i = 0; i < Math.min(ITEMS_PER_PAGE, ingredients.getOutputs(VanillaTypes.ITEM).size()); ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, x, y);
            if ((x += SPACING_X) < 6 + SPACING_X * Settings.ITEMS_PER_ROW * 2) continue;
            x = 6;
            y += SPACING_Y;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        IFocus focus = recipeLayout.getFocus();
        int slots = Math.min(recipeWrapper.amountOfItems((IFocus<ItemStack>)focus), ITEMS_PER_PAGE);
        recipeLayout.getItemStacks().set(ingredients);
        for (int i = 0; i < slots; ++i) {
            recipeLayout.getItemStacks().set(i + 1, recipeWrapper.getItems((IFocus<ItemStack>)focus, i, slots));
        }
    }
}

