/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigChocolateQuest;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.boss.EntityCQRBoarmage;
import team.cqr.cqrepoured.entity.boss.EntityCQRGiantSpider;
import team.cqr.cqrepoured.entity.boss.EntityCQRLich;
import team.cqr.cqrepoured.entity.boss.EntityCQRNecromancer;
import team.cqr.cqrepoured.entity.boss.EntityCQRPirateCaptain;
import team.cqr.cqrepoured.entity.boss.EntityCQRWalkerKing;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderKing;
import team.cqr.cqrepoured.entity.boss.exterminator.EntityCQRExterminator;
import team.cqr.cqrepoured.entity.boss.gianttortoise.EntityCQRGiantTortoise;
import team.cqr.cqrepoured.entity.boss.netherdragon.EntityCQRNetherDragon;
import team.cqr.cqrepoured.entity.boss.spectrelord.EntityCQRSpectreLord;
import team.cqr.cqrepoured.entity.mobs.EntityCQRBoarman;
import team.cqr.cqrepoured.entity.mobs.EntityCQRDwarf;
import team.cqr.cqrepoured.entity.mobs.EntityCQREnderman;
import team.cqr.cqrepoured.entity.mobs.EntityCQRGoblin;
import team.cqr.cqrepoured.entity.mobs.EntityCQRGolem;
import team.cqr.cqrepoured.entity.mobs.EntityCQRGremlin;
import team.cqr.cqrepoured.entity.mobs.EntityCQRHuman;
import team.cqr.cqrepoured.entity.mobs.EntityCQRIllager;
import team.cqr.cqrepoured.entity.mobs.EntityCQRMandril;
import team.cqr.cqrepoured.entity.mobs.EntityCQRMinotaur;
import team.cqr.cqrepoured.entity.mobs.EntityCQRMummy;
import team.cqr.cqrepoured.entity.mobs.EntityCQRNPC;
import team.cqr.cqrepoured.entity.mobs.EntityCQROgre;
import team.cqr.cqrepoured.entity.mobs.EntityCQROrc;
import team.cqr.cqrepoured.entity.mobs.EntityCQRPirate;
import team.cqr.cqrepoured.entity.mobs.EntityCQRSkeleton;
import team.cqr.cqrepoured.entity.mobs.EntityCQRSpectre;
import team.cqr.cqrepoured.entity.mobs.EntityCQRTriton;
import team.cqr.cqrepoured.entity.mobs.EntityCQRWalker;
import team.cqr.cqrepoured.entity.mobs.EntityCQRZombie;
import team.cqr.cqrepoured.entity.mount.EntityGiantEndermite;
import team.cqr.cqrepoured.entity.mount.EntityGiantSilverfishGreen;
import team.cqr.cqrepoured.entity.mount.EntityGiantSilverfishNormal;
import team.cqr.cqrepoured.entity.mount.EntityGiantSilverfishRed;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;

public class JERChocolateQuest
extends JERBase
implements IJERIntegration {
    JEMConfigChocolateQuest.JER jerConfig;

    public JERChocolateQuest(boolean enableJERDungeons, boolean enableJERMobs) {
        this.jerConfig = JEMConfig.CHOCOLATE_QUEST.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModDungeons() {
        for (ResourceLocation chestLoot : CQRLoottables.getChestLootTables()) {
            try {
                String category = chestLoot.toString().replace("chests/", "");
                String unlocName = StringHelper.getDungeonTranslationKey(category.split(":")[0], category.split(":")[1]);
                this.registerDungeonLoot(category, unlocName, chestLoot);
            }
            catch (Exception e) {
                LogHelper.warn("Error generating JER dungeon strings for " + chestLoot.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registerModEntities() {
        this.registerBosses();
        this.registerMobs();
        this.registerMounts();
    }

    private void registerBosses() {
        if (this.jerConfig.CQR_BOSSES.enableBoarMage) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRBoarmage(this.world), LightLevel.any, CQRLoottables.ENTITIES_BOARMAGE);
        }
        if (this.jerConfig.CQR_BOSSES.enableDragonNether) {
            this.registerMob((EntityLivingBase)new EntityCQRNetherDragon(this.world), LightLevel.any, CQRLoottables.ENTITIES_DRAGON_NETHER);
        }
        if (this.jerConfig.CQR_BOSSES.enableEnderCalamity) {
            this.registerMob((EntityLivingBase)new EntityCQREnderCalamity(this.world), LightLevel.any, CQRLoottables.ENTITIES_ENDER_CALAMITY);
            this.registerRenderHook(EntityCQREnderCalamity.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.CQR_BOSSES.enableEndermanKing) {
            EntityCQREnderKing enderKing = new EntityCQREnderKing(this.world);
            enderKing.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.GREAT_SWORD_DIAMOND));
            enderKing.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, new ItemStack(CQRItems.POTION_HEALING, 3));
            enderKing.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.KING_CROWN, 1));
            this.registerCQRMob((EntityLivingBase)enderKing, LightLevel.any, CQRLoottables.ENTITIES_ENDERMAN);
        }
        if (this.jerConfig.CQR_BOSSES.enableExterminator) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRExterminator(this.world), LightLevel.any, CQRLoottables.ENTITIES_EXTERMINATOR);
        }
        if (this.jerConfig.CQR_BOSSES.enableGiantTurtle) {
            this.registerMob((EntityLivingBase)new EntityCQRGiantTortoise(this.world), LightLevel.any, CQRLoottables.ENTITIES_TURTLE);
            this.registerRenderHook(EntityCQRGiantTortoise.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.CQR_BOSSES.enableGoblinShaman) {
            EntityCQRGoblin goblin = new EntityCQRGoblin(this.world);
            goblin.func_96094_a(I18n.func_135052_a((String)"entity.cqrepoured:goblin_shaman.name", (Object[])new Object[0]));
            this.registerMob((EntityLivingBase)goblin, LightLevel.any, CQRLoottables.ENTITIES_GOBLIN_SHAMAN);
        }
        if (this.jerConfig.CQR_BOSSES.enableLich) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRLich(this.world), LightLevel.any, CQRLoottables.ENTITIES_LICH);
        }
        if (this.jerConfig.CQR_BOSSES.enableNecromancer) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRNecromancer(this.world), LightLevel.any, CQRLoottables.ENTITIES_NECROMANCER);
        }
        if (this.jerConfig.CQR_BOSSES.enablePirateCaptain) {
            EntityCQRPirateCaptain pirateCaptain = new EntityCQRPirateCaptain(this.world);
            pirateCaptain.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.CAPTAIN_REVOLVER, 1));
            this.registerCQRMob((EntityLivingBase)pirateCaptain, LightLevel.any, CQRLoottables.ENTITIES_PIRATE_CAPTAIN);
        }
        if (this.jerConfig.CQR_BOSSES.enableShelob) {
            this.registerMob((EntityLivingBase)new EntityCQRGiantSpider(this.world), LightLevel.any, CQRLoottables.ENTITIES_SPIDER);
            this.registerRenderHook(EntityCQRGiantSpider.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.CQR_BOSSES.enableSpectreLord) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRSpectreLord(this.world), LightLevel.any, CQRLoottables.ENTITIES_SPECTRE_LORD);
        }
        if (this.jerConfig.CQR_BOSSES.enableAbyssWalkerKing) {
            EntityCQRWalkerKing walkerKing = new EntityCQRWalkerKing(this.world);
            walkerKing.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.GREAT_SWORD_DIAMOND));
            walkerKing.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_WALKER_KING, 1));
            walkerKing.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.KING_CROWN, 1));
            this.registerCQRMob((EntityLivingBase)walkerKing, LightLevel.any, CQRLoottables.ENTITIES_WALKER_KING);
        }
    }

    private void registerMobs() {
        if (this.jerConfig.CQR_MOBS.enableBoarman) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRBoarman(this.world), LightLevel.any, CQRLoottables.ENTITIES_BOARMAN);
        }
        if (this.jerConfig.CQR_MOBS.enableDwarf) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRDwarf(this.world), LightLevel.any, CQRLoottables.ENTITIES_DWARF);
        }
        if (this.jerConfig.CQR_MOBS.enableEnderman) {
            this.registerCQRMob((EntityLivingBase)new EntityCQREnderman(this.world), LightLevel.any, CQRLoottables.ENTITIES_ENDERMAN);
        }
        if (this.jerConfig.CQR_MOBS.enableGoblin) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRGoblin(this.world), LightLevel.any, CQRLoottables.ENTITIES_GOBLIN);
        }
        if (this.jerConfig.CQR_MOBS.enableGolem) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRGolem(this.world), LightLevel.any, CQRLoottables.ENTITIES_GOLEM);
        }
        if (this.jerConfig.CQR_MOBS.enableGremlin) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRGremlin(this.world), LightLevel.any, CQRLoottables.ENTITIES_GREMLIN);
        }
        if (this.jerConfig.CQR_MOBS.enableHuman) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRHuman(this.world), LightLevel.any, CQRLoottables.ENTITIES_HUMAN);
        }
        if (this.jerConfig.CQR_MOBS.enableIllager) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRIllager(this.world), LightLevel.any, CQRLoottables.ENTITIES_ILLAGER);
        }
        if (this.jerConfig.CQR_MOBS.enableMandril) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRMandril(this.world), LightLevel.any, CQRLoottables.ENTITIES_MANDRIL);
        }
        if (this.jerConfig.CQR_MOBS.enableMinotaur) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRMinotaur(this.world), LightLevel.any, CQRLoottables.ENTITIES_MINOTAUR);
        }
        if (this.jerConfig.CQR_MOBS.enableMummy) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRMummy(this.world), LightLevel.any, CQRLoottables.ENTITIES_MUMMY);
        }
        if (this.jerConfig.CQR_MOBS.enableNPC) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRNPC(this.world), LightLevel.any, CQRLoottables.ENTITIES_NPC);
        }
        if (this.jerConfig.CQR_MOBS.enableOgre) {
            this.registerCQRMob((EntityLivingBase)new EntityCQROgre(this.world), LightLevel.any, CQRLoottables.ENTITIES_OGRE);
        }
        if (this.jerConfig.CQR_MOBS.enableOrc) {
            this.registerCQRMob((EntityLivingBase)new EntityCQROrc(this.world), LightLevel.any, CQRLoottables.ENTITIES_ORC);
        }
        if (this.jerConfig.CQR_MOBS.enablePirate) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRPirate(this.world), LightLevel.any, CQRLoottables.ENTITIES_PIRATE);
        }
        if (this.jerConfig.CQR_MOBS.enableSkeleton) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRSkeleton(this.world), LightLevel.any, CQRLoottables.ENTITIES_SKELETON);
        }
        if (this.jerConfig.CQR_MOBS.enableSpectre) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRSpectre(this.world), LightLevel.any, CQRLoottables.ENTITIES_SPECTRE);
        }
        if (this.jerConfig.CQR_MOBS.enableTriton) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRTriton(this.world), LightLevel.any, CQRLoottables.ENTITIES_TRITON);
        }
        if (this.jerConfig.CQR_MOBS.enableAbyssWalker) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRWalker(this.world), LightLevel.any, CQRLoottables.ENTITIES_WALKER);
        }
        if (this.jerConfig.CQR_MOBS.enableZombie) {
            this.registerCQRMob((EntityLivingBase)new EntityCQRZombie(this.world), LightLevel.any, CQRLoottables.ENTITIES_ZOMBIE);
        }
    }

    private void registerMounts() {
        if (this.jerConfig.CQR_MOUNTS.enableGiantEndermite) {
            this.registerMob((EntityLivingBase)new EntityGiantEndermite(this.world), LightLevel.any, CQRLoottables.ENTITIES_GIANT_ENDERMITE);
            this.registerRenderHook(EntityGiantEndermite.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.35, (double)1.35, (double)1.35);
                GlStateManager.func_179137_b((double)-0.05, (double)0.15, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.CQR_MOUNTS.enableGiantSilverfish) {
            this.registerMob((EntityLivingBase)new EntityGiantSilverfishNormal(this.world), LightLevel.any, CQRLoottables.ENTITIES_GIANT_SILVERFISH);
            this.adjustMountRenderHook(EntityGiantSilverfishNormal.class);
        }
        if (this.jerConfig.CQR_MOUNTS.enableGiantSilverfishGreen) {
            this.registerMob((EntityLivingBase)new EntityGiantSilverfishGreen(this.world), LightLevel.any, CQRLoottables.ENTITIES_GIANT_SILVERFISH_GREEN);
            this.adjustMountRenderHook(EntityGiantSilverfishGreen.class);
        }
        if (this.jerConfig.CQR_MOUNTS.enableGiantSilverfishRed) {
            this.registerMob((EntityLivingBase)new EntityGiantSilverfishRed(this.world), LightLevel.any, CQRLoottables.ENTITIES_GIANT_SILVERFISH_RED);
            this.adjustMountRenderHook(EntityGiantSilverfishRed.class);
        }
    }

    private void registerCQRMob(EntityLivingBase entity, LightLevel lightLevel, ResourceLocation lootTable) {
        this.registerMob(entity, lightLevel, lootTable);
        this.registerRenderHook(entity.getClass(), (renderInfo, entityLivingBase) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustMountRenderHook(Class<? extends EntityLivingBase> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
            GlStateManager.func_179137_b((double)-0.05, (double)0.4, (double)0.0);
            return renderInfo;
        });
    }
}

