/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.google.common.collect.Sets;
import com.invadermonky.justenoughmagiculture.client.render.entity.mods.erebus.JERRenderGlowWorm;
import com.invadermonky.justenoughmagiculture.client.render.entity.mods.erebus.JERRenderMagmaCrawler;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigErebus;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.plant.CustomPlantEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMConditional;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.blocks.EnumWood;
import erebus.entity.EntityAntlion;
import erebus.entity.EntityAntlionBoss;
import erebus.entity.EntityAntlionMiniBoss;
import erebus.entity.EntityBedBug;
import erebus.entity.EntityBeetle;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.EntityBlackAnt;
import erebus.entity.EntityBlackWidow;
import erebus.entity.EntityBogMaw;
import erebus.entity.EntityBombardierBeetle;
import erebus.entity.EntityBombardierBeetleLarva;
import erebus.entity.EntityBotFly;
import erebus.entity.EntityCentipede;
import erebus.entity.EntityChameleonTick;
import erebus.entity.EntityCicada;
import erebus.entity.EntityCropWeevil;
import erebus.entity.EntityCrushroom;
import erebus.entity.EntityDragonfly;
import erebus.entity.EntityFireAnt;
import erebus.entity.EntityFireAntSoldier;
import erebus.entity.EntityFly;
import erebus.entity.EntityFungalWeevil;
import erebus.entity.EntityGlowWorm;
import erebus.entity.EntityGrasshopper;
import erebus.entity.EntityHoneyPotAnt;
import erebus.entity.EntityJumpingSpider;
import erebus.entity.EntityLavaWebSpider;
import erebus.entity.EntityLocust;
import erebus.entity.EntityMagmaCrawler;
import erebus.entity.EntityMidgeSwarm;
import erebus.entity.EntityMoneySpider;
import erebus.entity.EntityMosquito;
import erebus.entity.EntityMoth;
import erebus.entity.EntityPondSkater;
import erebus.entity.EntityPrayingMantis;
import erebus.entity.EntityPunchroom;
import erebus.entity.EntityRhinoBeetle;
import erebus.entity.EntityScorpion;
import erebus.entity.EntityScytodes;
import erebus.entity.EntitySolifuge;
import erebus.entity.EntityStagBeetle;
import erebus.entity.EntityTarantula;
import erebus.entity.EntityTarantulaMiniboss;
import erebus.entity.EntityTitanBeetle;
import erebus.entity.EntityUmberGolemDungeonTypes;
import erebus.entity.EntityVelvetWorm;
import erebus.entity.EntityWasp;
import erebus.entity.EntityWoodlouse;
import erebus.entity.EntityWorkerBee;
import erebus.entity.EntityZombieAnt;
import erebus.entity.EntityZombieAntSoldier;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.biomes.decorators.BiomeDecoratorFungalForest;
import erebus.world.feature.plant.WorldGenRottenTreeStump;
import erebus.world.feature.structure.WorldGenAntlionDungeon;
import erebus.world.feature.structure.WorldGenAntlionLair;
import erebus.world.feature.structure.WorldGenDragonflyDungeon;
import erebus.world.feature.structure.WorldGenDungPile;
import erebus.world.feature.structure.WorldGenLocustShrine;
import erebus.world.feature.structure.WorldGenSpiderDungeons;
import erebus.world.feature.tree.WorldGenGiantEucalyptus;
import erebus.world.loot.WeightedLootList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class JERErebus
extends JERBase
implements IJERIntegration {
    private static JERErebus instance;
    private final JEMConfigErebus.JER jerConfig;
    private static THashMap<BiomeBaseErebus, THashSet<Class<? extends EntityLiving>>> mobSpawns;

    private JERErebus() {
        this.jerConfig = JEMConfig.EREBUS.JUST_ENOUGH_RESOURCES;
    }

    public JERErebus(boolean enableJERDungeons, boolean enableJERMobs, boolean enableJERPlants) {
        this.jerConfig = JEMConfig.EREBUS.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERPlants) {
            this.registerModPlants();
        }
        JERErebus.getInstance();
    }

    public static JERErebus getInstance() {
        return instance != null ? instance : (instance = new JERErebus());
    }

    @Override
    public void registerModDungeons() {
        this.registerErebusDungeon("antlion_dungeon", WorldGenAntlionDungeon.chestLoot, 3, 10);
        this.registerErebusDungeon("antlion_lair", WorldGenAntlionLair.chestLoot, 10, 14);
        this.registerErebusDungeon("dragonfly_dungeon", WorldGenDragonflyDungeon.CHEST_LOOT, 5, 15);
        this.registerErebusDungeon("dung_pile", WorldGenDungPile.CHEST_LOOT, 8, 14);
        this.registerErebusDungeon("giant_eucalyptus", WorldGenGiantEucalyptus.chestLoot, 3, 10);
        this.registerErebusDungeon("locust_shrine", WorldGenLocustShrine.CHEST_LOOT, 2, 3);
        this.registerErebusDungeon("rotten_tree_stump", WorldGenRottenTreeStump.chestLoot, 3, 10);
        this.registerErebusDungeon("spider_dungeon", WorldGenSpiderDungeons.chestLoot, 3, 10);
    }

    @Override
    public void registerModEntities() {
        LootDrop foodDrop;
        ArrayList<LootDrop> larvaDrops;
        Object drops;
        this.populateMobSpawns();
        String[] allBiomes = BiomeHelper.getBiomeNamesForBiomes(mobSpawns.keySet().toArray(new Biome[0]));
        LootDrop exoPlateDrop = new LootDrop(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting});
        if (this.jerConfig.JER_MOBS.enableAntlion) {
            this.registerMob((EntityLivingBase)new EntityAntlion(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityAntlion.class), exoPlateDrop);
        }
        if (this.jerConfig.JER_MOBS.enableAntlionGuardian) {
            this.registerMob((EntityLivingBase)new EntityAntlionMiniBoss(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), exoPlateDrop);
            this.registerRenderHook(EntityAntlionMiniBoss.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableAntlionOverlord) {
            drops = new LootDrop[]{new LootDrop(new ItemStack(ModBlocks.ANTLION_EGG)), new LootDrop(ItemMaterials.EnumErebusMaterialsType.SOUL_CRYSTAL.createStack()), new LootDrop(new ItemStack((Item)ModItems.WAR_HAMMER))};
            this.registerMob((EntityLivingBase)new EntityAntlionBoss(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), (LootDrop[])drops);
            this.registerRenderHook(EntityAntlionBoss.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableBedBug) {
            this.registerMob((EntityLivingBase)new EntityBedBug(this.world), LightLevel.hostile, allBiomes, new LootDrop(new ItemStack(Blocks.field_150325_L, 1, 0)));
            this.registerRenderHook(EntityBedBug.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableBeetle) {
            this.registerMob((EntityLivingBase)new EntityBeetle(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBeetle.class), exoPlateDrop);
            this.adjustBugRenderHookUp(EntityBeetle.class);
        }
        if (this.jerConfig.JER_MOBS.enableBeetleLarva) {
            larvaDrops = new ArrayList<LootDrop>();
            foodDrop = new LootDrop(new ItemStack(ModItems.EREBUS_FOOD, 1, 0), 1, 1, new Conditional[]{JEMConditional.isNotSquashed});
            foodDrop.smeltedItem = new ItemStack(ModItems.EREBUS_FOOD, 1, 1);
            larvaDrops.add(foodDrop);
            larvaDrops.add(new LootDrop(Items.field_151123_aH, 1, 1, 0.995f, new Conditional[]{JEMConditional.isSquashed}));
            larvaDrops.add(new LootDrop(Items.field_151045_i, 0, 1, 0.005f, new Conditional[]{JEMConditional.isSquashed, Conditional.rareDrop}));
            this.registerMob((EntityLivingBase)new EntityBeetleLarva(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBeetleLarva.class), larvaDrops);
            this.adjustBugRenderHookUp(EntityBeetleLarva.class);
        }
        if (this.jerConfig.JER_MOBS.enableBlackWidow) {
            drops = new LootDrop[]{new LootDrop(Items.field_151007_F, 0, 1, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151070_bp, 0, 1, 0.33333334f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.POISON_GLAND.createStack())};
            this.registerMob((EntityLivingBase)new EntityBlackWidow(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBlackWidow.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableBogMaw) {
            this.registerMob((EntityLivingBase)new EntityBogMaw(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBogMaw.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.BOGMAW_ROOT.createStack(), 0, 2, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableBombardierBeetle) {
            drops = new LootDrop[]{new LootDrop(Items.field_151016_H, 1, 1, new Conditional[0]), new LootDrop(Items.field_151065_br, 1, 1, new Conditional[0]), exoPlateDrop};
            this.registerMob((EntityLivingBase)new EntityBombardierBeetle(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBombardierBeetle.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableBombardierBeetleLarva) {
            larvaDrops = new ArrayList();
            foodDrop = new LootDrop(new ItemStack(ModItems.EREBUS_FOOD, 1, 0), 1, 1, new Conditional[]{JEMConditional.isNotSquashed});
            foodDrop.smeltedItem = new ItemStack(ModItems.EREBUS_FOOD, 1, 1);
            larvaDrops.add(foodDrop);
            larvaDrops.add(new LootDrop(Items.field_151123_aH, 1, 1, 0.995f, new Conditional[]{JEMConditional.isSquashed}));
            larvaDrops.add(new LootDrop(Items.field_151045_i, 0, 1, 0.005f, new Conditional[]{JEMConditional.isSquashed}));
            this.registerMob((EntityLivingBase)new EntityBombardierBeetleLarva(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBombardierBeetleLarva.class), larvaDrops);
        }
        if (this.jerConfig.JER_MOBS.enableBotFly) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.FLY_WING.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.COMPOUND_EYES.createStack(), 0, 3, 0.25f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityBotFly(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityBotFly.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableCentipede) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.BIO_VELOCITY.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.POISON_GLAND.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.SUPERNATURAL_VELOCITY.createStack(), 0, 1, 0.02f, new Conditional[]{Conditional.rareDrop})};
            this.registerMob((EntityLivingBase)new EntityCentipede(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityCentipede.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableChameleonTick) {
            this.registerMob((EntityLivingBase)new EntityChameleonTick(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityChameleonTick.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.CAMO_POWDER.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableCicada) {
            this.registerMob((EntityLivingBase)new EntityCicada(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityCicada.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.REPELLENT.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableCropWeevil) {
            drops = new LootDrop[]{new LootDrop(new ItemStack(ModBlocks.GIANT_FLOWER_STIGMA), 1, 3, 0.2f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151080_bb), 1, 3, 0.2f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151081_bc), 1, 3, 0.2f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151100_aR, 1, 3), 1, 3, 0.2f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(ModItems.TURNIP), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151075_bm), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151015_O), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151120_aE), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(EnumWood.BAMBOO.getSapling()), 1, 1, 0.01425f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151172_bF), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(Items.field_151174_bG), 1, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityCropWeevil(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityCropWeevil.class), (LootDrop[])drops);
            this.registerRenderHook(EntityCropWeevil.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableCrushroom) {
            this.registerMob((EntityLivingBase)new EntityCrushroom(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityCrushroom.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.HIDE_SHROOM.createStack(), 0, 2, new Conditional[]{Conditional.affectedByLooting}));
            this.registerRenderHook(EntityCrushroom.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableDragonfly) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.DRAGONFLY_WING.createStack()), new LootDrop(ItemMaterials.EnumErebusMaterialsType.COMPOUND_EYES.createStack(), 0, 1, 0.2f, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151079_bi, 0, 1, 0.15f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityDragonfly(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityDragonfly.class), (LootDrop[])drops);
            this.registerRenderHook(EntityDragonfly.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableFireAnt) {
            drops = new LootDrop[]{new LootDrop(Items.field_151064_bs, 1, 1, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151059_bz, 0, 1, 0.2f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityFireAnt(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityFireAnt.class), (LootDrop[])drops);
            this.registerRenderHook(EntityFireAnt.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableFireAntSoldier) {
            drops = new LootDrop[]{new LootDrop(Items.field_151065_br, 1, 1, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151072_bj, 0, 1, 0.2f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityFireAntSoldier(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityFireAntSoldier.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableFly) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.FLY_WING.createStack(), 0, 1, 0.1f, new Conditional[0]), new LootDrop(ItemMaterials.EnumErebusMaterialsType.COMPOUND_EYES.createStack(), 0, 1, 0.05f, new Conditional[]{Conditional.rareDrop})};
            this.registerMob((EntityLivingBase)new EntityFly(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityFly.class), (LootDrop[])drops);
            this.registerRenderHook(EntityFly.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableFungalWeevil) {
            drops = new ArrayList();
            drops.add(new LootDrop(new ItemStack((Block)Blocks.field_150338_P), 0.1667f));
            drops.add(new LootDrop(new ItemStack((Block)Blocks.field_150337_Q), 0.1667f));
            float chance = 0.6666667f / (float)BiomeDecoratorFungalForest.MUSHROOMS.length;
            for (Block block : BiomeDecoratorFungalForest.MUSHROOMS) {
                drops.add(new LootDrop(new ItemStack(block), chance));
            }
            this.registerMob((EntityLivingBase)new EntityFungalWeevil(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityFungalWeevil.class), (List<LootDrop>)drops);
            this.registerRenderHook(EntitySolifuge.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableGlowWorm) {
            this.registerMob((EntityLivingBase)new EntityGlowWorm(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityGlowWorm.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.BIO_LUMINESCENCE.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableGrasshopper) {
            LootDrop foodDrop2 = new LootDrop(ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_RAW.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting});
            foodDrop2.smeltedItem = ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_COOKED.createStack();
            this.registerMob((EntityLivingBase)new EntityGrasshopper(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityGrasshopper.class), foodDrop2);
        }
        if (this.jerConfig.JER_MOBS.enableHoneyPotAnt) {
            this.registerMob((EntityLivingBase)new EntityHoneyPotAnt(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityHoneyPotAnt.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(), 1, 8, 1.0f, new Conditional[0]));
            this.adjustBugRenderHookUp(EntityHoneyPotAnt.class);
            this.registerRenderHook(EntityHoneyPotAnt.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableJumpingSpider) {
            this.registerMob((EntityLivingBase)new EntityJumpingSpider(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityJumpingSpider.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.POISON_GLAND.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableLavaWebSpider) {
            drops = new LootDrop[]{new LootDrop(Items.field_151059_bz, 1, 1, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151070_bp, 0, 2, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityLavaWebSpider(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityLavaWebSpider.class), (LootDrop[])drops);
            this.registerRenderHook(EntityLavaWebSpider.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableLocust) {
            this.registerMob((EntityLivingBase)new EntityLocust(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.SUBTERRANEAN_SAVANNAH}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.ELASTIC_FIBRE.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableMagmaCrawler) {
            this.registerMob((EntityLivingBase)new EntityMagmaCrawler(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityMagmaCrawler.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.MAGMA_CRAWLER_EYE.createStack()));
        }
        if (this.jerConfig.JER_MOBS.enableMidgeSwarm) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.FLY_WING.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.COMPOUND_EYES.createStack(), 0, 3, 0.2f, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityMidgeSwarm(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityMidgeSwarm.class), (LootDrop[])drops);
        }
        if (this.jerConfig.JER_MOBS.enableMoneySpider) {
            String[] stringArray;
            ArrayList<String> spawnBiomes = new ArrayList<String>();
            spawnBiomes.addAll(Arrays.asList(this.getSpawnBiomes(EntityLavaWebSpider.class)));
            spawnBiomes.addAll(Arrays.asList(this.getSpawnBiomes(EntityTarantula.class)));
            EntityMoneySpider entityMoneySpider = new EntityMoneySpider(this.world);
            if (spawnBiomes.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "jer.any";
            } else {
                stringArray = spawnBiomes.toArray(new String[0]);
            }
            this.registerMob((EntityLivingBase)entityMoneySpider, LightLevel.hostile, stringArray, new LootDrop(Items.field_151043_k, 0, 1, 0.1f, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableMosquito) {
            this.registerMob((EntityLivingBase)new EntityMosquito(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityMosquito.class), new LootDrop(ModItems.LIFE_BLOOD, 1, 5, new Conditional[0]));
            this.registerRenderHook(EntityMosquito.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableMoth) {
            this.registerMob((EntityLivingBase)new EntityMoth(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityMoth.class), new LootDrop(Items.field_151114_aO, 0.2f, new LootFunction[0]));
        }
        if (this.jerConfig.JER_MOBS.enablePondSkater) {
            this.registerMob((EntityLivingBase)new EntityPondSkater(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityPondSkater.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.HYDROFUGE.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enablePrayingMantis) {
            EntityPrayingMantis mantis = new EntityPrayingMantis(this.world);
            mantis.setAlpha(1.0f);
            this.registerMob((EntityLivingBase)mantis, LightLevel.hostile, this.getSpawnBiomes(EntityPrayingMantis.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.CAMO_POWDER.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
            this.adjustBugRenderHookDown(EntityPrayingMantis.class);
        }
        if (this.jerConfig.JER_MOBS.enablePunchroom) {
            this.registerMob((EntityLivingBase)new EntityPunchroom(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityPunchroom.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.ELASTIC_FIBRE.createStack(), 1, 1, 0.2f, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableRhinoBeetle) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO_RHINO.createStack(), 1, 2, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.RHINO_BEETLE_HORN.createStack(), 0, 1, 0.05f, new Conditional[]{Conditional.rareDrop})};
            this.registerMob((EntityLivingBase)new EntityRhinoBeetle(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityRhinoBeetle.class), (LootDrop[])drops);
            this.registerRenderHook(EntityRhinoBeetle.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableScorpion) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.POISON_GLAND.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.SCORPION_PINCER.createStack(), 0, 3, 0.0333f, new Conditional[]{Conditional.affectedByLooting, Conditional.rareDrop})};
            this.registerMob((EntityLivingBase)new EntityScorpion(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityScorpion.class), (LootDrop[])drops);
            this.adjustBugRenderHookDown(EntityScorpion.class);
        }
        if (this.jerConfig.JER_MOBS.enableScytodes) {
            drops = new LootDrop[]{new LootDrop(Items.field_151007_F, 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(Items.field_151070_bp, 0, 2, new Conditional[]{Conditional.affectedByLooting})};
            this.registerMob((EntityLivingBase)new EntityScytodes(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityScytodes.class), (LootDrop[])drops);
            this.registerRenderHook(EntityScytodes.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableSolifuge) {
            drops = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.BIO_VELOCITY.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.SUPERNATURAL_VELOCITY.createStack(), 0, 1, 0.02f, new Conditional[]{Conditional.rareDrop})};
            this.registerMob((EntityLivingBase)new EntitySolifuge(this.world), LightLevel.hostile, this.getSpawnBiomes(EntitySolifuge.class), (LootDrop[])drops);
            this.registerRenderHook(EntitySolifuge.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableStagBeetle) {
            drops = new ArrayList();
            drops.add(exoPlateDrop);
            LootDrop foodDrop3 = new LootDrop(ModItems.STAG_HEART_RAW, 0.1333f, new LootFunction[0]);
            foodDrop3.smeltedItem = new ItemStack(ModItems.STAG_HEART_COOKED);
            drops.add(foodDrop3);
            drops.add(new LootDrop(ItemMaterials.EnumErebusMaterialsType.STAG_BEETLE_MANDIBLES.createStack(), 0, 1, 0.0333f, new Conditional[]{Conditional.rareDrop}));
            this.registerMob((EntityLivingBase)new EntityStagBeetle(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityStagBeetle.class), (List<LootDrop>)drops);
            this.registerRenderHook(EntityStagBeetle.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableTarantula) {
            drops = new ArrayList();
            LootDrop foodDrop4 = new LootDrop(ItemErebusFood.EnumFoodType.TARANTULA_LEG_RAW.createStack(), 1, 1, new Conditional[]{Conditional.affectedByLooting});
            foodDrop4.smeltedItem = ItemErebusFood.EnumFoodType.TARANTULA_LEG_COOKED.createStack();
            drops.add(foodDrop4);
            drops.add(new LootDrop(Items.field_151070_bp, 0, 1, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)new EntityTarantula(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityTarantula.class), (List<LootDrop>)drops);
        }
        if (this.jerConfig.JER_MOBS.enableTarantulaBroodMother) {
            this.registerMob((EntityLivingBase)new EntityTarantulaMiniboss(this.world), LightLevel.hostile, allBiomes, new LootDrop(new ItemStack(ModItems.SPIDER_T_SHIRT)));
            this.registerRenderHook(EntityTarantulaMiniboss.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableTitanBeetle) {
            drops = new ArrayList();
            drops.add(exoPlateDrop);
            LootDrop foodDrop5 = new LootDrop(ItemErebusFood.EnumFoodType.TITAN_CHOP_RAW.createStack());
            foodDrop5.smeltedItem = ItemErebusFood.EnumFoodType.TITAN_CHOP_COOKED.createStack();
            drops.add(foodDrop5);
            this.registerMob((EntityLivingBase)new EntityTitanBeetle(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityTitanBeetle.class), (List<LootDrop>)drops);
            this.registerRenderHook(EntityTitanBeetle.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.4, (double)1.4, (double)1.4);
                GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
                return renderInfo;
            });
        }
        boolean isUmberGolemRegistered = false;
        if (this.jerConfig.JER_MOBS.enableUmberGolemMud) {
            EntityUmberGolemDungeonTypes umberGolem = new EntityUmberGolemDungeonTypes(this.world);
            umberGolem.setType((byte)0);
            this.registerMob((EntityLivingBase)umberGolem, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), new LootDrop(new ItemStack(ModItems.IDOLS, 1, (int)umberGolem.getType())));
            isUmberGolemRegistered = true;
        }
        if (this.jerConfig.JER_MOBS.enableUmberGolemIron) {
            EntityUmberGolemDungeonTypes umberGolem = new EntityUmberGolemDungeonTypes(this.world);
            umberGolem.setType((byte)1);
            this.registerMob((EntityLivingBase)umberGolem, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), new LootDrop(new ItemStack(ModItems.IDOLS, 1, (int)umberGolem.getType())));
            isUmberGolemRegistered = true;
        }
        if (this.jerConfig.JER_MOBS.enableUmberGolemGold) {
            EntityUmberGolemDungeonTypes umberGolem = new EntityUmberGolemDungeonTypes(this.world);
            umberGolem.setType((byte)2);
            this.registerMob((EntityLivingBase)umberGolem, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), new LootDrop(new ItemStack(ModItems.IDOLS, 1, (int)umberGolem.getType())));
            isUmberGolemRegistered = true;
        }
        if (this.jerConfig.JER_MOBS.enableUmberGolemJade) {
            EntityUmberGolemDungeonTypes umberGolem = new EntityUmberGolemDungeonTypes(this.world);
            umberGolem.setType((byte)3);
            this.registerMob((EntityLivingBase)umberGolem, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{ModBiomes.VOLCANIC_DESERT}), new LootDrop(new ItemStack(ModItems.IDOLS, 1, (int)umberGolem.getType())));
            isUmberGolemRegistered = true;
        }
        if (isUmberGolemRegistered) {
            this.registerRenderHook(EntityUmberGolemDungeonTypes.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.025, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableVelvetWorm) {
            this.registerMob((EntityLivingBase)new EntityVelvetWorm(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityVelvetWorm.class), new LootDrop(Items.field_151123_aH, 1, 2, new Conditional[]{Conditional.affectedByLooting}));
            this.registerRenderHook(EntityVelvetWorm.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableWasp) {
            this.registerMob((EntityLivingBase)new EntityWasp(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityWasp.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.WASP_STING.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (this.jerConfig.JER_MOBS.enableWaspBoss) {
            EntityWasp waspBoss = new EntityWasp(this.world);
            waspBoss.setIsBoss((byte)1);
            LootDrop[] drops2 = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.WASP_STING.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(new ItemStack(ModItems.ANTI_VENOM_BOTTLE))};
            this.registerMob((EntityLivingBase)waspBoss, LightLevel.hostile, this.getSpawnBiomes(EntityWasp.class), drops2);
        }
        if (this.jerConfig.JER_MOBS.enableWoodlouse) {
            this.registerMob((EntityLivingBase)new EntityWoodlouse(this.world), LightLevel.hostile, allBiomes, new LootDrop(ItemMaterials.EnumErebusMaterialsType.WHETSTONE_POWDER.createStack(), 0, 3, new Conditional[]{Conditional.affectedByLooting}));
            this.registerRenderHook(EntityWoodlouse.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableWorkerBee) {
            this.registerMob((EntityLivingBase)new EntityWorkerBee(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityWorkerBee.class), new LootDrop(ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(2)));
            this.adjustBugRenderHookUp(EntityWorkerBee.class);
        }
        if (this.jerConfig.JER_MOBS.enableZombieAnt) {
            LootDrop[] drops3 = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.PLATE_ZOMBIE_ANT.createStack(), 0, 2, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.ANT_PHEROMONES.createStack(), 0.2f)};
            this.registerMob((EntityLivingBase)new EntityZombieAnt(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityZombieAnt.class), drops3);
        }
        if (this.jerConfig.JER_MOBS.enableZombieAntSoldier) {
            LootDrop[] drops4 = new LootDrop[]{new LootDrop(ItemMaterials.EnumErebusMaterialsType.PLATE_ZOMBIE_ANT.createStack(), 0, 2, new Conditional[]{Conditional.affectedByLooting}), new LootDrop(ItemMaterials.EnumErebusMaterialsType.ANT_PHEROMONES.createStack(), 0.1f), new LootDrop(ItemMaterials.EnumErebusMaterialsType.TERPSISHROOM.createStack(), 0.1f)};
            this.registerMob((EntityLivingBase)new EntityZombieAntSoldier(this.world), LightLevel.hostile, this.getSpawnBiomes(EntityZombieAntSoldier.class), drops4);
        }
    }

    @Override
    public void registerModPlants() {
        if (this.jerConfig.JER_PLANTS.enableCabbage) {
            this.registerPlant((Item)((IPlantable)ModItems.CABBAGE_SEEDS), new PlantDrop(new ItemStack(ModItems.CABBAGE_SEEDS), 0, 2), new PlantDrop(ItemErebusFood.EnumFoodType.CABBAGE.createStack(), 1, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableDarkFruit) {
            CustomPlantEntry darkFruit = new CustomPlantEntry(ItemMaterials.EnumErebusMaterialsType.DARK_FRUIT_SEEDS.createStack(), ModBlocks.DARK_FRUIT_VINE.func_176223_P(), new PlantDrop(ItemMaterials.EnumErebusMaterialsType.DARK_FRUIT_SEEDS.createStack(), 0, 1), new PlantDrop(ItemErebusFood.EnumFoodType.DARK_FRUIT.createStack(), 0, 1));
            darkFruit.setSoil(Blocks.field_150350_a.func_176223_P());
            this.registerCustomPlant(darkFruit);
        }
        if (this.jerConfig.JER_PLANTS.enableHeartBerry) {
            CustomPlantEntry heartBerry = new CustomPlantEntry(new ItemStack(ModBlocks.HEART_BERRY_BUSH), ModBlocks.HEART_BERRY_BUSH.func_176223_P(), new PlantDrop(new ItemStack(ModItems.HEART_BERRIES), 1, 1));
            heartBerry.setSoil(Blocks.field_150346_d.func_176223_P());
            this.registerCustomPlant(heartBerry);
        }
        if (this.jerConfig.JER_PLANTS.enableJadeBerry) {
            CustomPlantEntry jadeBerry = new CustomPlantEntry(new ItemStack(ModBlocks.JADE_BERRY_BUSH), ModBlocks.JADE_BERRY_BUSH.func_176223_P(), new PlantDrop(ItemMaterials.EnumErebusMaterialsType.JADE_BERRIES.createStack(), 1, 1));
            jadeBerry.setSoil(Blocks.field_150346_d.func_176223_P());
            this.registerCustomPlant(jadeBerry);
        }
        if (this.jerConfig.JER_PLANTS.enableMandrake) {
            this.registerPlant((Item)((IPlantable)ModItems.MANDRAKE_ROOT), new PlantDrop(new ItemStack(ModItems.MANDRAKE_ROOT), 1, 3));
        }
        if (this.jerConfig.JER_PLANTS.enableSwampBerry) {
            CustomPlantEntry swampBerry = new CustomPlantEntry(new ItemStack(ModBlocks.SWAMP_BERRY_BUSH), ModBlocks.SWAMP_BERRY_BUSH.func_176223_P(), new PlantDrop(ItemErebusFood.EnumFoodType.SWAMP_BERRIES.createStack(), 1, 1));
            swampBerry.setSoil(Blocks.field_150346_d.func_176223_P());
            this.registerCustomPlant(swampBerry);
        }
        if (this.jerConfig.JER_PLANTS.enableTurnip) {
            this.registerPlant((Item)((IPlantable)ModItems.TURNIP), new PlantDrop(new ItemStack(ModItems.TURNIP), 1, 3));
        }
    }

    public void registerRenderOverrides() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGlowWorm.class, JERRenderGlowWorm::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMagmaCrawler.class, JERRenderMagmaCrawler::new);
    }

    private void adjustBugRenderHookUp(Class<? extends EntityLivingBase> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)0.4, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustBugRenderHookDown(Class<? extends EntityLivingBase> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)-0.4, (double)0.0);
            return renderInfo;
        });
    }

    private String[] getSpawnBiomes(Class<? extends EntityLiving> entityClass) {
        String[] stringArray;
        THashSet spawnBiomes = new THashSet();
        mobSpawns.forEach((biome, mobList) -> {
            if (mobList.contains((Object)entityClass)) {
                spawnBiomes.add(biome);
            }
        });
        if (!spawnBiomes.isEmpty()) {
            stringArray = BiomeHelper.getBiomeNamesForBiomes((Biome[])spawnBiomes.toArray((Object[])new Biome[0]));
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Check Spawns";
        }
        return stringArray;
    }

    private void registerErebusDungeon(String name, WeightedLootList lootList, int minRolls, int maxRolls) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name, lootList, minRolls, maxRolls);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private void populateMobSpawns() {
        mobSpawns = new THashMap();
        mobSpawns.put((Object)ModBiomes.ELYSIAN_FIELDS, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityWorkerBee.class, EntityFly.class, EntityDragonfly.class, EntityBeetle.class, EntityBeetleLarva.class, EntityBotFly.class, EntityGrasshopper.class, EntityMoth.class, EntityCropWeevil.class, EntityChameleonTick.class, EntityVelvetWorm.class, EntityCicada.class, EntityGlowWorm.class, EntityTitanBeetle.class})));
        mobSpawns.put((Object)ModBiomes.FUNGAL_FOREST, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityFungalWeevil.class, EntityCrushroom.class, EntityBlackAnt.class, EntityPunchroom.class, EntityStagBeetle.class, EntityZombieAnt.class, EntityZombieAntSoldier.class})));
        mobSpawns.put((Object)ModBiomes.PETRIFIED_FOREST, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityFly.class, EntityBotFly.class, EntityChameleonTick.class, EntityBlackWidow.class, EntityGlowWorm.class, EntityMoth.class, EntityScytodes.class, EntityJumpingSpider.class})));
        mobSpawns.put((Object)ModBiomes.SUBMERGED_SWAMP, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityDragonfly.class, EntityCentipede.class, EntityBeetleLarva.class, EntityBeetle.class, EntityJumpingSpider.class, EntityPondSkater.class, EntityBogMaw.class, EntityMosquito.class})));
        mobSpawns.put((Object)ModBiomes.SUBTERRANEAN_SAVANNAH, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityMosquito.class, EntityFly.class, EntityWasp.class, EntityBeetleLarva.class, EntityBeetle.class, EntityGrasshopper.class, EntityChameleonTick.class, EntityScytodes.class, EntityTarantula.class, EntityScorpion.class, EntityGlowWorm.class})));
        mobSpawns.put((Object)ModBiomes.ULTERIOR_OUTBACK, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityRhinoBeetle.class, EntityFly.class, EntityCentipede.class, EntityBlackWidow.class, EntityBotFly.class, EntityBeetleLarva.class, EntityHoneyPotAnt.class, EntityMidgeSwarm.class, EntityScytodes.class, EntitySolifuge.class, EntityTarantula.class, EntityChameleonTick.class, EntityScorpion.class})));
        mobSpawns.put((Object)ModBiomes.UNDERGROUND_JUNGLE, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityMosquito.class, EntityFly.class, EntityWasp.class, EntityCentipede.class, EntityBotFly.class, EntityBeetleLarva.class, EntityBeetle.class, EntityBombardierBeetle.class, EntityBombardierBeetleLarva.class, EntityJumpingSpider.class, EntityPrayingMantis.class, EntityScytodes.class, EntityTarantula.class, EntityChameleonTick.class, EntityVelvetWorm.class})));
        mobSpawns.put((Object)ModBiomes.VOLCANIC_DESERT, (Object)new THashSet((Collection)Sets.newHashSet((Object[])new Class[]{EntityFly.class, EntityBotFly.class, EntityFireAnt.class, EntityFireAntSoldier.class, EntityBlackWidow.class, EntityAntlion.class, EntitySolifuge.class, EntityChameleonTick.class, EntityScorpion.class, EntityLavaWebSpider.class})));
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final LootTable lootTable;

        public JERDungeonStrings(String name, WeightedLootList lootList, int minRolls, int maxRolls) {
            this.category = String.format("%s:%s", ModIds.EREBUS.MOD_ID, name);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.EREBUS.MOD_ID, name);
            this.lootTable = this.getLootTable(lootList, minRolls, maxRolls);
        }

        private LootTable getLootTable(WeightedLootList lootList, int minRolls, int maxRolls) {
            ArrayList lootEntries = new ArrayList();
            lootList.forEach(lootItemStack -> {
                try {
                    Item item = (Item)this.getFieldValue(lootItemStack, "item");
                    if (item != null) {
                        ArrayList<Object> lootFunctions = new ArrayList<Object>();
                        String name = item.getRegistryName().toString();
                        short minDamage = (Short)this.getFieldValue(lootItemStack, "minDamage");
                        short maxDamage = (Short)this.getFieldValue(lootItemStack, "maxDamage");
                        byte minAmount = (Byte)this.getFieldValue(lootItemStack, "minAmount");
                        byte maxAmount = (Byte)this.getFieldValue(lootItemStack, "maxAmount");
                        short weight = (Short)this.getFieldValue(lootItemStack, "weight");
                        lootFunctions.add(new SetCount(new LootCondition[0], new RandomValueRange((float)minAmount, (float)maxAmount)));
                        if (minDamage > 0 && maxDamage > 0) {
                            lootFunctions.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)minDamage, (float)maxDamage)));
                        }
                        lootEntries.add(new LootEntryItem(item, (int)weight, 0, lootFunctions.toArray(new LootFunction[0]), new LootCondition[0], name));
                    }
                }
                catch (Exception e) {
                    LogHelper.warn("Failed to get loot item for " + this.category);
                }
            });
            return new LootTable(new LootPool[]{new LootPool(lootEntries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange((float)minRolls, (float)maxRolls), new RandomValueRange(0.0f, 0.0f), this.category)});
        }

        private Object getFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
    }
}

