/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigNetherEx;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.BasicTrade;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ItemHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.LightLevel;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import logictechcorp.netherex.entity.boss.EntityGhastQueen;
import logictechcorp.netherex.entity.monster.EntityBrute;
import logictechcorp.netherex.entity.monster.EntityCoolmarSpider;
import logictechcorp.netherex.entity.monster.EntityEmber;
import logictechcorp.netherex.entity.monster.EntityFrost;
import logictechcorp.netherex.entity.monster.EntityGhastling;
import logictechcorp.netherex.entity.monster.EntityNethermite;
import logictechcorp.netherex.entity.monster.EntitySpinout;
import logictechcorp.netherex.entity.monster.EntitySpore;
import logictechcorp.netherex.entity.monster.EntitySporeCreeper;
import logictechcorp.netherex.entity.monster.EntityWight;
import logictechcorp.netherex.entity.neutral.EntityGoldGolem;
import logictechcorp.netherex.entity.neutral.EntityMogus;
import logictechcorp.netherex.entity.neutral.EntitySalamander;
import logictechcorp.netherex.entity.passive.EntityPigtificate;
import logictechcorp.netherex.entity.passive.EntityPigtificateLeader;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.init.NetherExItems;
import logictechcorp.netherex.init.NetherExLootTables;
import logictechcorp.netherex.init.NetherExPigtificates;
import logictechcorp.netherex.init.NetherExRegistries;
import logictechcorp.netherex.village.PigtificateProfession;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class JERNetherEx
extends JERBase
implements IJERIntegration {
    private final JEMConfigNetherEx.JER jerConfig;

    public JERNetherEx(boolean enableJERDungeons, boolean enableJERMobs, boolean enableJERVillagers) {
        this.jerConfig = JEMConfig.NETHEREX.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
    }

    @Override
    public void registerModDungeons() {
        this.registerDungeonLoot(ModIds.NETHEREX.MOD_ID + ":chest/ghast_queen_shrine", StringHelper.getDungeonTranslationKey(ModIds.NETHEREX.MOD_ID, "ghast_queen_shrine"), new ResourceLocation(ModIds.NETHEREX.MOD_ID, "chest/temple_rare"));
        this.registerDungeonLoot(ModIds.NETHEREX.MOD_ID + ":chest/base_village", StringHelper.getDungeonTranslationKey(ModIds.NETHEREX.MOD_ID, "base_village"), new ResourceLocation(ModIds.NETHEREX.MOD_ID, "chest/base_village"));
    }

    @Override
    public void registerModEntities() {
        this.registerHostile();
        this.registerNeutral();
        this.registerPassive();
    }

    @Override
    public void registerModVillagers() {
        CustomVillagerRegistry registry = CustomVillagerRegistry.getInstance();
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateArmorsmith) {
            registry.addVillagerEntry(this.getPigtificateArmorsmith());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateBrewer) {
            registry.addVillagerEntry(this.getPigtificateBrewer());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateChief) {
            registry.addVillagerEntry(this.getPigtificateChief());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateEnchanter) {
            registry.addVillagerEntry(this.getPigtificateEnchanter());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateGatherer) {
            registry.addVillagerEntry(this.getPigtificateGatherer());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateHunter) {
            registry.addVillagerEntry(this.getPigtificateHunter());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateNincompoop) {
            registry.addVillagerEntry(this.getPigtificateNincompoop());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateScavenger) {
            registry.addVillagerEntry(this.getPigtificateScavenger());
        }
        if (this.jerConfig.JER_VILLAGERS.enablePigtificateToolsmith) {
            registry.addVillagerEntry(this.getPigtificateToolsmith());
        }
    }

    private void registerHostile() {
        if (this.jerConfig.JER_MOBS.enableGhastQueen) {
            EntityGhastQueen ghastQueen = new EntityGhastQueen(this.world);
            this.registerMob((EntityLivingBase)ghastQueen, LightLevel.hostile, new String[]{"None"}, NetherExLootTables.GHAST_QUEEN);
            this.registerRenderHook(ghastQueen.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                GlStateManager.func_179137_b((double)-0.05, (double)-1.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableBrute) {
            this.registerMob((EntityLivingBase)new EntityBrute(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.ARCTIC_ABYSS}), NetherExLootTables.BRUTE);
            this.adjustHumanoidRenderHook(EntityBrute.class);
        }
        if (this.jerConfig.JER_MOBS.enableCoolmarSpider) {
            this.registerMob((EntityLivingBase)new EntityCoolmarSpider(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.ARCTIC_ABYSS}), NetherExLootTables.COOLMAR_SPIDER);
            this.adjustHumanoidRenderHook(EntityCoolmarSpider.class);
        }
        if (this.jerConfig.JER_MOBS.enableEmber) {
            this.registerMob((EntityLivingBase)new EntityEmber(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.TORRID_WASTELAND}), NetherExLootTables.EMBER);
        }
        if (this.jerConfig.JER_MOBS.enableFrost) {
            this.registerMob((EntityLivingBase)new EntityFrost(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.ARCTIC_ABYSS}), NetherExLootTables.FROST);
            this.adjustHumanoidRenderHook(EntityFrost.class);
        }
        if (this.jerConfig.JER_MOBS.enableGhastling) {
            this.registerMob((EntityLivingBase)new EntityGhastling(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes("NETHER"), NetherExLootTables.GHASTLING);
            this.registerRenderHook(EntityGhastling.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableNethermite) {
            this.registerMob((EntityLivingBase)new EntityNethermite(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes("NETHER"), NetherExLootTables.NETHERMITE);
            this.registerRenderHook(EntityNethermite.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableSpinout) {
            this.registerMob((EntityLivingBase)new EntitySpinout(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.RUTHLESS_SANDS}), NetherExLootTables.SPINOUT);
            this.adjustHumanoidRenderHook(EntitySpinout.class);
        }
        if (this.jerConfig.JER_MOBS.enableSpore) {
            this.registerMob((EntityLivingBase)new EntitySpore(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.FUNGI_FOREST}), NetherExLootTables.SPORE);
            this.adjustHumanoidRenderHook(EntitySpore.class);
        }
        if (this.jerConfig.JER_MOBS.enableSporeCreeper) {
            this.registerMob((EntityLivingBase)new EntitySporeCreeper(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.FUNGI_FOREST}), NetherExLootTables.SPORE_CREEPER);
            this.adjustHumanoidRenderHook(EntitySporeCreeper.class);
        }
        if (this.jerConfig.JER_MOBS.enableWight) {
            this.registerMob((EntityLivingBase)new EntityWight(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.ARCTIC_ABYSS}), NetherExLootTables.WIGHT);
            this.adjustHumanoidRenderHook(EntityWight.class);
        }
    }

    private void registerNeutral() {
        if (this.jerConfig.JER_MOBS.enableGoldGolem) {
            EntityGoldGolem goldGolem = new EntityGoldGolem(this.world);
            this.registerMob((EntityLivingBase)goldGolem, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.GOLD_GOLEM);
        }
        if (this.jerConfig.JER_MOBS.enableMogusBrown) {
            EntityMogus mogusBrown = new EntityMogus(this.world);
            mogusBrown.setType(EntityMogus.Type.BROWN);
            this.registerMob((EntityLivingBase)mogusBrown, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.FUNGI_FOREST}), NetherExLootTables.BROWN_MOGUS);
        }
        if (this.jerConfig.JER_MOBS.enableMogusRed) {
            EntityMogus mogusRed = new EntityMogus(this.world);
            mogusRed.setType(EntityMogus.Type.RED);
            this.registerMob((EntityLivingBase)mogusRed, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.FUNGI_FOREST}), NetherExLootTables.RED_MOGUS);
        }
        if (this.jerConfig.JER_MOBS.enableMogusWhite) {
            EntityMogus mogusWhite = new EntityMogus(this.world);
            mogusWhite.setType(EntityMogus.Type.WHITE);
            this.registerMob((EntityLivingBase)mogusWhite, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.FUNGI_FOREST}), NetherExLootTables.WHITE_MOGUS);
        }
        if (this.jerConfig.JER_MOBS.enableSalamanderBlack) {
            EntitySalamander salamanderBlack = new EntitySalamander(this.world);
            salamanderBlack.setType(EntitySalamander.Type.BLACK);
            this.registerMob((EntityLivingBase)salamanderBlack, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.TORRID_WASTELAND}), NetherExLootTables.BLACK_SALAMANDER);
        }
        if (this.jerConfig.JER_MOBS.enableSalamanderOrange) {
            EntitySalamander salamanderOrange = new EntitySalamander(this.world);
            salamanderOrange.setType(EntitySalamander.Type.ORANGE);
            this.registerMob((EntityLivingBase)salamanderOrange, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{NetherExBiomes.TORRID_WASTELAND}), NetherExLootTables.ORANGE_SALAMANDER);
        }
    }

    private void registerPassive() {
        if (this.jerConfig.JER_MOBS.enablePigtificateVillagers) {
            EntityPigtificate pigtificateGatherer = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
            pigtificateGatherer.setCareer((PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)"gatherer")));
            this.registerMob((EntityLivingBase)pigtificateGatherer, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_GATHERER);
            EntityPigtificate pigtificateHunter = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
            pigtificateHunter.setCareer((PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)"hunter")));
            this.registerMob((EntityLivingBase)pigtificateHunter, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_HUNTER);
            EntityPigtificate pigtificateScavenger = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
            pigtificateScavenger.setCareer((PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)"scavenger")));
            this.registerMob((EntityLivingBase)pigtificateScavenger, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_SCAVENGER);
            EntityPigtificate pigtificateArmorsmith = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.SMITH);
            pigtificateArmorsmith.setCareer((PigtificateProfession.Career)NetherExPigtificates.SMITH.getCareer(NetherEx.getResource((String)"armorsmith")));
            this.registerMob((EntityLivingBase)pigtificateArmorsmith, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_ARMORSMITH);
            EntityPigtificate pigtificateToolsmith = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.SMITH);
            pigtificateToolsmith.setCareer((PigtificateProfession.Career)NetherExPigtificates.SMITH.getCareer(NetherEx.getResource((String)"toolsmith")));
            this.registerMob((EntityLivingBase)pigtificateToolsmith, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_TOOLSMITH);
            EntityPigtificate pigtificateSorcerer = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.SORCERER);
            pigtificateSorcerer.setCareer((PigtificateProfession.Career)NetherExPigtificates.SORCERER.getCareer(NetherEx.getResource((String)"brewer")));
            this.registerMob((EntityLivingBase)pigtificateSorcerer, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_BREWER);
            EntityPigtificate pigtificateEnchanter = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.SORCERER);
            pigtificateEnchanter.setCareer((PigtificateProfession.Career)NetherExPigtificates.SORCERER.getCareer(NetherEx.getResource((String)"enchanter")));
            this.registerMob((EntityLivingBase)pigtificateEnchanter, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_ENCHANTER);
            EntityPigtificate pigtificateDimwit = new EntityPigtificate(this.world, (PigtificateProfession)NetherExPigtificates.DIMWIT);
            pigtificateDimwit.setCareer((PigtificateProfession.Career)NetherExPigtificates.DIMWIT.getCareer(NetherEx.getResource((String)"nincompoop")));
            this.registerMob((EntityLivingBase)pigtificateDimwit, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_NINCOMPOOP);
        }
        if (this.jerConfig.JER_MOBS.enablePigtificateLeader) {
            EntityPigtificateLeader pigtificateLeader = new EntityPigtificateLeader(this.world);
            pigtificateLeader.setProfession((PigtificateProfession)NetherExPigtificates.LEADER);
            pigtificateLeader.setCareer((PigtificateProfession.Career)NetherExPigtificates.LEADER.getCareer(NetherEx.getResource((String)"chief")));
            this.registerMob((EntityLivingBase)pigtificateLeader, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), NetherExLootTables.PIGTIFICATE_CHIEF);
        }
        this.adjustHumanoidRenderHook(EntityPigtificate.class);
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> entity) {
        this.registerRenderHook(entity, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
            return renderInfo;
        });
    }

    private CustomVillagerEntry getPigtificateArmorsmith() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "armorsmith";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.ORANGE_SALAMANDER_HIDE, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack((Item)NetherExItems.BLACK_SALAMANDER_HIDE, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1), new ItemStack((Item)NetherExItems.WITHER_BONE, 12)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHER_BONE, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.ORANGE_SALAMANDER_HIDE_HELMET), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.ORANGE_SALAMANDER_HIDE_CHESTPLATE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.ORANGE_SALAMANDER_HIDE_LEGGINGS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.ORANGE_SALAMANDER_HIDE_BOOTS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.BLACK_SALAMANDER_HIDE_HELMET), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.BLACK_SALAMANDER_HIDE_CHESTPLATE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.BLACK_SALAMANDER_HIDE_LEGGINGS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack((Item)NetherExItems.BLACK_SALAMANDER_HIDE_BOOTS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.WITHER_BONE_HELMET), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHER_BONE_CHESTPLATE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHER_BONE_LEGGINGS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHER_BONE_BOOTS), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.SMITH.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.SMITH);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateBrewer() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "brewer";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.SPORE, 4), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151064_bs, 4), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151069_bo, 5), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(ItemHelper.getRandomPotion(), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151065_br, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 9)), new BasicTrade(ItemHelper.getRandomPotion(), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(ItemHelper.getRandomPotion(), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.SORCERER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.SORCERER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateChief() {
        String careerName = "chief";
        List<List<EntityVillager.ITradeList>> allTrades = NetherExConfig.entity.pigtificate.useGlobalTradeConfigs ? this.readPigtificateTradeConfigs(careerName) : new ArrayList<List<EntityVillager.ITradeList>>();
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.LEADER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificateLeader entity = new EntityPigtificateLeader(JERNetherEx.this.world);
                entity.setProfession((PigtificateProfession)NetherExPigtificates.LEADER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateEnchanter() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "enchanter";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151122_aG, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 7)), new BasicTrade(new ItemStack(Items.field_151114_aO, 4), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2), new ItemStack(Items.field_151072_bj, 6)), new BasicTrade(ItemHelper.getRandomlyEnchantedBook(6), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4, 16))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(ItemHelper.getRandomlyEnchantedBook(8), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 20)), new BasicTrade(ItemHelper.getRandomlyEnchantedBook(8), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 20))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151062_by, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 12)), new BasicTrade(ItemHelper.getRandomlyEnchantedBook(10), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 30)), new BasicTrade(ItemHelper.getRandomlyEnchantedBook(10), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 30)), new BasicTrade(ItemHelper.getRandomlyEnchantedBook(10), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 30))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.SORCERER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.SORCERER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateGatherer() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "gatherer";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.CONGEALED_MAGMA_CREAM, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack((Block)NetherExBlocks.BROWN_ELDER_MUSHROOM, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Block)NetherExBlocks.RED_ELDER_MUSHROOM, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1), new ItemStack((Item)NetherExItems.WITHER_BONE, 48))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.ENOKI_MUSHROOM, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3), new ItemStack(Items.field_151128_bU, 14))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151075_bm, 4), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateHunter() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "hunter";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151078_bh, 15), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151070_bp, 6), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151064_bs, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.GHAST_MEAT_COOKED, 7), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2), new ItemStack((Item)NetherExItems.GHAST_MEAT_RAW, 1))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151079_bi, 4), new ItemStack((Item)NetherExItems.GHAST_MEAT_RAW, 6)), new BasicTrade(new ItemStack(Items.field_151072_bj, 4), new ItemStack((Item)NetherExItems.GHAST_MEAT_RAW, 6))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateNincompoop() {
        String careerName = "nincompoop";
        List<List<EntityVillager.ITradeList>> allTrades = NetherExConfig.entity.pigtificate.useGlobalTradeConfigs ? this.readPigtificateTradeConfigs(careerName) : new ArrayList<List<EntityVillager.ITradeList>>();
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.DIMWIT.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.DIMWIT);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateScavenger() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "scavenger";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Blocks.field_150347_e, 10), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1), new ItemStack(Blocks.field_150348_b, 24)), new BasicTrade(new ItemStack(Blocks.field_150346_d, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Blocks.field_150351_n, 12), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Blocks.field_150364_r, 3), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 6)), new BasicTrade(new ItemStack(Items.field_151042_j, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151044_h, 5, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1)), new BasicTrade(new ItemStack(Items.field_151044_h, 5, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151045_i, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 6)), new BasicTrade(new ItemStack(Items.field_151122_aG, 2), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.FORAGER.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.FORAGER);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private CustomVillagerEntry getPigtificateToolsmith() {
        List<List<EntityVillager.ITradeList>> allTrades;
        String careerName = "toolsmith";
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            allTrades = this.readPigtificateTradeConfigs(careerName);
        } else {
            allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3), new ItemStack(Items.field_151043_k, 3)), new BasicTrade(new ItemStack(Items.field_151052_q), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack(Items.field_151050_s), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack(Items.field_151051_r), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2)), new BasicTrade(new ItemStack(Items.field_151018_J), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 1))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack(Items.field_151045_i, 1), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack(Items.field_151040_l), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack(Items.field_151035_b), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack(Items.field_151037_a), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack(Items.field_151019_K), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 2))})));
            allTrades.add(new ArrayList(Sets.newHashSet((Object[])new BasicTrade[]{new BasicTrade(new ItemStack((Item)NetherExItems.WITHERED_AMEDIAN_SWORD), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHERED_AMEDIAN_PICKAXE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHERED_AMEDIAN_SHOVEL), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHERED_AMEDIAN_HOE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack((Item)NetherExItems.WITHERED_AMEDIAN_HAMMER), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 6)), new BasicTrade(new ItemStack((Item)NetherExItems.BLAZED_AMEDIAN_SWORD), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4, 7)), new BasicTrade(new ItemStack((Item)NetherExItems.BLAZED_AMEDIAN_PICKAXE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.BLAZED_AMEDIAN_SHOVEL), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack((Item)NetherExItems.BLAZED_AMEDIAN_HOE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack((Item)NetherExItems.BLAZED_AMEDIAN_HAMMER), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 6)), new BasicTrade(new ItemStack((Item)NetherExItems.FROSTED_AMEDIAN_SWORD), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.FROSTED_AMEDIAN_PICKAXE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 5)), new BasicTrade(new ItemStack((Item)NetherExItems.FROSTED_AMEDIAN_SHOVEL), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 4)), new BasicTrade(new ItemStack((Item)NetherExItems.FROSTED_AMEDIAN_HOE), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 3)), new BasicTrade(new ItemStack((Item)NetherExItems.FROSTED_AMEDIAN_HAMMER), new ItemStack((Item)NetherExItems.AMETHYST_CRYSTAL, 6))})));
        }
        final PigtificateProfession.Career career = (PigtificateProfession.Career)NetherExPigtificates.SMITH.getCareer(NetherEx.getResource((String)careerName));
        String name = NetherEx.getResource((String)("pigtificate_" + careerName)).toString();
        return new CustomVillagerEntry(name, career.getId(), allTrades){

            @Override
            public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                EntityPigtificate entity = new EntityPigtificate(JERNetherEx.this.world, (PigtificateProfession)NetherExPigtificates.SMITH);
                entity.setCareer(career);
                return entity;
            }
        };
    }

    private List<List<EntityVillager.ITradeList>> readPigtificateTradeConfigs(String careerName) {
        Path tradeConfigPath = Paths.get(Loader.instance().getConfigDir().toString(), "netherex", "pigtificate_trades", "netherex", careerName + ".json");
        ArrayList<List<EntityVillager.ITradeList>> allTrades = new ArrayList<List<EntityVillager.ITradeList>>();
        try {
            if (!Files.exists(tradeConfigPath, new LinkOption[0])) {
                return allTrades;
            }
            LogHelper.info("Reading Pigtificate trade config. " + tradeConfigPath);
            File configFile = tradeConfigPath.toFile();
            if (FileHelper.getFileExtension((File)configFile).equals("json") && Files.isReadable(tradeConfigPath)) {
                String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(fileText, JsonObject.class);
                PigtificateProfession profession = (PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation(jsonObject.get("profession").getAsString()));
                PigtificateProfession.Career career = (PigtificateProfession.Career)profession.getCareer(new ResourceLocation(jsonObject.get("career").getAsString()));
                JsonArray tradeConfigs = jsonObject.get("trades").getAsJsonArray();
                for (JsonElement trade : tradeConfigs) {
                    int tradeLevel;
                    ItemStack output = ItemHelper.getItemStack(trade.getAsJsonObject().get("output").getAsJsonObject());
                    ItemStack input1 = ItemHelper.getItemStack(trade.getAsJsonObject().get("inputOne").getAsJsonObject());
                    ItemStack input2 = trade.getAsJsonObject().has("inputTwo") ? ItemHelper.getItemStack(trade.getAsJsonObject().get("inputTwo").getAsJsonObject()) : ItemStack.field_190927_a;
                    int n = tradeLevel = trade.getAsJsonObject().has("tradeLevel") ? trade.getAsJsonObject().get("tradeLevel").getAsInt() : 1;
                    if (allTrades.size() < tradeLevel) {
                        for (int i = allTrades.size(); i < tradeLevel; ++i) {
                            allTrades.add(i, new ArrayList());
                        }
                    }
                    ((List)allTrades.get(tradeLevel - 1)).add(new BasicTrade(output, input1, input2));
                }
            }
        }
        catch (Exception e) {
            LogHelper.warn("Error reading Pigtificate trade config. " + tradeConfigPath);
        }
        return allTrades;
    }
}

