/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedRandomizer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;

public class JERRoguelikeDungeons
extends JERBase
implements IJERIntegration {
    private Random rand = new Random();

    public JERRoguelikeDungeons(boolean enableJERDungeons) {
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
    }

    @Override
    public void registerModDungeons() {
        try {
            TreeMap<Integer, ArrayList> floorLoot = new TreeMap<Integer, ArrayList>();
            ILoot allLoot = Loot.getLoot();
            Field allLootLootField = allLoot.getClass().getDeclaredField("loot");
            allLootLootField.setAccessible(true);
            HashMap allLootLoot = (HashMap)allLootLootField.get(allLoot);
            for (int i = 0; i < allLootLoot.size(); ++i) {
                floorLoot.put(i, new ArrayList());
            }
            allLootLoot.forEach((floor, lootSetting) -> {
                try {
                    Field lootField = lootSetting.getClass().getDeclaredField("loot");
                    lootField.setAccessible(true);
                    HashMap loot = (HashMap)lootField.get(lootSetting);
                    for (Loot type : loot.keySet()) {
                        try {
                            ArrayList<LootEntry> lootEntries = new ArrayList<LootEntry>();
                            switch (type) {
                                case ARMOUR: {
                                    break;
                                }
                                case BLOCK: {
                                    lootEntries.addAll(this.weightedRandomizer(loot, type));
                                    break;
                                }
                                case BREWING: {
                                    break;
                                }
                                case ENCHANTBOOK: {
                                    break;
                                }
                                case ENCHANTBONUS: {
                                    break;
                                }
                                case FOOD: {
                                    lootEntries.addAll(this.hashMapWeightedRandomizer(loot, type, (int)floor));
                                    break;
                                }
                                case JUNK: {
                                    break;
                                }
                                case MUSIC: {
                                    break;
                                }
                                case ORE: {
                                    lootEntries.addAll(this.hashMapWeightedRandomizer(loot, type, (int)floor));
                                    break;
                                }
                                case POTION: {
                                    break;
                                }
                                case REWARD: {
                                    break;
                                }
                                case SMITHY: {
                                    break;
                                }
                                case SPECIAL: {
                                    break;
                                }
                                case SUPPLY: {
                                    break;
                                }
                                case TOOL: {
                                    break;
                                }
                            }
                            if (lootEntries.isEmpty()) continue;
                            ((ArrayList)floorLoot.get(floor)).add(new LootPool(lootEntries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), type.name()));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    LogHelper.warn("Failed to access Roguelike Dungeons Weighted loot pools.");
                }
            });
            floorLoot.forEach((floor, lootPools) -> this.registerDungeonLoot("roguelike:floor_" + floor, StringHelper.getDungeonTranslationKey(ModIds.ROGUELIKE_DUNGEONS.MOD_ID, "floor_" + floor), new LootTable(lootPools.toArray(new LootPool[0]))));
        }
        catch (Exception e) {
            LogHelper.warn("Failed to retrieve Roguelike Dungeons treasure loot.");
        }
    }

    private ArrayList<LootEntry> hashMapWeightedRandomizer(HashMap<Loot, ItemBase> loot, Loot type, int floor) throws NoSuchFieldException, IllegalAccessException {
        ItemBase itemBase = loot.get(type);
        Field itemBaseLootField = itemBase.getClass().getDeclaredField("loot");
        itemBaseLootField.setAccessible(true);
        HashMap itemBaseLoot = (HashMap)itemBaseLootField.get(itemBase);
        WeightedRandomizer weightedRandomizer = (WeightedRandomizer)itemBaseLoot.get(floor);
        return this.getLootEntries((WeightedRandomizer<ItemStack>)weightedRandomizer, this.rand);
    }

    private ArrayList<LootEntry> weightedRandomizer(HashMap<Loot, ItemBase> loot, Loot type) throws NoSuchFieldException, IllegalAccessException {
        ItemBase itemBase = loot.get(type);
        Field itemBaseLootField = itemBase.getClass().getDeclaredField("loot");
        itemBaseLootField.setAccessible(true);
        WeightedRandomizer weightedRandomizer = (WeightedRandomizer)itemBaseLootField.get(itemBase);
        return this.getLootEntries((WeightedRandomizer<ItemStack>)weightedRandomizer, this.rand);
    }

    private ArrayList<LootEntry> getLootEntries(WeightedRandomizer<ItemStack> weightedRandomizer, Random rand) throws NoSuchFieldException, IllegalAccessException {
        ArrayList<LootEntry> lootEntries = new ArrayList<LootEntry>();
        Field itemsField = weightedRandomizer.getClass().getDeclaredField("items");
        itemsField.setAccessible(true);
        List items = (List)itemsField.get(weightedRandomizer);
        for (IWeighted item : items) {
            int max;
            int min;
            try {
                Field minField = item.getClass().getDeclaredField("min");
                Field maxField = item.getClass().getDeclaredField("max");
                minField.setAccessible(true);
                maxField.setAccessible(true);
                min = (Integer)minField.get(item);
                max = (Integer)maxField.get(item);
            }
            catch (Exception e) {
                min = 1;
                max = 1;
            }
            ItemStack stack = (ItemStack)item.get(rand);
            stack.func_190920_e(1);
            int weight = item.getWeight();
            if (stack.func_77942_o()) {
                lootEntries.add((LootEntry)new LootEntryItem(stack.func_77973_b(), weight, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)stack.func_77952_i(), (float)stack.func_77952_i())), new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max)), new SetNBT(new LootCondition[0], stack.func_77978_p())}, new LootCondition[0], stack.func_77973_b().getRegistryName().toString()));
                continue;
            }
            lootEntries.add((LootEntry)new LootEntryItem(stack.func_77973_b(), weight, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)stack.func_77952_i(), (float)stack.func_77952_i())), new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max))}, new LootCondition[0], stack.func_77973_b().getRegistryName().toString()));
        }
        return lootEntries;
    }
}

