/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.girafi.waddles.Waddles;
import com.girafi.waddles.entity.EntityAdeliePenguin;
import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigWaddles;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class JERWaddles
extends JERBase
implements IJERIntegration {
    private final JEMConfigWaddles.JER jerConfig;

    public JERWaddles(boolean enableJERMobs) {
        this.jerConfig = JEMConfig.WADDLES.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModEntities() {
        if (!this.jerConfig.enablePenguin) {
            return;
        }
        try {
            int minExp = 0;
            int maxExp = 0;
            if (ConfigurationHandler.dropExp) {
                minExp = 1;
                maxExp = 3;
            }
            ResourceLocation loot = ConfigurationHandler.dropFish ? Waddles.LOOT_ENTITIES_PENGUIN_FISH : Waddles.EMPTY;
            Field f = PenguinRegistry.class.getDeclaredField("biomes");
            f.setAccessible(true);
            Iterable iterable = (Iterable)f.get(new PenguinRegistry());
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            for (Biome biome : iterable) {
                biomes.add(biome);
            }
            this.registerMob((EntityLivingBase)new EntityAdeliePenguin(this.world), LightLevel.any, minExp, maxExp, BiomeHelper.getBiomeNamesForBiomes(biomes.toArray(new Biome[0])), loot);
            this.registerRenderHook(EntityAdeliePenguin.class, (renderInfo, entity) -> {
                GlStateManager.func_179139_a((double)1.7, (double)1.7, (double)1.7);
                return renderInfo;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

