/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.registry;

import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jeresources.util.MapKeys;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class LootBagRegistry {
    private Map<String, LootBagEntry> registry = new LinkedHashMap<String, LootBagEntry>();
    private static LootBagRegistry instance;

    public static LootBagRegistry getInstance() {
        return instance != null ? instance : (instance = new LootBagRegistry());
    }

    public boolean registerLootBag(LootBagEntry entry) {
        String key = MapKeys.getKey((ItemStack)entry.getLootBag());
        if (key == null || this.registry.containsKey(key)) {
            return false;
        }
        this.registry.put(key, entry);
        return true;
    }

    public String getNumStacks(LootBagEntry entry) {
        int max = entry.getMaxStacks();
        int min = entry.getMinStacks();
        return min == max ? I18n.func_135052_a((String)"jer.stacks", (Object[])new Object[]{max}) : I18n.func_135052_a((String)"jer.stacks", (Object[])new Object[]{min + " - " + max});
    }

    public List<LootBagEntry> getAllLootBags() {
        return new ArrayList<LootBagEntry>(this.registry.values());
    }
}

