/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.util;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.util.ConfigHelper;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeHelper {
    public static String[] getBiomeNamesForBiomes(Biome ... biomes) {
        String[] stringArray;
        ArrayList<String> biomeNames = new ArrayList<String>();
        if (!JEMConfig.MODULE_JER.enableJERSpawnBiomes) {
            return new String[]{"jer.any"};
        }
        for (Biome biome : biomes) {
            biomeNames.add(WordUtils.capitalizeFully((String)biome.func_185359_l()));
        }
        if (!biomeNames.isEmpty()) {
            stringArray = biomeNames.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        }
        return stringArray;
    }

    public static String[] getBiomeNamesForBiomes(String ... biomes) {
        String[] stringArray;
        ArrayList<String> biomeNames = new ArrayList<String>();
        if (!JEMConfig.MODULE_JER.enableJERSpawnBiomes) {
            return new String[]{"jer.any"};
        }
        for (String biome : biomes) {
            if (biome == null || !ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
            String validBiome = WordUtils.capitalizeFully((String)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biome))).func_185359_l());
            biomeNames.add(validBiome);
        }
        if (!biomeNames.isEmpty()) {
            stringArray = biomeNames.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        }
        return stringArray;
    }

    public static String[] getBiomeNamesForTypes(String ... types) {
        ArrayList biomeNames = new ArrayList();
        for (String typeStr : types) {
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)typeStr, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            biomeNames.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        return BiomeHelper.getBiomeNamesForBiomes(biomeNames.toArray(new Biome[0]));
    }

    public static String[] getBiomeNamesForTypes(BiomeDictionary.Type ... types) {
        ArrayList biomeNames = new ArrayList();
        for (BiomeDictionary.Type type : types) {
            biomeNames.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        return BiomeHelper.getBiomeNamesForBiomes(biomeNames.toArray(new Biome[0]));
    }

    public static String[] getTypeNamesForTypes(BiomeDictionary.Type ... types) {
        String[] stringArray;
        ArrayList<String> typeNames = new ArrayList<String>();
        if (!JEMConfig.MODULE_JER.enableJERSpawnBiomes) {
            return new String[]{"jer.any"};
        }
        for (BiomeDictionary.Type type : types) {
            typeNames.add(WordUtils.capitalizeFully((String)type.getName()));
        }
        if (!typeNames.isEmpty()) {
            stringArray = typeNames.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        }
        return stringArray;
    }

    public static String[] getBiomeNames(String[] validBiomeTypes) {
        return BiomeHelper.getBiomeNames(validBiomeTypes, new String[0]);
    }

    public static String[] getBiomeNames(ConfigHelper.MobJER mobJER) {
        return BiomeHelper.getBiomeNames(mobJER.validBiomeTypes, mobJER.invalidBiomeTypes);
    }

    public static String[] getBiomeNames(String[] validBiomeTypes, String[] invalidBiomeTypes) {
        BiomeDictionary.Type type;
        ArrayList spawnBiomes = new ArrayList();
        for (String typeStr : validBiomeTypes) {
            type = BiomeDictionary.Type.getType((String)typeStr, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            spawnBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        for (String typeStr : invalidBiomeTypes) {
            type = BiomeDictionary.Type.getType((String)typeStr, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            spawnBiomes.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        if (spawnBiomes.isEmpty()) {
            return new String[]{"None"};
        }
        if (spawnBiomes.size() > 30) {
            return new String[]{"jer.any"};
        }
        return BiomeHelper.getBiomeNamesForBiomes(spawnBiomes.toArray(new Biome[0]));
    }
}

