/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.util.modhelpers;

import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemDragonFlesh;
import com.github.alexthe666.iceandfire.item.ItemDragonScales;
import com.github.alexthe666.iceandfire.item.ItemDragonSkull;
import com.github.alexthe666.iceandfire.item.ItemSeaSerpentScales;
import com.github.alexthe666.iceandfire.loot.CustomizeToDragon;
import com.github.alexthe666.iceandfire.loot.CustomizeToSeaSerpent;
import com.invadermonky.justenoughmagiculture.init.InitIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMConditional;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import jeresources.api.drop.LootDrop;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class IaFLootHelper {
    public static List<LootDrop> toDrops(EntityLivingBase entity, LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTableManager manager = InitIntegration.manager;
        IaFLootHelper.getPools(table).forEach(pool -> {
            float totalWeight = IaFLootHelper.getEntries(pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            List<LootCondition> poolConditions = IaFLootHelper.getConditions(pool);
            IaFLootHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryItem).map(entry -> (LootEntryItem)entry).map(entry -> new CustomLootDrop(entity, IaFLootHelper.getItem(entry), (float)entry.func_186361_a(0.0f) / totalWeight, IaFLootHelper.getConditions((LootEntry)entry), IaFLootHelper.getFunctions(entry))).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            IaFLootHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryTable).map(entry -> (LootEntryTable)entry).map(entry -> IaFLootHelper.toDrops(entity, manager.func_186521_a(IaFLootHelper.getTable(entry)))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static ResourceLocation getTable(LootEntryTable lootEntry) {
        return (ResourceLocation)ObfuscationReflectionHelper.getPrivateValue(LootEntryTable.class, (Object)lootEntry, (String)"field_186371_a");
    }

    public static RandomValueRange getMetaRange(SetMetadata function) {
        return (RandomValueRange)ObfuscationReflectionHelper.getPrivateValue(SetMetadata.class, (Object)function, (String)"field_186573_b");
    }

    public static List<LootPool> getPools(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    public static List<LootCondition> getConditions(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186454_b");
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
    }

    public static Item getItem(LootEntryItem lootEntry) {
        return (Item)ObfuscationReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"field_186368_a");
    }

    public static LootCondition[] getConditions(LootEntry lootEntry) {
        return (LootCondition[])ObfuscationReflectionHelper.getPrivateValue(LootEntry.class, (Object)lootEntry, (String)"field_186366_e");
    }

    public static LootFunction[] getFunctions(LootEntryItem lootEntry) {
        return (LootFunction[])ObfuscationReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"field_186369_b");
    }

    private static class CustomLootDrop
    extends LootDrop {
        public CustomLootDrop(EntityLivingBase entity, Item item, float chance, LootFunction ... lootFunctions) {
            super(new ItemStack(item), chance);
            this.enchanted = false;
            this.addLootFunctions(lootFunctions, entity);
        }

        public CustomLootDrop(EntityLivingBase entity, Item item, float chance, LootCondition[] lootConditions, LootFunction ... lootFunctions) {
            this(entity, item, chance, lootFunctions);
            this.addLootConditions(lootConditions);
        }

        public void addLootFunctions(LootFunction[] lootFunctions, EntityLivingBase entity) {
            this.addLootFunctions(Arrays.asList(lootFunctions), entity);
        }

        public void addLootFunctions(Collection<LootFunction> lootFunctions, EntityLivingBase entity) {
            lootFunctions.forEach(function -> this.addLootFunction((LootFunction)function, entity));
        }

        public void addLootFunction(LootFunction function, EntityLivingBase entity) {
            if (!ModIds.ICE_AND_FIRE.isLoaded || !this.applyIceAndFireFunctions(function, entity)) {
                super.addLootFunction(function);
            }
        }

        public boolean applyIceAndFireFunctions(LootFunction condition, EntityLivingBase entity) {
            if (condition instanceof CustomizeToDragon && entity instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)entity;
                if (this.item.func_77973_b() == IafItemRegistry.dragonbone) {
                    this.addConditional(JEMConditional.dependsOnAge);
                    this.minDrop = 1;
                    this.maxDrop = 64;
                    this.chance = 1.0f;
                } else if (this.item.func_77973_b() instanceof ItemDragonScales) {
                    this.addConditional(JEMConditional.dependsOnAge);
                    this.minDrop = 0;
                    this.maxDrop = 64;
                    this.chance = 1.0f;
                    this.item = new ItemStack(dragon.getVariantScale(dragon.getVariant()), this.item.func_190916_E(), this.item.func_77960_j());
                } else if (this.item.func_77973_b() instanceof ItemDragonEgg) {
                    this.addConditional(JEMConditional.isAdult);
                    this.chance = 1.0f;
                    this.item = new ItemStack(dragon.getVariantEgg(dragon.getVariant()), this.item.func_190916_E(), this.item.func_77960_j());
                } else if (this.item.func_77973_b() instanceof ItemDragonFlesh) {
                    this.addConditional(JEMConditional.dependsOnAge);
                    this.minDrop = 1;
                    this.maxDrop = 64;
                    this.chance = 1.0f;
                    this.item = new ItemStack(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.fire_dragon_flesh : IafItemRegistry.ice_dragon_flesh, this.item.func_190916_E(), this.item.func_77960_j());
                } else if (this.item.func_77973_b() instanceof ItemDragonSkull) {
                    ItemStack newSkull = new ItemStack(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.dragon_skull : IafItemRegistry.dragon_skull, this.item.func_190916_E(), this.item.func_77960_j());
                    newSkull.func_77982_d(this.item.func_77978_p());
                    this.item = newSkull;
                } else if (this.item.func_77973_b() == IafItemRegistry.fire_dragon_blood || this.item.func_77973_b() == IafItemRegistry.ice_dragon_blood) {
                    this.addConditional(JEMConditional.requiresBottle);
                    this.chance = 1.0f;
                    this.item = new ItemStack(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.fire_dragon_blood : IafItemRegistry.ice_dragon_blood, this.item.func_190916_E(), this.item.func_77960_j());
                } else if (this.item.func_77973_b() == IafItemRegistry.fire_dragon_heart || this.item.func_77973_b() == IafItemRegistry.ice_dragon_heart) {
                    this.chance = 1.0f;
                    this.item = new ItemStack(dragon.dragonType == DragonType.FIRE ? IafItemRegistry.fire_dragon_heart : IafItemRegistry.ice_dragon_heart, this.item.func_190916_E(), this.item.func_77960_j());
                }
            } else if (condition instanceof CustomizeToSeaSerpent && entity instanceof EntitySeaSerpent) {
                EntitySeaSerpent seaSerpent = (EntitySeaSerpent)entity;
                if (this.item.func_77973_b() instanceof ItemSeaSerpentScales) {
                    this.addConditional(JEMConditional.affectedByAncient);
                    this.addConditional(JEMConditional.dependsOnSize);
                    this.chance = 1.0f;
                    this.minDrop = 1;
                    this.maxDrop = 16;
                    this.item = new ItemStack(seaSerpent.getEnum().scale, this.item.func_190916_E(), this.item.func_77960_j());
                } else if (this.item.func_77973_b() == IafItemRegistry.sea_serpent_fang) {
                    this.addConditional(JEMConditional.affectedByAncient);
                    this.addConditional(JEMConditional.dependsOnSize);
                    this.chance = 1.0f;
                    this.minDrop = 1;
                    this.maxDrop = 11;
                }
            } else {
                return false;
            }
            return true;
        }
    }
}

