/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="simple_warp_commands")
@Mod.EventBusSubscriber
public class Configure {
    public static CommandsToggle commands = new CommandsToggle();
    @Config.RequiresWorldRestart
    @Config.Comment(value={"Record death locations for /back command"})
    public static boolean doBackRecordDeath = true;
    @Config.RequiresWorldRestart
    @Config.Comment(value={"Whether warps are dimension-locked", "true: Warps can ONLY be used within their original dimension", "false: Warps work across dimensions (when allowed by crossDimensionFilterMode)"})
    public static boolean warpsDimensionLocked = false;
    @Config.Comment(value={"Display coordinates of waypoints when using /warps"})
    public static boolean showWaypointCoords = true;
    @Config.Comment(value={"Require OP permissions to use commands"})
    public static boolean requireOp = false;
    @Config.Comment(value={"Control which dimension could teleport to and from.", "Syntax(may be empty for any dimension)", "from -> to", "e.g.", "\"-1 -> 1\", from nether(-1) to the end(1)"})
    @Config.Name(value="crossDimensionRules")
    public static String[] dimensionCrossAllowedList = new String[0];
    @Config.Comment(value={"Filtering mode for crossDimensionRules"})
    public static FilterMode crossDimensionFilterMode = FilterMode.BLACKLIST;
    @Config.Ignore
    public static final Set<IntIntEntry> crossDimensionRules = new HashSet<IntIntEntry>();

    private static boolean matchDimId(int from, int to) {
        return crossDimensionRules.contains(new IntIntEntry(from, to)) || crossDimensionRules.contains(new IntIntEntry(from, Integer.MAX_VALUE)) || crossDimensionRules.contains(new IntIntEntry(Integer.MAX_VALUE, to));
    }

    public static boolean couldTeleportTo(int from, int to) {
        return from == to || crossDimensionFilterMode.equals((Object)FilterMode.WHITELIST) == Configure.matchDimId(from, to);
    }

    public static void update() {
        for (String s : dimensionCrossAllowedList) {
            int index = s.indexOf("->");
            if (index == -1) {
                throw new IllegalStateException("Configure invalid: requires a '->' between dimension source and target");
            }
            String from = s.substring(0, index).trim();
            String to = s.substring(index + 2).trim();
            crossDimensionRules.add(new IntIntEntry(from.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(from), to.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(to)));
        }
    }

    @SubscribeEvent
    public static void onConfigurationChanged(ConfigChangedEvent e) {
        if (!Objects.equals(e.getModID(), "simple_warp_commands")) {
            return;
        }
        ConfigManager.sync((String)"simple_warp_commands", (Config.Type)Config.Type.INSTANCE);
        Configure.update();
    }

    public static class IntIntEntry
    implements Map.Entry<Integer, Integer> {
        int key;
        int value;

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            this.value = value;
            return this.value;
        }

        public IntIntEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntIntEntry)) {
                return false;
            }
            IntIntEntry that = (IntIntEntry)o;
            return this.key == that.key && this.value == that.value;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }

    public static enum FilterMode {
        BLACKLIST,
        WHITELIST;

    }

    public static class CommandsToggle {
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable the warp command family(/warp,/setwarp,/delwarp and /warps)"})
        public boolean enableWarpCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable the /home command family(/home and /sethome)"})
        public boolean enableHomeCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable the /back command"})
        public boolean enableBackCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable /spawn and /setspawn command"})
        public boolean enableSpawnCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable /tpp command"})
        public boolean enableTpPlayerCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable /pos command"})
        public boolean enablePosCommand = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable /bye command"})
        public boolean enableByeCommand = true;
    }
}

